/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.export.sumatra;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.catches.WeightComputingService;
import fr.ifremer.tutti.service.export.ExportBatchEntry;
import fr.ifremer.tutti.service.export.ExportCatchContext;
import fr.ifremer.tutti.service.export.sumatra.CatchRow;
import fr.ifremer.tutti.service.export.sumatra.CatchRowModel;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Export;
import org.nuiton.csv.ExportModel;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class CatchesSumatraExportService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(CatchesSumatraExportService.class);
    protected PersistenceService persistenceService;
    protected WeightComputingService weightComputingService;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.weightComputingService = this.getService(WeightComputingService.class);
    }

    public void exportCruiseForSumatra(File file, String cruiseId, ProgressionModel progressionModel) {
        Preconditions.checkNotNull((Object)cruiseId, (Object)"Cannot export a null cruise");
        Preconditions.checkNotNull((Object)file, (Object)"Cannot export to a null file");
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export cruise " + cruiseId + " to file: " + file));
        }
        progressionModel.increments(I18n.t((String)"tutti.service.sumatra.export.step.load.cruise", (Object[])new Object[]{cruiseId}));
        Cruise cruise = this.persistenceService.getCruise(cruiseId);
        Preconditions.checkNotNull((Object)cruise, (Object)("Cruise [" + cruiseId + "] not found"));
        progressionModel.increments(I18n.t((String)"tutti.service.sumatra.export.step.load.fishingOperationIds", (Object[])new Object[0]));
        List<String> operations = this.persistenceService.getAllFishingOperationIds(cruiseId);
        if (log.isInfoEnabled()) {
            log.info((Object)(operations.size() + " operations found for cruise: " + cruiseId));
        }
        progressionModel.adaptTotal(operations.size() + 3);
        this.prepareOperationsAndExport(file, operations, progressionModel);
    }

    public void exportFishingOperationForSumatra(File file, String cruiseId, String fishingOperationId, ProgressionModel progressionModel) {
        Preconditions.checkNotNull((Object)file, (Object)"Cannot export to a null file");
        Preconditions.checkNotNull((Object)cruiseId, (Object)"Cannot export a null cruise");
        Preconditions.checkNotNull((Object)fishingOperationId, (Object)"Cannot export a null fishing operation");
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export fishing operation " + fishingOperationId + " to file: " + file));
        }
        progressionModel.increments(I18n.t((String)"tutti.service.sumatra.export.step.load.cruise", (Object[])new Object[]{cruiseId}));
        Cruise cruise = this.persistenceService.getCruise(cruiseId);
        Preconditions.checkNotNull((Object)cruise, (Object)("Cruise [" + cruiseId + "] not found"));
        ArrayList operations = Lists.newArrayList((Object[])new String[]{fishingOperationId});
        this.prepareOperationsAndExport(file, operations, progressionModel);
    }

    protected void prepareOperationsAndExport(File file, List<String> operations, ProgressionModel progressionModel) {
        ArrayList rows = Lists.newArrayList();
        if (operations != null) {
            for (String operationId : operations) {
                progressionModel.increments(I18n.t((String)"tutti.service.sumatra.export.step.load.fishingOperation", (Object[])new Object[]{operationId}));
                if (!this.persistenceService.isFishingOperationWithCatchBatch(operationId)) {
                    if (!log.isWarnEnabled()) break;
                    log.warn((Object)("No catch for operation with id: " + operationId));
                    break;
                }
                this.prepareFishingOperation(rows, operationId);
            }
        }
        progressionModel.increments(I18n.t((String)"tutti.service.sumatra.export.step.export", (Object[])new Object[]{file}));
        CatchRowModel csvModel = new CatchRowModel(this.context.getConfig().getCsvSeparator());
        BufferedWriter writer = null;
        try {
            writer = Files.newWriter((File)file, (Charset)Charsets.UTF_8);
            Export export = Export.newExport((ExportModel)csvModel, (Iterable)rows);
            export.write((Writer)writer);
            writer.close();
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.sumatra.export.error", (Object[])new Object[]{file}), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    protected void prepareFishingOperation(List<CatchRow> rows, String operationId) {
        CatchRow row;
        List<ExportBatchEntry> entries;
        ExportCatchContext exportContext = ExportCatchContext.newExportContext(this.persistenceService, this.weightComputingService, operationId);
        FishingOperation operation = exportContext.getFishingOperation();
        if (exportContext.withSpeciesBatches()) {
            entries = exportContext.getSpeciesBatchEntry(true);
            for (ExportBatchEntry entry : entries) {
                row = new CatchRow();
                row.setFishingOperation(operation);
                row.setSpecies(entry.getBatch().getSpecies());
                row.setWeight(Float.valueOf(entry.getTotalWeight()));
                row.setNumber(entry.getTotalNumber());
                rows.add(row);
            }
        }
        if (exportContext.withBenthosBatches()) {
            entries = exportContext.getBenthosBatchEntry(true);
            for (ExportBatchEntry entry : entries) {
                row = new CatchRow();
                row.setFishingOperation(operation);
                row.setSpecies(entry.getBatch().getSpecies());
                row.setWeight(Float.valueOf(entry.getTotalWeight()));
                row.setNumber(entry.getTotalNumber());
                rows.add(row);
            }
        }
    }
}

