/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;

public class StreamUtil {
    public static final String lineSeparator = System.getProperty("line.separator");

    public static String getLineSeparator() {
        return lineSeparator;
    }

    public static String getStreamContents(InputStream ins) throws IOException {
        InputStreamReader reader = new InputStreamReader(ins);
        return StreamUtil.getReaderContents(reader);
    }

    public static String getStreamContents(InputStream ins, String charsetName) throws IOException {
        InputStreamReader reader = charsetName != null ? new InputStreamReader(ins, charsetName) : new InputStreamReader(ins);
        return StreamUtil.getReaderContents(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getReaderContents(Reader reader) throws IOException {
        try {
            int read;
            StringBuffer result = new StringBuffer();
            char[] buffer = new char[2048];
            while ((read = reader.read(buffer)) > -1) {
                result.append(buffer, 0, read);
            }
            String string = result.toString();
            return string;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ioe) {}
        }
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] bytes = new byte[1024];
        int r = inputStream.read(bytes);
        while (r > 0) {
            outputStream.write(bytes, 0, r);
            r = inputStream.read(bytes);
        }
    }
}

