/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import java.net.InetAddress;
import java.sql.Timestamp;
import java.util.Date;
import liquibase.database.Database;
import liquibase.database.typeconversion.TypeConverterFactory;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.core.LockDatabaseChangeLogStatement;
import liquibase.statement.core.UpdateStatement;
import liquibase.util.NetUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockDatabaseChangeLogGenerator
extends AbstractSqlGenerator<LockDatabaseChangeLogStatement> {
    @Override
    public ValidationErrors validate(LockDatabaseChangeLogStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        return new ValidationErrors();
    }

    @Override
    public Sql[] generateSql(LockDatabaseChangeLogStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        InetAddress localHost;
        String liquibaseSchema = null;
        liquibaseSchema = database.getLiquibaseSchemaName();
        try {
            localHost = NetUtil.getLocalHost();
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException(e);
        }
        UpdateStatement updateStatement = new UpdateStatement(liquibaseSchema, database.getDatabaseChangeLogLockTableName());
        updateStatement.addNewColumnValue("LOCKED", true);
        updateStatement.addNewColumnValue("LOCKGRANTED", new Timestamp(new Date().getTime()));
        updateStatement.addNewColumnValue("LOCKEDBY", localHost.getHostName() + " (" + localHost.getHostAddress() + ")");
        updateStatement.setWhereClause(database.escapeColumnName(liquibaseSchema, database.getDatabaseChangeLogTableName(), "ID") + " = 1 AND " + database.escapeColumnName(liquibaseSchema, database.getDatabaseChangeLogTableName(), "LOCKED") + " = " + TypeConverterFactory.getInstance().findTypeConverter(database).getBooleanType().getFalseBooleanValue());
        return SqlGeneratorFactory.getInstance().generateSql(updateStatement, database);
    }
}

