/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.sort;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.RowFilter;
import org.jdesktop.swingx.util.Contract;

public class RowFilters {
    public static <M, I> RowFilter<M, I> regexFilter(String regex, int ... indices) {
        return RowFilters.regexFilter(0, regex, indices);
    }

    public static <M, I> RowFilter<M, I> regexFilter(int matchFlags, String regex, int ... indices) {
        return RowFilters.regexFilter(Pattern.compile(regex, matchFlags), indices);
    }

    public static <M, I> RowFilter<M, I> regexFilter(Pattern pattern, int ... indices) {
        return new RegexFilter(pattern, indices);
    }

    private RowFilters() {
    }

    private static class RegexFilter
    extends GeneralFilter {
        private Matcher matcher;

        RegexFilter(Pattern regex, int[] columns) {
            super(columns);
            if (regex == null) {
                Contract.asNotNull((Object)regex, (String)"Pattern must be non-null");
            }
            this.matcher = regex.matcher("");
        }

        @Override
        protected boolean include(RowFilter.Entry<? extends Object, ? extends Object> value, int index) {
            this.matcher.reset(value.getStringValue(index));
            return this.matcher.find();
        }
    }

    public static abstract class GeneralFilter
    extends RowFilter<Object, Object> {
        private int[] columns;

        protected GeneralFilter(int ... columns) {
            this.checkIndices(columns);
            this.columns = columns;
        }

        @Override
        public boolean include(RowFilter.Entry<? extends Object, ? extends Object> value) {
            int count = value.getValueCount();
            if (this.columns.length > 0) {
                for (int i = this.columns.length - 1; i >= 0; --i) {
                    int index = this.columns[i];
                    if (index >= count || !this.include(value, index)) continue;
                    return true;
                }
            } else {
                while (--count >= 0) {
                    if (!this.include(value, count)) continue;
                    return true;
                }
            }
            return false;
        }

        protected abstract boolean include(RowFilter.Entry<? extends Object, ? extends Object> var1, int var2);

        protected void checkIndices(int[] columns) {
            for (int i = columns.length - 1; i >= 0; --i) {
                if (columns[i] >= 0) continue;
                throw new IllegalArgumentException("Index must be >= 0");
            }
        }
    }
}

