package fr.ifremer.tutti.ui.swing.util.auth;

/*
 * #%L
 * Tutti :: UI
 * $Id: LoginUIHandler.java 1584 2014-02-11 11:53:19Z tchemit $
 * $HeadURL: https://forge.codelutin.com/svn/tutti/tags/tutti-3.1.3/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/util/auth/LoginUIHandler.java $
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.spi.UIHandler;

import java.awt.Container;

import static org.nuiton.i18n.I18n.t;

/**
 * Created on 1/29/14.
 *
 * @author Tony Chemit <chemit@codelutin.com>
 * @since 3.1
 */
public class LoginUIHandler implements UIHandler<LoginUI> {

    protected LoginUI ui;

    protected AuthenticationInfo authenticationInfo;

    protected TuttiUIContext context;

    @Override
    public void beforeInit(LoginUI ui) {
        this.ui = ui;
        this.context = TuttiUIUtil.getApplicationContext(ui);
    }

    @Override
    public void afterInit(LoginUI ui) {
    }

    public void open(String url, AuthenticationInfo authenticationInfo) {

        ui.getInfoMessage().setText(t("tutti.login.infoMmessage", url));
        ui.getLoginField().setText(authenticationInfo == null ? null : authenticationInfo.getLogin());
        ui.getPasswordField().setText(authenticationInfo == null ? null : new String(authenticationInfo.getPassword()));
        ui.pack();

        Container parent = context.getMainUI();
        if (parent != null) {
            SwingUtil.center(parent, ui);
        }
        ui.setVisible(true);
    }

    public void cancel() {
        ui.dispose();
    }

    public void accept() {
        authenticationInfo = new AuthenticationInfo(ui.getLoginField().getText(),
                                                    ui.getPasswordField().getPassword());
        ui.dispose();
    }

    protected AuthenticationInfo getAuthenticationInfo() {
        return authenticationInfo;
    }
}
