/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.service.technical.sanity;

import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.service.technical.CacheService;
import fr.ifremer.adagio.core.service.technical.sanity.DatabaseSanityService;
import fr.ifremer.adagio.core.service.technical.sanity.task.DatabaseSanityTask;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import javax.annotation.Resource;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="databaseSanityService")
public class DatabaseSanityServiceImpl
implements DatabaseSanityService {
    @Autowired
    protected SessionFactory sessionFactory;
    @Resource(name="cacheService")
    protected CacheService cacheService;

    @Override
    public void sanity() {
        Session currentSession = this.sessionFactory.getCurrentSession();
        HashSet cacheIds = Sets.newHashSet();
        for (DatabaseSanityTask checker : ServiceLoader.load(DatabaseSanityTask.class)) {
            Set<String> ids = checker.sanity(currentSession);
            cacheIds.addAll(ids);
        }
        for (String cacheId : cacheIds) {
            this.cacheService.clearCache(cacheId);
        }
    }
}

