/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.impl;

import org.eclipse.birt.data.aggregation.i18n.Messages;
import org.eclipse.birt.data.aggregation.impl.AggrFunction;
import org.eclipse.birt.data.aggregation.impl.Constants;
import org.eclipse.birt.data.aggregation.impl.ParameterDefn;
import org.eclipse.birt.data.aggregation.impl.SummaryAccumulator;
import org.eclipse.birt.data.aggregation.impl.SupportedDataTypes;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;

public class TotalMin
extends AggrFunction {
    @Override
    public String getName() {
        return "MIN";
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public int getDataType() {
        return 0;
    }

    @Override
    public IParameterDefn[] getParameterDefn() {
        return new IParameterDefn[]{new ParameterDefn("Expression", Constants.EXPRESSION_DISPLAY_NAME, false, true, SupportedDataTypes.CALCULATABLE, "")};
    }

    @Override
    public Accumulator newAccumulator() {
        return new MyAccumulator();
    }

    @Override
    public String getDescription() {
        return Messages.getString("TotalMin.description");
    }

    @Override
    public String getDisplayName() {
        return Messages.getString("TotalMin.displayName");
    }

    private static class MyAccumulator
    extends SummaryAccumulator {
        private Object min = null;

        private MyAccumulator() {
        }

        @Override
        public void start() {
            super.start();
            this.min = null;
        }

        @Override
        public void onRow(Object[] args) {
            assert (args.length > 0);
            if (args[0] != null) {
                if (this.min == null) {
                    this.min = args[0];
                }
                if (this.isLessThan(args[0], this.min)) {
                    this.min = args[0];
                }
            }
        }

        private boolean isLessThan(Object origin, Object target) {
            if (origin instanceof Comparable && target instanceof Comparable) {
                return ((Comparable)origin).compareTo(target) < 0;
            }
            throw new RuntimeException(Messages.getString("TotalMin.exception.cannot_get_max_value"));
        }

        @Override
        public Object getSummaryValue() {
            return this.min;
        }
    }
}

