/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.shared.application.swing.tab;

import fr.ifremer.shared.application.swing.tab.TabContentModel;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.beans.BeanUtil;

public class CustomTab
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(CustomTab.class);
    protected TabContentModel model;
    protected JLabel title = new JLabel();

    public TabContentModel getModel() {
        return this.model;
    }

    public CustomTab(TabContentModel model) {
        this.model = model;
        try {
            BeanUtil.addPropertyChangeListener((PropertyChangeListener)new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    CustomTab.this.updateTitle();
                }
            }, (Object)this.model);
        }
        catch (Exception ex) {
            log.error((Object)"Error while adding the listener to the model modifications", (Throwable)ex);
        }
        this.setBackground(null);
        this.updateTitle();
        String actionIcon = model.getIcon();
        if (actionIcon != null) {
            this.title.setIcon(SwingUtil.createActionIcon((String)actionIcon));
        }
        this.add(this.title);
    }

    @Override
    public void setBackground(Color bg) {
        if (bg == null) {
            bg = new Color(0, 0, 0, 0);
        }
        super.setBackground(bg);
        this.revalidate();
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.title != null) {
            this.title.setForeground(fg);
        }
    }

    protected void updateTitle() {
        int style;
        Font f = UIManager.getDefaults().getFont("Label.font");
        String titleValue = I18n._((String)this.model.getTitle(), (Object[])new Object[0]);
        if (this.model.isModify()) {
            style = 1;
            titleValue = titleValue + "*";
        } else {
            style = this.model.isEmpty() ? 2 : 0;
        }
        this.title.setText(titleValue);
        this.title.setFont(f.deriveFont(style));
    }
}

