/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import fr.ifremer.shared.application.ApplicationIOUtil;
import fr.ifremer.shared.application.ApplicationTechnicalException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class RessourceClassLoader
extends ClassLoader {
    private static final Log log = LogFactory.getLog(RessourceClassLoader.class);
    public static final URL[] EMPTY_URL_ARRAY = new URL[0];
    protected URLClassLoader loader;
    protected Predicate<String> searchInDirectoriesPredicate = new Predicate<String>(){

        public boolean apply(String input) {
            return !RessourceClassLoader.this.directories.isEmpty();
        }
    };
    protected final List<File> directories = Lists.newArrayList();

    public RessourceClassLoader(ClassLoader parent) {
        super(parent);
        this.loader = URLClassLoader.newInstance(EMPTY_URL_ARRAY);
    }

    public void addDirectory(File ... directories) {
        for (File directory : directories) {
            if (this.directories.contains(directory)) continue;
            this.directories.add(directory);
            ApplicationIOUtil.forceMkdir((File)directory, (String)I18n._((String)"tutti.io.mkDir.error", (Object[])new Object[]{directory}));
        }
        this.loader = null;
    }

    public void removeDirectory(File ... directories) {
        for (File directory : directories) {
            this.directories.remove(directory);
        }
        this.loader = null;
    }

    public Predicate<String> getSearchInDirectoriesPredicate() {
        return this.searchInDirectoriesPredicate;
    }

    public void addSearchInDirectoriesPredicate(Predicate<String> predicate) {
        Preconditions.checkNotNull(predicate, (Object)"search predicate can not be null");
        this.searchInDirectoriesPredicate = Predicates.and(this.searchInDirectoriesPredicate, predicate);
    }

    public void setSearchInDirectoriesPredicate(Predicate<String> searchInDirectoriesPredicate) {
        Preconditions.checkNotNull(searchInDirectoriesPredicate, (Object)"search predicate can not be null");
        this.searchInDirectoriesPredicate = searchInDirectoriesPredicate;
    }

    @Override
    public URL findResource(String name) {
        URL result = null;
        if (this.searchInDirectoriesPredicate.apply((Object)name)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("findResource [" + name + "] in " + this.directories));
            }
            result = this.getLoader().findResource(name);
        }
        if (result == null) {
            result = super.findResource(name);
        }
        return result;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        Enumeration<URL> result = null;
        if (this.searchInDirectoriesPredicate.apply((Object)name)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("findResources [" + name + "] in " + this.directories));
            }
            result = this.getLoader().findResources(name);
        }
        if (result == null || !result.hasMoreElements()) {
            result = super.findResources(name);
        }
        return result;
    }

    @Override
    public URL getResource(String name) {
        URL result = null;
        if (this.searchInDirectoriesPredicate.apply((Object)name)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getResource [" + name + "] in " + this.directories));
            }
            result = this.getLoader().getResource(name);
        }
        if (result == null) {
            result = super.getResource(name);
        }
        return result;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> result = null;
        if (this.searchInDirectoriesPredicate.apply((Object)name)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getResources [" + name + "] in " + this.directories));
            }
            result = this.getLoader().getResources(name);
        }
        if (result == null || !result.hasMoreElements()) {
            result = super.getResources(name);
        }
        return result;
    }

    protected URLClassLoader getLoader() {
        if (this.loader == null) {
            try {
                URL[] urls = FileUtils.toURLs((File[])this.directories.toArray(new File[this.directories.size()]));
                this.loader = URLClassLoader.newInstance(urls, null);
            }
            catch (IOException e) {
                throw new ApplicationTechnicalException(I18n._((String)"tutti.persistence.loader.error", (Object[])new Object[]{this.directories}), (Throwable)e);
            }
        }
        return this.loader;
    }
}

