/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.script.internal.attribute;

import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.Text;
import org.eclipse.birt.chart.script.api.attribute.IText;
import org.eclipse.birt.chart.script.internal.ChartComponentUtil;
import org.eclipse.birt.report.model.api.extension.IColor;
import org.eclipse.birt.report.model.api.extension.IFont;

public class TextImpl
implements IText {
    private Text text;

    public TextImpl(Text text) {
        this.text = text;
    }

    @Override
    public String getValue() {
        return this.text.getValue();
    }

    @Override
    public void setValue(String value) {
        this.text.setValue(value);
    }

    @Override
    public IColor getColor() {
        ColorDefinition cd = this.text.getColor();
        if (cd == null) {
            cd = ChartComponentUtil.createEMFColor();
            this.text.setColor(cd);
        }
        return ChartComponentUtil.convertColor(cd);
    }

    @Override
    public IFont getFont() {
        FontDefinition fd = this.text.getFont();
        if (fd == null) {
            fd = ChartComponentUtil.createEMFFont();
            this.text.setFont(fd);
        }
        return ChartComponentUtil.convertFont(fd);
    }

    @Override
    public void setColor(IColor color) {
        this.text.setColor(ChartComponentUtil.convertIColor(color));
    }

    @Override
    public void setFont(IFont font) {
        this.text.setFont(ChartComponentUtil.convertIFont(font));
    }
}

