/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.service.export.sumatra.CatchesSumatraExportService;
import fr.ifremer.tutti.ui.swing.action.AbstractMainUITuttiAction;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import java.io.File;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.DateUtil;

public class ExportCruiseForSumatraAction
extends AbstractMainUITuttiAction {
    private static final Log log = LogFactory.getLog(ExportCruiseForSumatraAction.class);
    protected File file;

    public ExportCruiseForSumatraAction(MainUIHandler handler) {
        super(handler, false);
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            String date = DateUtil.formatDate((Date)new Date(), (String)"dd-MM-yyyy");
            this.file = this.saveFile(String.format("sumatra_%s_%s", this.getDataContext().getCruise().getName(), date), "csv", I18n._((String)"tutti.exportCruiseForSumatra.title.choose.exportFile", (Object[])new Object[0]), I18n._((String)"tutti.exportCruiseForSumatra.action.chooseFile", (Object[])new Object[0]), new String[]{"^.+\\.csv$", I18n._((String)"tutti.common.file.csv", (Object[])new Object[0])});
            doAction = this.file != null;
        }
        return doAction;
    }

    public void releaseAction() {
        this.file = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        Cruise cruise = this.getDataContext().getCruise();
        Preconditions.checkNotNull((Object)cruise);
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export cruise " + cruise.getId() + " to file: " + this.file));
        }
        ProgressionModel pm = new ProgressionModel();
        pm.setTotal(3);
        this.setProgressionModel(pm);
        CatchesSumatraExportService service = this.getContext().getCatchesSumatraExportService();
        service.exportCruiseForSumatra(this.file, cruise.getId(), pm);
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        this.sendMessage(I18n._((String)"tutti.exportCruiseForSumatra.action.success", (Object[])new Object[]{this.file}));
    }
}

