package fr.ifremer.tutti.ui.swing.action;

/*
 * #%L
 * Tutti :: UI
 * $Id: ImportProtocolBenthosAction.java 1388 2013-11-26 08:03:42Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-3.0/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/action/ImportProtocolBenthosAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.protocol.ProtocolImportExportService;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.File;
import java.util.List;

import static org.nuiton.i18n.I18n._;

/**
 * To import protocol benthos.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class ImportProtocolBenthosAction extends AbstractTuttiAction<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(ImportProtocolBenthosAction.class);

    private File file;

    public ImportProtocolBenthosAction(EditProtocolUIHandler handler) {
        super(handler, false);
    }

    @Override
    public boolean prepareAction() throws Exception {

        boolean doAction = super.prepareAction();

        if (doAction) {

            // choose file to import
            file = chooseFile(
                    _("tutti.editProtocol.title.choose.benthosImportFile"),
                    _("tutti.editProtocol.action.chooseProtocolBenthosFile"),
                    "^.*\\.csv", _("tutti.common.file.csv")
            );

            doAction = file != null;
        }
        return doAction;
    }

    @Override
    public void releaseAction() {
        file = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        Preconditions.checkNotNull(file);
        if (log.isInfoEnabled()) {
            log.info("Will import protocol benthos file: " + file);
        }

        EditProtocolUIModel model = getModel();

        // bind to a protocol
        TuttiProtocol protocol = model.toBean();

        // import
        ProtocolImportExportService service =
                getContext().getTuttiProtocolImportExportService();

        service.importProtocolBenthos(file,
                                      protocol,
                                      model.getAllCaracteristic(),
                                      model.getAllReferentSpeciesByTaxonId());

        // build rows from imported+merged protocol
        // (will also remove all synonyms of species referent used)
        List<EditProtocolSpeciesRowModel> rows =
                handler.toRows(protocol.getBenthos());

        // update species comboBox
        getUI().getSpeciesComboBox().getHandler().reset();

        // update benthos comboBox
        getUI().getBenthosComboBox().getHandler().reset();

        // update rows in model
        model.setBenthosRow(rows);

        getHandler().getBenthosTableModel().setRows(rows);

        int nbSynonym = 0;
        for (SpeciesProtocol speciesProtocol : protocol.getBenthos()) {
            if (!speciesProtocol.isMadeFromAReferentTaxon()) {
                nbSynonym++;
            }
        }

        String message;
        switch (nbSynonym) {
            case 0:
                message = _("tutti.flash.info.benthos.imported.in.protocol",
                            file);
                break;

            case 1:
                message = _("tutti.flash.info.benthos.imported.in.protocol.oneReplaced",
                            file);
                break;

            default:
                message = _("tutti.flash.info.benthos.imported.in.protocol.severalReplaced",
                            file, nbSynonym);
        }
        sendMessage(message);
    }
}