/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.accidental;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.AccidentalBatch;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.ValidationService;
import fr.ifremer.tutti.service.WeightUnit;
import fr.ifremer.tutti.ui.swing.content.operation.AbstractTuttiBatchTableUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.accidental.AccidentalBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.accidental.AccidentalBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.accidental.AccidentalBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.accidental.AccidentalBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.accidental.create.CreateAccidentalBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.accidental.create.CreateAccidentalBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchTableModel;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentCellEditor;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentCellRenderer;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapCellComponent;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapColumnUIHandler;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapEditorUI;
import fr.ifremer.tutti.ui.swing.util.comment.CommentCellEditor;
import fr.ifremer.tutti.ui.swing.util.comment.CommentCellRenderer;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.decorator.Decorator;
import org.nuiton.validator.NuitonValidatorResult;

public class AccidentalBatchUIHandler
extends AbstractTuttiBatchTableUIHandler<AccidentalBatchRowModel, AccidentalBatchUIModel, AccidentalBatchTableModel, AccidentalBatchUI>
implements CaracteristicMapColumnUIHandler {
    private static final Log log = LogFactory.getLog(AccidentalBatchUIHandler.class);
    protected ValidationService validationService = this.getContext().getValidationService();
    protected final WeightUnit weightUnit = this.getConfig().getAccidentalCatchWeightUnit();

    public AccidentalBatchUIHandler(TuttiUI<?, ?> parentUi, AccidentalBatchUI ui) {
        super(parentUi, ui, "species", "gender", "weight", "size", "lengthStepCaracteristic", "deadOrAlive", "caracteristics", "comment", "attachment");
    }

    @Override
    protected ColumnIdentifier<AccidentalBatchRowModel> getCommentIdentifier() {
        return AccidentalBatchTableModel.COMMENT;
    }

    @Override
    protected ColumnIdentifier<AccidentalBatchRowModel> getAttachementIdentifier() {
        return AccidentalBatchTableModel.ATTACHMENT;
    }

    @Override
    public void selectFishingOperation(FishingOperation bean) {
        ArrayList rows;
        boolean empty = bean == null;
        AccidentalBatchUIModel model = (AccidentalBatchUIModel)this.getModel();
        if (empty) {
            rows = null;
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Get accidental batch for fishingOperation: " + bean.getId()));
            }
            rows = Lists.newArrayList();
            if (!TuttiEntities.isNew(bean)) {
                List batches = this.persistenceService.getAllAccidentalBatch(bean.getId());
                for (AccidentalBatch aBatch : batches) {
                    AccidentalBatchRowModel entry = this.loadBatch(aBatch);
                    rows.add(entry);
                }
            }
        }
        model.setRows(rows);
    }

    @Override
    protected void beforeOpenPopup(int rowIndex, int columnIndex) {
        super.beforeOpenPopup(rowIndex, columnIndex);
        boolean enableRemove = false;
        if (rowIndex != -1) {
            enableRemove = true;
        }
        AccidentalBatchUIModel model = (AccidentalBatchUIModel)this.getModel();
        model.setRemoveBatchEnabled(enableRemove);
    }

    public AccidentalBatchTableModel getTableModel() {
        return (AccidentalBatchTableModel)this.getTable().getModel();
    }

    @Override
    public JXTable getTable() {
        return ((AccidentalBatchUI)this.ui).getTable();
    }

    @Override
    protected boolean isRowValid(AccidentalBatchRowModel row) {
        AccidentalBatch batch = (AccidentalBatch)row.toBean();
        NuitonValidatorResult validator = this.validationService.validateAccidentalBatch(batch);
        boolean result = !validator.hasErrorMessagess();
        return result;
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<AccidentalBatchRowModel> rowMonitor, AccidentalBatchRowModel row) {
        if (row != null && row.isValid() && rowMonitor.wasModified()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Row " + row + " was modified, will save it"));
            }
            String title = this.buildReminderLabelTitle(row.getSpecies(), null, "Sauvegarde de la capture accidentelle : ", "Ligne :" + (this.getTableModel().getRowIndex(row) + 1));
            this.showInformationMessage(title);
            rowMonitor.setBean(null);
            this.saveRow(row);
            rowMonitor.setBean(row);
            rowMonitor.clearModified();
        }
    }

    @Override
    public SwingValidator<AccidentalBatchUIModel> getValidator() {
        return null;
    }

    @Override
    public void beforeInitUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("beforeInit: " + this.ui));
        }
        EditCatchesUIModel catchesUIModel = ((AccidentalBatchUI)this.ui).getContextValue(EditCatchesUIModel.class);
        AccidentalBatchUIModel model = new AccidentalBatchUIModel(catchesUIModel);
        ((AccidentalBatchUI)this.ui).setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("afterInit: " + this.ui));
        }
        this.initUI(this.ui);
        JXTable table = this.getTable();
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        Decorator<CaracteristicQualitativeValue> caracteristicQualitativeValueDecorator = this.getDecorator(CaracteristicQualitativeValue.class, null);
        Decorator<Species> speciesDecorator = this.getDecorator(Species.class, "fromProtocol");
        this.addComboDataColumnToModel((TableColumnModel)columnModel, AccidentalBatchTableModel.SPECIES, speciesDecorator, this.getDataContext().getReferentSpecies());
        this.addComboDataColumnToModel((TableColumnModel)columnModel, AccidentalBatchTableModel.GENDER, caracteristicQualitativeValueDecorator, this.getDataContext().getGenderValues());
        this.addFloatColumnToModel((TableColumnModel)columnModel, AccidentalBatchTableModel.WEIGHT, this.weightUnit, (JTable)table);
        this.addFloatColumnToModel((TableColumnModel)columnModel, AccidentalBatchTableModel.SIZE, "\\d{0,6}(\\.\\d{0,3})?", (JTable)table);
        Decorator<Caracteristic> caracteristicDecorator = this.getDecorator(Caracteristic.class, null);
        this.addComboDataColumnToModel((TableColumnModel)columnModel, AccidentalBatchTableModel.LENGTH_STEP_CARACTERISTIC, caracteristicDecorator, this.getDataContext().getLengthStepCaracteristics());
        this.addComboDataColumnToModel((TableColumnModel)columnModel, AccidentalBatchTableModel.DEAD_OR_ALIVE, caracteristicQualitativeValueDecorator, this.getDataContext().getDeadOrAliveValues());
        this.addColumnToModel((TableColumnModel)columnModel, CaracteristicMapCellComponent.newEditor(this.ui, Sets.newHashSet()), CaracteristicMapCellComponent.newRender(this.getContext()), IndividualObservationBatchTableModel.OTHER_CARACTERISTICS);
        this.addColumnToModel((TableColumnModel)columnModel, CommentCellEditor.newEditor(this.ui), CommentCellRenderer.newRender(), AccidentalBatchTableModel.COMMENT);
        Decorator<Attachment> decorator = this.getDecorator(Attachment.class, null);
        this.addColumnToModel((TableColumnModel)columnModel, AttachmentCellEditor.newEditor(this.ui), AttachmentCellRenderer.newRender(decorator), AccidentalBatchTableModel.ATTACHMENT);
        AccidentalBatchTableModel tableModel = new AccidentalBatchTableModel(this.weightUnit, (TableColumnModelExt)columnModel);
        table.setModel((TableModel)tableModel);
        table.setColumnModel((TableColumnModel)columnModel);
        this.initBatchTable(table, (TableColumnModelExt)columnModel, tableModel);
    }

    @Override
    protected JComponent getComponentToFocus() {
        return ((AccidentalBatchUI)this.getUI()).getTable();
    }

    @Override
    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
    }

    @Override
    public CaracteristicMapEditorUI getCaracteristicMapEditor() {
        EditCatchesUI parent = (EditCatchesUI)SwingUtil.getParentContainer((Object)this.ui, EditCatchesUI.class);
        return parent.getAccidentalCaracteristicMapEditor();
    }

    @Override
    public void showCaracteristicMapEditor(Species species) {
        EditCatchesUI parent = (EditCatchesUI)SwingUtil.getParentContainer((Object)this.ui, EditCatchesUI.class);
        parent.getHandler().setAccidentalSelectedCard("caracteristicsCard", species);
    }

    @Override
    public void hideCaracteristicMapEditor() {
        EditCatchesUI parent = (EditCatchesUI)SwingUtil.getParentContainer((Object)this.ui, EditCatchesUI.class);
        parent.getHandler().setAccidentalSelectedCard("main");
    }

    public void createBatch() {
        EditCatchesUI parent = (EditCatchesUI)SwingUtil.getParentContainer((Object)this.ui, EditCatchesUI.class);
        CreateAccidentalBatchUI createBatchEditor = parent.getAccidentalTabCreateBatch();
        createBatchEditor.getHandler().openUI();
        parent.getHandler().setAccidentalSelectedCard("createBatch");
    }

    public void addBatch(CreateAccidentalBatchUIModel model) {
        if (model.isValid()) {
            AccidentalBatchTableModel tableModel = this.getTableModel();
            AccidentalBatchRowModel newRow = tableModel.createNewRow();
            newRow.setSpecies(model.getSpecies());
            newRow.setGender(model.getGender());
            newRow.setWeight(model.getWeight());
            newRow.setSize(model.getSize());
            newRow.setLengthStepCaracteristic(model.getLengthStepCaracteristic());
            newRow.setDeadOrAlive(model.getDeadOrAlive());
            this.recomputeRowValidState(newRow);
            this.saveRow(newRow);
            tableModel.addNewRow(newRow);
            TuttiUIUtil.selectFirstCellOnLastRow(this.getTable());
        }
    }

    protected AccidentalBatchRowModel loadBatch(AccidentalBatch aBatch) {
        AccidentalBatchRowModel newRow = new AccidentalBatchRowModel(this.weightUnit, aBatch);
        List attachments = this.persistenceService.getAllAttachments(newRow.getObjectType(), newRow.getObjectId());
        newRow.addAllAttachment(attachments);
        return newRow;
    }

    protected void saveRow(AccidentalBatchRowModel row) {
        AccidentalBatch entityToSave = row.toEntity();
        FishingOperation fishingOperation = ((AccidentalBatchUIModel)this.getModel()).getFishingOperation();
        entityToSave.setFishingOperation(fishingOperation);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Selected fishingOperation: " + fishingOperation.getId()));
        }
        if (TuttiEntities.isNew(entityToSave)) {
            this.persistenceService.createAccidentalBatch(entityToSave);
            row.setId(entityToSave.getId());
        } else {
            this.persistenceService.saveAccidentalBatch(entityToSave);
        }
        ((AccidentalBatchUIModel)this.getModel()).fireBatchUpdated(row);
    }
}

