/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.spatial;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.TuttiTechnicalException;
import fr.ifremer.tutti.ui.swing.spatial.DmdCoordinate;
import fr.ifremer.tutti.ui.swing.spatial.DmdCoordinateEditor;
import fr.ifremer.tutti.ui.swing.spatial.DmdCoordinateEditorModel;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;
import jaxx.runtime.swing.editor.bean.BeanUIUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DmdCoordinateEditorHandler {
    private static final Log log = LogFactory.getLog(DmdCoordinateEditorHandler.class);
    protected static final Pattern VALUE_PATTERN = Pattern.compile("(.*)\u00b0(.*)'(.*)");
    private final DmdCoordinateEditor ui;
    protected Method signMutator;
    protected Method degreMutator;
    protected Method minuteMutator;
    protected Method decimalMutator;
    protected DefaultFormatterFactory unsignedFactory;
    protected DefaultFormatterFactory signedFactory;
    protected boolean valueIsAdjusting;
    protected boolean valueModelIsAdjusting;

    public DmdCoordinateEditorHandler(DmdCoordinateEditor ui) {
        this.ui = ui;
    }

    public void init() {
        MaskFormatter signedFormatter;
        MaskFormatter unsignedFormatter;
        final DmdCoordinateEditorModel model = this.ui.getModel();
        Preconditions.checkNotNull((Object)model.getBean(), (Object)("could not find bean in " + this.ui));
        Preconditions.checkNotNull((Object)model.getPropertySign(), (Object)("could not find propertySign in " + this.ui));
        Preconditions.checkNotNull((Object)model.getPropertyDegree(), (Object)("could not find propertyDegree in " + this.ui));
        Preconditions.checkNotNull((Object)model.getPropertyMinute(), (Object)("could not find propertyMinute in " + this.ui));
        Preconditions.checkNotNull((Object)model.getPropertyDecimal(), (Object)("could not find propertyDecimal in " + this.ui));
        Serializable bean = model.getBean();
        this.signMutator = BeanUIUtil.getMutator((Object)bean, (String)model.getPropertySign());
        Preconditions.checkNotNull((Object)this.signMutator, (Object)("could not find mutator for " + model.getPropertySign()));
        this.degreMutator = BeanUIUtil.getMutator((Object)bean, (String)model.getPropertyDegree());
        Preconditions.checkNotNull((Object)this.degreMutator, (Object)("could not find mutator for " + model.getPropertyDegree()));
        this.minuteMutator = BeanUIUtil.getMutator((Object)bean, (String)model.getPropertyMinute());
        Preconditions.checkNotNull((Object)this.minuteMutator, (Object)("could not find mutator for " + model.getPropertyMinute()));
        this.decimalMutator = BeanUIUtil.getMutator((Object)bean, (String)model.getPropertyDecimal());
        Preconditions.checkNotNull((Object)this.decimalMutator, (Object)("could not find mutator for " + model.getPropertyDecimal()));
        try {
            String pattern = model.getMaskFormatterPattern();
            unsignedFormatter = new MaskFormatter(pattern);
            unsignedFormatter.setValidCharacters(" 01234567890");
        }
        catch (ParseException e) {
            throw new TuttiTechnicalException((Throwable)e);
        }
        this.unsignedFactory = new DefaultFormatterFactory(unsignedFormatter);
        try {
            String pattern = model.getMaskFormatterPattern();
            signedFormatter = new MaskFormatter("-" + pattern);
            signedFormatter.setValidCharacters(" 01234567890");
        }
        catch (ParseException e) {
            throw new TuttiTechnicalException((Throwable)e);
        }
        this.signedFactory = new DefaultFormatterFactory(signedFormatter);
        JFormattedTextField editor = this.ui.getEditor();
        editor.setFormatterFactory(this.unsignedFactory);
        editor.setFocusLostBehavior(0);
        editor.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Matcher matcher;
                String newValue = (String)evt.getNewValue();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Value has changed: " + newValue));
                }
                DmdCoordinate value = null;
                if (newValue != null && (matcher = VALUE_PATTERN.matcher(newValue)).matches()) {
                    String degresStr = matcher.group(1).replaceAll("\\s", "");
                    String minutesStr = matcher.group(2).replaceAll("\\s", "");
                    String decimalesStr = matcher.group(3).replaceAll("\\s", "");
                    Integer degre = degresStr.isEmpty() || "-".equals(degresStr) ? 0 : Integer.valueOf(degresStr);
                    Integer minutes = minutesStr.isEmpty() ? 0 : Integer.valueOf(minutesStr);
                    Integer decimal = decimalesStr.isEmpty() ? 0 : Integer.valueOf(decimalesStr);
                    boolean signed = degre < 0;
                    value = DmdCoordinate.valueOf(signed, Math.abs(degre), minutes, decimal);
                }
                model.setValue(value);
            }
        });
        model.addPropertyChangeListener("sign", new ModelPropertyChangeListener(model, this.signMutator));
        model.addPropertyChangeListener("degree", new ModelPropertyChangeListener(model, this.degreMutator));
        model.addPropertyChangeListener("minute", new ModelPropertyChangeListener(model, this.minuteMutator));
        model.addPropertyChangeListener("decimal", new ModelPropertyChangeListener(model, this.decimalMutator));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(DmdCoordinate value, boolean pushToModel) {
        if (this.valueModelIsAdjusting) {
            return;
        }
        String signStr = "";
        String degreeStr = "";
        String minuteStr = "";
        String decimalStr = "";
        if (value != null) {
            boolean sign = value.isSign();
            signStr = sign ? "-" : "";
            Integer degree = value.getDegree();
            degreeStr = degree == null ? "" : degree.toString();
            Integer minute = value.getMinute();
            minuteStr = minute == null ? "" : minute.toString();
            Integer decimal = value.getDecimal();
            decimalStr = decimal == null ? "" : decimal.toString();
        }
        DmdCoordinateEditorModel model = this.ui.getModel();
        String stringPattern = model.getStringPattern();
        String valueStr = String.format(stringPattern, signStr, StringUtils.leftPad((String)degreeStr, (int)(model.isLongitudeEditor() ? 3 : 2), (char)' '), StringUtils.leftPad((String)minuteStr, (int)2, (char)' '), StringUtils.leftPad((String)decimalStr, (int)2, (char)' '));
        this.valueIsAdjusting = !pushToModel;
        try {
            this.ui.getEditor().setValue(valueStr);
        }
        finally {
            this.valueIsAdjusting = false;
        }
    }

    public void resetEditor() {
        this.setValue(null, true);
        this.ui.getEditor().setFormatterFactory(this.unsignedFactory);
    }

    public void onKeyReleased(KeyEvent e) {
        JFormattedTextField source = (JFormattedTextField)e.getSource();
        char keyChar = e.getKeyChar();
        int caretPosition = source.getCaretPosition();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Key pressed: " + keyChar + " (caret position: " + caretPosition + ")"));
        }
        String newValue = null;
        DefaultFormatterFactory newFactory = null;
        if (keyChar == '-') {
            if (this.unsignedFactory == source.getFormatterFactory()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Switch to signed");
                }
                newFactory = this.signedFactory;
                try {
                    source.commitEdit();
                }
                catch (ParseException e1) {
                    // empty catch block
                }
                newValue = "-" + source.getValue();
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Switch to unsigned");
                }
                newFactory = this.unsignedFactory;
                try {
                    source.commitEdit();
                }
                catch (ParseException e1) {
                    // empty catch block
                }
                newValue = ((String)source.getValue()).substring(1);
            }
        } else {
            try {
                source.commitEdit();
            }
            catch (ParseException e1) {
                // empty catch block
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Key pressed: newValue " + source.getValue()));
            }
        }
        if (newFactory != null) {
            e.consume();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Key pressed: newValue " + newValue));
            }
            source.setFormatterFactory(newFactory);
            source.setValue(newValue);
            caretPosition = this.unsignedFactory == newFactory ? --caretPosition : ++caretPosition;
            source.setCaretPosition(caretPosition);
        }
    }

    private class ModelPropertyChangeListener
    implements PropertyChangeListener {
        private final DmdCoordinateEditorModel model;
        private final Method mutator;

        private ModelPropertyChangeListener(DmdCoordinateEditorModel model, Method mutator) {
            this.model = model;
            this.mutator = mutator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!DmdCoordinateEditorHandler.this.valueIsAdjusting) {
                Object newValue = evt.getNewValue();
                try {
                    DmdCoordinateEditorHandler.this.valueModelIsAdjusting = true;
                    try {
                        this.mutator.invoke((Object)this.model.getBean(), newValue);
                    }
                    finally {
                        DmdCoordinateEditorHandler.this.valueModelIsAdjusting = false;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

