// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: Search.java.vsl in andromda-spring-cartridge.
//
package fr.ifremer.adagio.core.dao;

/**
 * Stores the information necessary to performa a property search.
 *
 * @see PropertySearch
 */
public class Search
    implements java.io.Serializable
{
    private static final long serialVersionUID = 8277265070757689152L;

    /**
     * Constructs the search object.
     *
     * @param parameters the parameters to use.
     * @param pageNumber the page number (if paging results).
     * @param pageSize the page size (if paging results).
     * @param eagerFetching whether or not the search will eagerly fetch the associations included in the search.
     */
    public Search(SearchParameter[] parameters, int pageNumber, int pageSize, boolean eagerFetching)
    {
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
        if (parameters != null)
        {
            this.parameters.addAll(java.util.Arrays.asList(parameters));
        }
        this.eagerFetching = eagerFetching;
    }

    /**
     * Constructs the search object.
     *
     * @param parameters the parameters to use.
     * @param pageNumber the page number (if paging results).
     * @param pageSize the page size (if paging results).
     */
    public Search(SearchParameter[] parameters, int pageNumber, int pageSize)
    {
        this(parameters, pageNumber, pageSize, false);
    }

    /**
     * Constructs the search object.
     *
     * @param parameters the parameters to use.
     */
    public Search(SearchParameter[] parameters)
    {
        this(parameters, -1, -1, false);
    }

    /**
     * Constructs the search object.
     *
     * @param parameters the parameters to use.
     */
    public Search(SearchParameter[] parameters, boolean eagerFetching)
    {
        this(parameters, -1, -1, eagerFetching);
    }

    private int pageNumber;

    /**
     * Gets the page number (if paging the results).
     *
     * @return the page number.
     */
    public int getPageNumber()
    {
        return this.pageNumber;
    }

    /**
     * Sets the page number (if paging the results).
     *
     * @return the current search instance.
     */
    public Search setPageNumber(int pageNumber)
    {
        this.pageNumber = pageNumber;
        return this;
    }

    private int pageSize;

    /**
     * Gets the size of the page (if paging the results).
     *
     * @return the page size.
     */
    public int getPageSize()
    {
        return this.pageSize;
    }

    /**
     * Sets the size of the page (if paging the results).
     *
     * @param pageSize the page size.
     *
     * @return the current search instance.
     */
    public Search setPageSize(int pageSize)
    {
        this.pageSize = pageSize;
        return this;
    }

    private java.util.Collection<SearchParameter> parameters = new java.util.ArrayList<SearchParameter>();

    /**
     * Gets the search parameters for this search object..
     */
    public SearchParameter[] getParameters()
    {
        return this.parameters.toArray(new SearchParameter[0]);
    }

    /**
     * Sets the search parameters for this search object.
     *
     * @param parameters
     *
     * @param returns the current search instance.
     */
    public Search setParameters(SearchParameter[] parameters)
    {
        this.parameters = new java.util.ArrayList<SearchParameter>(java.util.Arrays.asList(parameters));
        return this;
    }

    /**
     * Constructs the search object.
     *
     * @param parameters the parameters to use.
     */
    public Search()
    {
        this(null, -1, -1, false);
    }

    /**
     * Adds a search parameter to the search.
     *
     * @param searchParameter the search parameter to add.
     *
     * @return the current search instance.
     */
    public Search addSearchParameter(final SearchParameter searchParameter)
    {
        this.parameters.add(searchParameter);
        return this;
    }

    private boolean eagerFetching;

    /**
     * Whether or not eager fetching is enabled (if it is enabled, all associations
     * queried will be fetched eagerly).
     *
     * @return true/false
     */
    public boolean isEagerFetching()
    {
        return eagerFetching;
    }

    /**
     * Sets whether or not eager fetching is enabled (if it is enabled, all associations
     * queried will be fetched eagerly).
     *
     * @param eagerFetching whether or not to eager fetch the results.
     *
     * @return the current search instance.
     */
    public Search setEagerFetching(boolean eagerFetching)
    {
        this.eagerFetching = eagerFetching;
        return this;
    }

    /**
     * Adds an "order by" clause for the search with default ascending order.
     *
     * @param propertyName the property name to order by.
     *
     * @return the current search instance.
     */
    public Search addOrderBy(final String propertyName)
    {
        return this.addOrderBy(propertyName, SearchParameter.ORDER_ASC);
    }

    /**
     * Adds an "order by" clause for the search.
     *
     * @param propertyName the property name to order by.
     * @param order the order.  Use: {@link SearchParameter#ORDER_ASC},
     *        {@link SearchParameter#ORDER_DESC}, or {@link SearchParameter#ORDER_UNSET}.
     *
     * @return the current search instance.
     */
    public Search addOrderBy(final String propertyName, final int order)
    {
        this.parameters.add(new SearchParameter(propertyName, null, -1, -1, order));
        return this;
    }

    /**
     * Adds an "order by" clause for the search.
     *
     * @param propertyName the property name to order by.
     * @param descending true/false; true for descending ordering, false for ascending ordering.
     *
     * @return the current search instance.
     */
    public Search addOrderBy(String propertyName, final boolean descending)
    {
        this.addOrderBy(propertyName, descending ? SearchParameter.ORDER_DESC : SearchParameter.ORDER_ASC);
        return this;
    }

    private boolean useSqlLimiting = false;

    /**
     * Whether or not to use sql limiting (if paging is being used).  If this is set to false, then
     * paging will be based on the actual entities returned instead of using SQL to limit the results.
     *
     * @return true/false
     */
    public boolean isUseSqlLimiting()
    {
        return useSqlLimiting;
    }

    /**
     * Sets whether or not to use sql limiting (if paging is being used).  If this is set to false, then
     * paging will be based on the actual entities returned instead of using SQL to limit the results.
     *
     * @param useSqlPaging whether or not to use SQL paging (default is <code>false</code>).
     *
     * @return the current search instance.
     */
    public Search setUseSqlLimiting(boolean useSqlPaging)
    {
        this.useSqlLimiting = useSqlPaging;
        return this;
    }
}