package fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.create;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class CreateIndividualObservationBatchUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<CreateIndividualObservationBatchUIModel, CreateIndividualObservationBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_INDIVIDUAL_OBSERVATION_CREATE_FROM_BATCH_ENABLED = "individualObservationCreateFromBatch.enabled";
    public static final String BINDING_INDIVIDUAL_OBSERVATION_CREATE_FROM_BATCH_SELECTED = "individualObservationCreateFromBatch.selected";
    public static final String BINDING_INDIVIDUAL_OBSERVATION_LENGTH_STEP_CARACTERISTIC_COMBO_BOX_SELECTED_ITEM = "individualObservationLengthStepCaracteristicComboBox.selectedItem";
    public static final String BINDING_INDIVIDUAL_OBSERVATION_SIZE_FIELD_MODEL = "individualObservationSizeField.model";
    public static final String BINDING_INDIVIDUAL_OBSERVATION_SPECIES_COMBO_BOX_DATA = "individualObservationSpeciesComboBox.data";
    public static final String BINDING_INDIVIDUAL_OBSERVATION_SPECIES_COMBO_BOX_SELECTED_ITEM = "individualObservationSpeciesComboBox.selectedItem";
    public static final String BINDING_INDIVIDUAL_OBSERVATION_WEIGHT_FIELD_MODEL = "individualObservationWeightField.model";
    public static final String BINDING_SAVE_AND_CLOSE_BUTTON_ENABLED = "saveAndCloseButton.enabled";
    public static final String BINDING_SAVE_AND_CONTINUE_BUTTON_ENABLED = "saveAndContinueButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(CreateIndividualObservationBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addSpeciesButton;
    protected TuttiHelpBroker broker;
    protected JButton cancelButton;
    protected Table configurationPanel;
    protected CreateIndividualObservationBatchUI createIndividualObservationBatchTopPanel = this;
    protected CreateIndividualObservationBatchUIHandler handler;
    protected JCheckBox individualObservationCreateFromBatch;
    @ValidatorField( validatorId = "validator",  propertyName = "lengthStepCaracteristic",  editorName = "individualObservationLengthStepCaracteristicComboBox")
    protected BeanFilterableComboBox<Caracteristic> individualObservationLengthStepCaracteristicComboBox;
    protected JLabel individualObservationLengthStepCaracteristicLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "size",  editorName = "individualObservationSizeField")
    protected NumberEditor individualObservationSizeField;
    protected JLabel individualObservationSizeLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "species",  editorName = "individualObservationSpeciesComboBox")
    protected BeanFilterableComboBox<Species> individualObservationSpeciesComboBox;
    protected JLabel individualObservationSpeciesLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "weight",  editorName = "individualObservationWeightField")
    protected NumberEditor individualObservationWeightField;
    protected JLabel individualObservationWeightLabel;
    protected CreateIndividualObservationBatchUIModel model;
    protected JButton saveAndCloseButton;
    protected JButton saveAndContinueButton;
    @Validator( validatorId = "validator")
    protected SwingValidator<CreateIndividualObservationBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CreateIndividualObservationBatchUI(EditCatchesUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            CreateIndividualObservationBatchUIHandler handler = new CreateIndividualObservationBatchUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public CreateIndividualObservationBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CreateIndividualObservationBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateIndividualObservationBatchUI() {
        $initialize();
    }

    public CreateIndividualObservationBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateIndividualObservationBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public CreateIndividualObservationBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateIndividualObservationBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public CreateIndividualObservationBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__saveAndCloseButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.saveAndClose();
    }

    public void doActionPerformed__on__saveAndContinueButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.saveAndContinue();
    }

    public void doItemStateChanged__on__individualObservationCreateFromBatch(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setBoolean(event, "createFromBatch");
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddSpeciesButton() {
        return addSpeciesButton;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public Table getConfigurationPanel() {
        return configurationPanel;
    }

    public CreateIndividualObservationBatchUIHandler getHandler() {
        return handler;
    }

    public JCheckBox getIndividualObservationCreateFromBatch() {
        return individualObservationCreateFromBatch;
    }

    public BeanFilterableComboBox<Caracteristic> getIndividualObservationLengthStepCaracteristicComboBox() {
        return individualObservationLengthStepCaracteristicComboBox;
    }

    public JLabel getIndividualObservationLengthStepCaracteristicLabel() {
        return individualObservationLengthStepCaracteristicLabel;
    }

    public NumberEditor getIndividualObservationSizeField() {
        return individualObservationSizeField;
    }

    public JLabel getIndividualObservationSizeLabel() {
        return individualObservationSizeLabel;
    }

    public BeanFilterableComboBox<Species> getIndividualObservationSpeciesComboBox() {
        return individualObservationSpeciesComboBox;
    }

    public JLabel getIndividualObservationSpeciesLabel() {
        return individualObservationSpeciesLabel;
    }

    public NumberEditor getIndividualObservationWeightField() {
        return individualObservationWeightField;
    }

    public JLabel getIndividualObservationWeightLabel() {
        return individualObservationWeightLabel;
    }

    public CreateIndividualObservationBatchUIModel getModel() {
        return model;
    }

    public JButton getSaveAndCloseButton() {
        return saveAndCloseButton;
    }

    public JButton getSaveAndContinueButton() {
        return saveAndContinueButton;
    }

    public SwingValidator<CreateIndividualObservationBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configurationPanel.add(individualObservationSpeciesLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(individualObservationSpeciesComboBox), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(addSpeciesButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(individualObservationCreateFromBatch, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(individualObservationWeightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(individualObservationWeightField), new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(individualObservationSizeLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(individualObservationSizeField), new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(individualObservationLengthStepCaracteristicLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(individualObservationLengthStepCaracteristicComboBox), new GridBagConstraints(1, 4, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToCreateIndividualObservationBatchTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(configurationPanel, BorderLayout.CENTER);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAddSpeciesButton() {
        $objectMap.put("addSpeciesButton", addSpeciesButton = new JButton());
        
        addSpeciesButton.setName("addSpeciesButton");
        addSpeciesButton.setText(_("tutti.createIndividualObservationBatch.action.addSpecies"));
        addSpeciesButton.setToolTipText(_("tutti.createIndividualObservationBatch.action.addSpecies.tip"));
        addSpeciesButton.putClientProperty("help", "tutti.createIndividualObservationBatch.action.addSpecies.help");
        addSpeciesButton.putClientProperty("tuttiAction", SelectSpeciesForIndividualObservationBatchAction.class);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.createIndividualObservationBatch.help"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("tutti.createIndividualObservationBatch.action.cancel"));
        cancelButton.setToolTipText(_("tutti.createIndividualObservationBatch.action.cancel.tip"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
        cancelButton.putClientProperty("help", "tutti.createIndividualObservationBatch.action.cancel.help");
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new Table());
        
        configurationPanel.setName("configurationPanel");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(CreateIndividualObservationBatchUIHandler.class));
    }

    protected void createIndividualObservationCreateFromBatch() {
        $objectMap.put("individualObservationCreateFromBatch", individualObservationCreateFromBatch = new JCheckBox());
        
        individualObservationCreateFromBatch.setName("individualObservationCreateFromBatch");
        individualObservationCreateFromBatch.setText(_("tutti.createIndividualObservationBatch.field.createFromBatch"));
        individualObservationCreateFromBatch.setToolTipText(_("tutti.createIndividualObservationBatch.field.createFromBatch.tip"));
        individualObservationCreateFromBatch.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__individualObservationCreateFromBatch"));
        individualObservationCreateFromBatch.putClientProperty("help", "tutti.createIndividualObservationBatch.field.createFromBatch.help");
    }

    protected void createIndividualObservationLengthStepCaracteristicComboBox() {
        $objectMap.put("individualObservationLengthStepCaracteristicComboBox", individualObservationLengthStepCaracteristicComboBox = new BeanFilterableComboBox<Caracteristic>(this));
        
        individualObservationLengthStepCaracteristicComboBox.setName("individualObservationLengthStepCaracteristicComboBox");
        individualObservationLengthStepCaracteristicComboBox.setProperty("lengthStepCaracteristic");
        individualObservationLengthStepCaracteristicComboBox.setShowReset(true);
    }

    protected void createIndividualObservationLengthStepCaracteristicLabel() {
        $objectMap.put("individualObservationLengthStepCaracteristicLabel", individualObservationLengthStepCaracteristicLabel = new JLabel());
        
        individualObservationLengthStepCaracteristicLabel.setName("individualObservationLengthStepCaracteristicLabel");
        individualObservationLengthStepCaracteristicLabel.setText(_("tutti.createIndividualObservationBatch.field.individualObservationLengthStepCaracteristic"));
        individualObservationLengthStepCaracteristicLabel.setToolTipText(_("tutti.createIndividualObservationBatch.field.individualObservationLengthStepCaracteristic.tip"));
        individualObservationLengthStepCaracteristicLabel.putClientProperty("help", "tutti.createIndividualObservationBatch.field.individualObservationLengthStepCaracteristic.help");
    }

    protected void createIndividualObservationSizeField() {
        $objectMap.put("individualObservationSizeField", individualObservationSizeField = new NumberEditor(this));
        
        individualObservationSizeField.setName("individualObservationSizeField");
        individualObservationSizeField.setProperty("size");
        individualObservationSizeField.setUseFloat(true);
        individualObservationSizeField.setShowReset(true);
    }

    protected void createIndividualObservationSizeLabel() {
        $objectMap.put("individualObservationSizeLabel", individualObservationSizeLabel = new JLabel());
        
        individualObservationSizeLabel.setName("individualObservationSizeLabel");
        individualObservationSizeLabel.setText(_("tutti.createIndividualObservationBatch.field.individualObservationSize"));
        individualObservationSizeLabel.setToolTipText(_("tutti.createIndividualObservationBatch.field.individualObservationSize.tip"));
        individualObservationSizeLabel.putClientProperty("help", "tutti.createIndividualObservationBatch.field.individualObservationSize.help");
    }

    protected void createIndividualObservationSpeciesComboBox() {
        $objectMap.put("individualObservationSpeciesComboBox", individualObservationSpeciesComboBox = new BeanFilterableComboBox<Species>(this));
        
        individualObservationSpeciesComboBox.setName("individualObservationSpeciesComboBox");
        individualObservationSpeciesComboBox.setProperty("species");
        individualObservationSpeciesComboBox.setShowReset(true);
    }

    protected void createIndividualObservationSpeciesLabel() {
        $objectMap.put("individualObservationSpeciesLabel", individualObservationSpeciesLabel = new JLabel());
        
        individualObservationSpeciesLabel.setName("individualObservationSpeciesLabel");
        individualObservationSpeciesLabel.setText(_("tutti.createIndividualObservationBatch.field.individualObservationSpecies"));
        individualObservationSpeciesLabel.setToolTipText(_("tutti.createIndividualObservationBatch.field.individualObservationSpecies.tip"));
        individualObservationSpeciesLabel.putClientProperty("help", "tutti.createIndividualObservationBatch.field.individualObservationSpecies.help");
    }

    protected void createIndividualObservationWeightField() {
        $objectMap.put("individualObservationWeightField", individualObservationWeightField = new NumberEditor(this));
        
        individualObservationWeightField.setName("individualObservationWeightField");
        individualObservationWeightField.setProperty("weight");
        individualObservationWeightField.setUseFloat(true);
        individualObservationWeightField.setShowReset(true);
    }

    protected void createIndividualObservationWeightLabel() {
        $objectMap.put("individualObservationWeightLabel", individualObservationWeightLabel = new JLabel());
        
        individualObservationWeightLabel.setName("individualObservationWeightLabel");
        individualObservationWeightLabel.setText(_("tutti.createIndividualObservationBatch.field.individualObservationWeight"));
        individualObservationWeightLabel.setToolTipText(_("tutti.createIndividualObservationBatch.field.individualObservationWeight.tip"));
        individualObservationWeightLabel.putClientProperty("help", "tutti.createIndividualObservationBatch.field.individualObservationWeight.help");
        individualObservationWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getIndividualObservationWeightUnit());
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(CreateIndividualObservationBatchUIModel.class));
    }

    protected void createSaveAndCloseButton() {
        $objectMap.put("saveAndCloseButton", saveAndCloseButton = new JButton());
        
        saveAndCloseButton.setName("saveAndCloseButton");
        saveAndCloseButton.setText(_("tutti.createIndividualObservationBatch.action.saveAndClose"));
        saveAndCloseButton.setToolTipText(_("tutti.createIndividualObservationBatch.action.saveAndClose.tip"));
        saveAndCloseButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveAndCloseButton"));
        saveAndCloseButton.putClientProperty("help", "tutti.createIndividualObservationBatch.action.saveAndClose.help");
    }

    protected void createSaveAndContinueButton() {
        $objectMap.put("saveAndContinueButton", saveAndContinueButton = new JButton());
        
        saveAndContinueButton.setName("saveAndContinueButton");
        saveAndContinueButton.setText(_("tutti.createIndividualObservationBatch.action.saveAndContinue"));
        saveAndContinueButton.setToolTipText(_("tutti.createIndividualObservationBatch.action.saveAndContinue.tip"));
        saveAndContinueButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveAndContinueButton"));
        saveAndContinueButton.putClientProperty("help", "tutti.createIndividualObservationBatch.action.saveAndContinue.help");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(CreateIndividualObservationBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToCreateIndividualObservationBatchTopPanel();
        addChildrenToValidator();
        addChildrenToConfigurationPanel();
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(saveAndContinueButton);
        $JPanel0.add(saveAndCloseButton);
        
        // apply 9 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 23 property setters
        individualObservationSpeciesComboBox.setBeanType(Species.class);
        individualObservationLengthStepCaracteristicComboBox.setBeanType(Caracteristic.class);
        individualObservationSpeciesLabel.setLabelFor(individualObservationSpeciesComboBox);
        individualObservationSpeciesComboBox.setBean(model);
        addSpeciesButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.createIndividualObservationBatch.action.addSpecies.mnemonic"),'Z'));
        individualObservationWeightLabel.setLabelFor(individualObservationWeightField);
        individualObservationWeightField.setBean(model);
        individualObservationWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        individualObservationWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        individualObservationSizeLabel.setLabelFor(individualObservationSizeField);
        individualObservationSizeField.setBean(model);
        individualObservationSizeField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        individualObservationSizeField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        individualObservationLengthStepCaracteristicLabel.setLabelFor(individualObservationLengthStepCaracteristicComboBox);
        individualObservationLengthStepCaracteristicComboBox.setBean(model);
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.createIndividualObservationBatch.action.cancel.mnemonic"),'Z'));
        saveAndContinueButton.setIcon(SwingUtil.createActionIcon("save"));
        saveAndContinueButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.createIndividualObservationBatch.action.saveAndContinue.mnemonic"),'Z'));
        saveAndCloseButton.setIcon(SwingUtil.createActionIcon("save"));
        saveAndCloseButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.createIndividualObservationBatch.action.saveAndClose.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, createIndividualObservationBatchTopPanel, "tutti.createIndividualObservationBatch.help");
        registerHelpId(_broker, individualObservationSpeciesLabel, "tutti.createIndividualObservationBatch.field.individualObservationSpecies.help");
        registerHelpId(_broker, addSpeciesButton, "tutti.createIndividualObservationBatch.action.addSpecies.help");
        registerHelpId(_broker, individualObservationCreateFromBatch, "tutti.createIndividualObservationBatch.field.createFromBatch.help");
        registerHelpId(_broker, individualObservationWeightLabel, "tutti.createIndividualObservationBatch.field.individualObservationWeight.help");
        registerHelpId(_broker, individualObservationSizeLabel, "tutti.createIndividualObservationBatch.field.individualObservationSize.help");
        registerHelpId(_broker, individualObservationLengthStepCaracteristicLabel, "tutti.createIndividualObservationBatch.field.individualObservationLengthStepCaracteristic.help");
        registerHelpId(_broker, cancelButton, "tutti.createIndividualObservationBatch.action.cancel.help");
        registerHelpId(_broker, saveAndContinueButton, "tutti.createIndividualObservationBatch.action.saveAndContinue.help");
        registerHelpId(_broker, saveAndCloseButton, "tutti.createIndividualObservationBatch.action.saveAndClose.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("createIndividualObservationBatchTopPanel", createIndividualObservationBatchTopPanel);
        createHandler();
        createModel();
        createValidator();
        createBroker();
        createConfigurationPanel();
        createIndividualObservationSpeciesLabel();
        createIndividualObservationSpeciesComboBox();
        createAddSpeciesButton();
        createIndividualObservationCreateFromBatch();
        createIndividualObservationWeightLabel();
        createIndividualObservationWeightField();
        createIndividualObservationSizeLabel();
        createIndividualObservationSizeField();
        createIndividualObservationLengthStepCaracteristicLabel();
        createIndividualObservationLengthStepCaracteristicComboBox();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createCancelButton();
        createSaveAndContinueButton();
        createSaveAndCloseButton();
        // inline creation of createIndividualObservationBatchTopPanel
        setName("createIndividualObservationBatchTopPanel");
        setLayout(new BorderLayout());
        createIndividualObservationBatchTopPanel.putClientProperty("help", "tutti.createIndividualObservationBatch.help");
        
        // registers 9 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 9 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INDIVIDUAL_OBSERVATION_SPECIES_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("species", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    individualObservationSpeciesComboBox.setSelectedItem(model.getSpecies());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("species", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INDIVIDUAL_OBSERVATION_SPECIES_COMBO_BOX_DATA, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("availableSpecies", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    individualObservationSpeciesComboBox.setData(model.getAvailableSpecies());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("availableSpecies", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INDIVIDUAL_OBSERVATION_CREATE_FROM_BATCH_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesFromBatch", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    individualObservationCreateFromBatch.setEnabled(model.isSpeciesFromBatch());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesFromBatch", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INDIVIDUAL_OBSERVATION_CREATE_FROM_BATCH_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("createFromBatch", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    individualObservationCreateFromBatch.setSelected(model.isCreateFromBatch());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("createFromBatch", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INDIVIDUAL_OBSERVATION_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("weight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    individualObservationWeightField.setModel(model.getWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("weight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INDIVIDUAL_OBSERVATION_SIZE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("size", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    individualObservationSizeField.setModel(model.getSize());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("size", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INDIVIDUAL_OBSERVATION_LENGTH_STEP_CARACTERISTIC_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    individualObservationLengthStepCaracteristicComboBox.setSelectedItem(model.getLengthStepCaracteristic());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_AND_CONTINUE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveAndContinueButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_AND_CLOSE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveAndCloseButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}