package fr.ifremer.tutti.ui.swing.content.db;

/*
 * #%L
 * Tutti :: UI
 * $Id: ReinstallDbAction.java 1171 2013-09-17 09:25:46Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.8/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/db/ReinstallDbAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.TuttiIOUtil;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.config.TuttiPersistenceConfig;
import fr.ifremer.tutti.ui.swing.RunTutti;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.AbstractMainUITuttiAction;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.File;
import java.util.Date;

import static org.nuiton.i18n.I18n._;

/**
 * To install (or reinstall) a db from last network one.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.4
 */
public class ReinstallDbAction extends AbstractMainUITuttiAction {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(ReinstallDbAction.class);

    protected File backupFile;

    protected String jdbcUrl;

    public ReinstallDbAction(MainUIHandler handler) {
        super(handler, true);
        setActionDescription(_("tutti.dbManager.action.installDb.tip"));
    }

    @Override
    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();

        if (doAction) {

            // check we can connect to remote install server

            // check db url is reachable
            TuttiUIContext context = getContext();
            doAction = context.checkUpdateDbReachable();
//            TuttiApplicationConfig config = context.getConfig();
//            String url = config.getUpdateApplicationUrl();
//
//            try {
//                TuttiUIUtil.tryToConnectToUpdateUrl(
//                        url,
//                        n_("tutti.error.update.could.not.reach.url")
//                );
//            } catch (TuttiBusinessException e) {
//                TuttiUIContext.getErrorHelper().showWarningDialog(e.getMessage());
//                doAction = false;
//            }
        }

        if (doAction) {

            jdbcUrl = null;
            backupFile = null;

            jdbcUrl = TuttiPersistenceConfig.getInstance().getJdbcUrl();

            if (getModel().isDbExist()) {

                displayInfoMessage(
                        _("tutti.dbManager.title.backup.db"),
                        _("tutti.dbManager.action.installDb.backup.db")
                );

                // choose backup file
                backupFile = saveFile(
                        getConfig().getServiceConfig().getPersistenceConfig().getDbBackupDirectory(),
                        "tutti-db-" + ExportDbAction.df.format(new Date()),
                        "zip",
                        _("tutti.dbManager.title.choose.dbExportFile"),
                        _("tutti.dbManager.action.chooseDbExportFile"),
                        "^.*\\.zip", _("tutti.common.file.zip")
                );

                if (backupFile == null) {

                    displayWarningMessage(
                            _("tutti.dbManager.title.backup.db"),
                            _("tutti.dbManager.action.installDb.no.backup.db.choosen")
                    );

                    doAction = false;
                }
            }
        }

        if (doAction) {

            ProgressionModel progressionModel = new ProgressionModel();
            progressionModel.setTotal(3);
            setProgressionModel(progressionModel);
        }
        return doAction;
    }

    @Override
    public void doAction() {

        Preconditions.checkNotNull(backupFile);

        ProgressionModel progressionModel = getProgressionModel();

        // close db
        progressionModel.increments(_("tutti.reinstallDb.step.closeDb", jdbcUrl));

        getContext().setDbLoaded(false);
        getHandler().reloadPersistenceService();

        // backup db
        progressionModel.increments(_("tutti.reinstallDb.step.backupDb", backupFile));
        getContext().getPersistenceService().exportDb(backupFile);

        // clean db context
        getContext().clearDbContext();

        // write restart action file (will be loaded at restart)
        String actionContent = InstallDbAction.class.getName();

        File startActionFile = getConfig().getStartActionFile();
        TuttiIOUtil.writeContent(startActionFile, actionContent, _("tutti.error.write.startActionFile", startActionFile));

        // restart application
        progressionModel.increments(_("tutti.reinstallDb.step.reloadApplication"));

        RunTutti.closeTutti(getHandler(), RunTutti.DELETE_DB_EXIT_CODE);
    }
}