/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.spatial;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.TuttiTechnicalException;
import fr.ifremer.tutti.ui.swing.spatial.DmsCoordinate;
import fr.ifremer.tutti.ui.swing.spatial.DmsCoordinateEditor;
import fr.ifremer.tutti.ui.swing.spatial.DmsCoordinateEditorModel;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;
import jaxx.runtime.swing.editor.bean.BeanUIUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DmsCoordinateEditorHandler {
    private static final Log log = LogFactory.getLog(DmsCoordinateEditorHandler.class);
    protected static final Pattern VALUE_PATTERN = Pattern.compile("(.*)\u00b0(.*)'(.*)''");
    private final DmsCoordinateEditor ui;
    protected Method signMutator;
    protected Method degreMutator;
    protected Method minuteMutator;
    protected Method secondMutator;
    protected DefaultFormatterFactory unsignedFactory;
    protected DefaultFormatterFactory signedFactory;
    protected boolean valueIsAdjusting;
    protected boolean valueModelIsAdjusting;

    public DmsCoordinateEditorHandler(DmsCoordinateEditor ui) {
        this.ui = ui;
    }

    public void init() {
        MaskFormatter signedFormatter;
        MaskFormatter unsignedFormatter;
        final DmsCoordinateEditorModel model = this.ui.getModel();
        Preconditions.checkNotNull((Object)model.getBean(), (Object)("could not find bean in " + this.ui));
        Preconditions.checkNotNull((Object)model.getPropertySign(), (Object)("could not find propertySign in " + this.ui));
        Preconditions.checkNotNull((Object)model.getPropertyDegree(), (Object)("could not find propertyDegree in " + this.ui));
        Preconditions.checkNotNull((Object)model.getPropertyMinute(), (Object)("could not find propertyMinute in " + this.ui));
        Preconditions.checkNotNull((Object)model.getPropertySecond(), (Object)("could not find propertySecond in " + this.ui));
        Serializable bean = model.getBean();
        this.signMutator = BeanUIUtil.getMutator((Object)bean, (String)model.getPropertySign());
        Preconditions.checkNotNull((Object)this.signMutator, (Object)("could not find mutator for " + model.getPropertySign()));
        this.degreMutator = BeanUIUtil.getMutator((Object)bean, (String)model.getPropertyDegree());
        Preconditions.checkNotNull((Object)this.degreMutator, (Object)("could not find mutator for " + model.getPropertyDegree()));
        this.minuteMutator = BeanUIUtil.getMutator((Object)bean, (String)model.getPropertyMinute());
        Preconditions.checkNotNull((Object)this.minuteMutator, (Object)("could not find mutator for " + model.getPropertyMinute()));
        this.secondMutator = BeanUIUtil.getMutator((Object)bean, (String)model.getPropertySecond());
        Preconditions.checkNotNull((Object)this.secondMutator, (Object)("could not find mutator for " + model.getPropertySecond()));
        try {
            String pattern = model.getMaskFormatterPattern();
            unsignedFormatter = new MaskFormatter(pattern);
            unsignedFormatter.setValidCharacters(" 01234567890");
        }
        catch (ParseException e) {
            throw new TuttiTechnicalException((Throwable)e);
        }
        this.unsignedFactory = new DefaultFormatterFactory(unsignedFormatter);
        try {
            String pattern = model.getMaskFormatterPattern();
            signedFormatter = new MaskFormatter("-" + pattern);
            signedFormatter.setValidCharacters(" 01234567890");
        }
        catch (ParseException e) {
            throw new TuttiTechnicalException((Throwable)e);
        }
        this.signedFactory = new DefaultFormatterFactory(signedFormatter);
        JFormattedTextField editor = this.ui.getEditor();
        editor.setFormatterFactory(this.unsignedFactory);
        editor.setFocusLostBehavior(0);
        editor.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Matcher matcher;
                String newValue = (String)evt.getNewValue();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Value has changed: " + newValue));
                }
                DmsCoordinate value = null;
                if (newValue != null && (matcher = VALUE_PATTERN.matcher(newValue)).matches()) {
                    String degresStr = matcher.group(1).replaceAll("\\s", "");
                    String minutesStr = matcher.group(2).replaceAll("\\s", "");
                    String secondsStr = matcher.group(3).replaceAll("\\s", "");
                    Integer degre = degresStr.isEmpty() || "-".equals(degresStr) ? 0 : Integer.valueOf(degresStr);
                    Integer minutes = minutesStr.isEmpty() ? 0 : Integer.valueOf(minutesStr);
                    Integer seconds = secondsStr.isEmpty() ? 0 : Integer.valueOf(secondsStr);
                    boolean signed = degre < 0;
                    value = DmsCoordinate.valueOf(signed, Math.abs(degre), minutes, seconds);
                }
                model.setValue(value);
            }
        });
        model.addPropertyChangeListener("sign", new ModelPropertyChangeListener(model, this.signMutator));
        model.addPropertyChangeListener("degree", new ModelPropertyChangeListener(model, this.degreMutator));
        model.addPropertyChangeListener("minute", new ModelPropertyChangeListener(model, this.minuteMutator));
        model.addPropertyChangeListener("second", new ModelPropertyChangeListener(model, this.secondMutator));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(DmsCoordinate value, boolean pushToModel) {
        if (this.valueModelIsAdjusting) {
            return;
        }
        String signStr = "";
        String degreeStr = "";
        String minuteStr = "";
        String secondStr = "";
        if (value != null) {
            boolean sign = value.isSign();
            signStr = sign ? "-" : "";
            Integer degree = value.getDegree();
            degreeStr = degree == null ? "" : degree.toString();
            Integer minute = value.getMinute();
            minuteStr = minute == null ? "" : minute.toString();
            Integer second = value.getSecond();
            secondStr = second == null ? "" : second.toString();
        }
        DmsCoordinateEditorModel model = this.ui.getModel();
        String stringPattern = model.getStringPattern();
        String valueStr = String.format(stringPattern, signStr, StringUtils.leftPad((String)degreeStr, (int)(model.isLongitudeEditor() ? 3 : 2), (char)' '), StringUtils.leftPad((String)minuteStr, (int)2, (char)' '), StringUtils.leftPad((String)secondStr, (int)2, (char)' '));
        this.valueIsAdjusting = !pushToModel;
        try {
            this.ui.getEditor().setValue(valueStr);
        }
        finally {
            this.valueIsAdjusting = false;
        }
    }

    public void resetEditor() {
        this.setValue(null, true);
        this.ui.getEditor().setFormatterFactory(this.unsignedFactory);
    }

    public void onKeyReleased(KeyEvent e) {
        JFormattedTextField source = (JFormattedTextField)e.getSource();
        char keyChar = e.getKeyChar();
        int caretPosition = source.getCaretPosition();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Key pressed: " + keyChar + " (caret position: " + caretPosition + ")"));
        }
        String newValue = null;
        DefaultFormatterFactory newFactory = null;
        if (keyChar == '-') {
            if (this.unsignedFactory == source.getFormatterFactory()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Switch to signed");
                }
                newFactory = this.signedFactory;
                try {
                    source.commitEdit();
                }
                catch (ParseException e1) {
                    // empty catch block
                }
                newValue = "-" + source.getValue();
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Switch to unsigned");
                }
                newFactory = this.unsignedFactory;
                try {
                    source.commitEdit();
                }
                catch (ParseException e1) {
                    // empty catch block
                }
                newValue = ((String)source.getValue()).substring(1);
            }
        } else {
            try {
                source.commitEdit();
            }
            catch (ParseException e1) {
                // empty catch block
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Key pressed: newValue " + source.getValue()));
            }
        }
        if (newFactory != null) {
            e.consume();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Key pressed: newValue " + newValue));
            }
            source.setFormatterFactory(newFactory);
            source.setValue(newValue);
            caretPosition = this.unsignedFactory == newFactory ? --caretPosition : ++caretPosition;
            source.setCaretPosition(caretPosition);
        }
    }

    private class ModelPropertyChangeListener
    implements PropertyChangeListener {
        private final DmsCoordinateEditorModel model;
        private final Method mutator;

        private ModelPropertyChangeListener(DmsCoordinateEditorModel model, Method mutator) {
            this.model = model;
            this.mutator = mutator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!DmsCoordinateEditorHandler.this.valueIsAdjusting) {
                Object newValue = evt.getNewValue();
                try {
                    DmsCoordinateEditorHandler.this.valueModelIsAdjusting = true;
                    try {
                        this.mutator.invoke((Object)this.model.getBean(), newValue);
                    }
                    finally {
                        DmsCoordinateEditorHandler.this.valueModelIsAdjusting = false;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

