/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service.synchro;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.synchro.ReferentialSynchronizeHelper;
import fr.ifremer.tutti.persistence.service.synchro.ReferentialSynchronizeResult;
import fr.ifremer.tutti.persistence.service.synchro.ReferentialSynchronizeService;
import java.util.Properties;
import javax.annotation.Resource;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionFactoryImplementor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.stereotype.Service;

@Service(value="referentialSynchronizeService")
public class ReferentialSynchronizeServiceImpl
extends AbstractPersistenceService
implements ReferentialSynchronizeService {
    @Autowired
    protected DriverManagerDataSource dataSource;
    protected Dialect localDialect;
    protected Properties dbconnexionProperties;
    @Resource(name="referentialSynchronizeHelper")
    protected ReferentialSynchronizeHelper helper;

    @Override
    public Properties getLocalConnectionProperties() {
        if (this.dbconnexionProperties == null) {
            this.dbconnexionProperties = new Properties();
            TuttiEntities.fillConnectionProperties(this.dbconnexionProperties, this.dataSource.getUrl(), this.dataSource.getUsername(), this.dataSource.getPassword());
        }
        return this.dbconnexionProperties;
    }

    @Override
    public Dialect getLocalDialect() {
        if (this.localDialect == null) {
            this.localDialect = ((SessionFactoryImplementor)this.sessionFactory).getSettings().getDialect();
        }
        return this.localDialect;
    }

    @Override
    public void prepare(Properties remoteConnectionProperties, ReferentialSynchronizeResult result) {
        Preconditions.checkNotNull((Object)result);
        Preconditions.checkNotNull((Object)remoteConnectionProperties);
        this.helper.prepare(this.getLocalConnectionProperties(), remoteConnectionProperties, this.getLocalDialect(), result);
    }

    @Override
    public void synchronize(Properties remoteConnectionProperties, ReferentialSynchronizeResult result) {
        Preconditions.checkNotNull((Object)result);
        Preconditions.checkNotNull((Object)remoteConnectionProperties);
        Preconditions.checkState((boolean)result.isSuccess());
        this.helper.synchronize(this.getLocalConnectionProperties(), remoteConnectionProperties, this.getLocalDialect(), result);
    }
}

