/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import fr.ifremer.adagio.core.dao.data.measure.Measurement;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValue;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValueImpl;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import java.io.Serializable;
import org.springframework.stereotype.Component;

@Component(value="measurementPersistenceHelper")
public class MeasurementPersistenceHelper
extends AbstractPersistenceService {
    public void setMeasurement(Measurement measurement, Caracteristic caracteristic, Serializable value) {
        if (value == null) {
            return;
        }
        switch (caracteristic.getCaracteristicType()) {
            case NUMBER: {
                measurement.setNumericalValue((Float)value);
                break;
            }
            case QUALITATIVE: {
                Integer qvId = null;
                if (value instanceof CaracteristicQualitativeValue) {
                    qvId = Integer.valueOf(((CaracteristicQualitativeValue)value).getId());
                } else if (value instanceof Integer) {
                    qvId = (Integer)value;
                }
                QualitativeValue qv = (QualitativeValue)this.load(QualitativeValueImpl.class, qvId);
                measurement.setQualitativeValue(qv);
                break;
            }
            case TEXT: {
                measurement.setAlphanumericalValue((String)((Object)value));
            }
        }
    }
}

