/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.config;

import fr.ifremer.tutti.TuttiIOUtil;
import fr.ifremer.tutti.persistence.config.TuttiPersistenceConfig;
import fr.ifremer.tutti.service.WeightUnit;
import fr.ifremer.tutti.service.config.TuttiServiceConfigOption;
import java.io.File;
import java.net.URL;
import java.util.List;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.i18n.I18n;
import org.nuiton.util.Version;

public class TuttiServiceConfig {
    protected final ApplicationConfig applicationConfig;
    protected final TuttiPersistenceConfig persistenceConfig;

    public TuttiServiceConfig(ApplicationConfig applicationConfig) {
        this(new TuttiPersistenceConfig(applicationConfig));
    }

    public TuttiServiceConfig(TuttiPersistenceConfig persistenceConfig) {
        this.applicationConfig = persistenceConfig.getConfig();
        this.persistenceConfig = persistenceConfig;
    }

    public ApplicationConfig getApplicationConfig() {
        return this.applicationConfig;
    }

    public TuttiPersistenceConfig getPersistenceConfig() {
        return this.persistenceConfig;
    }

    public Version getVersion() {
        return this.applicationConfig.getOptionAsVersion(TuttiServiceConfigOption.VERSION.getKey());
    }

    public URL getSiteUrl() {
        return this.applicationConfig.getOptionAsURL(TuttiServiceConfigOption.SITE_URL.getKey());
    }

    public String getOrganizationName() {
        return this.applicationConfig.getOption(TuttiServiceConfigOption.ORGANIZATION_NAME.getKey());
    }

    public int getInceptionYear() {
        return this.applicationConfig.getOptionAsInt(TuttiServiceConfigOption.INCEPTION_YEAR.getKey());
    }

    public File getBasedir() {
        File result = this.applicationConfig.getOptionAsFile(TuttiServiceConfigOption.BASEDIR.getKey());
        return result;
    }

    public File getDataDirectory() {
        File result = this.applicationConfig.getOptionAsFile(TuttiServiceConfigOption.DATA_DIRECTORY.getKey());
        return result;
    }

    public File getReportDirectory() {
        File result = this.applicationConfig.getOptionAsFile(TuttiServiceConfigOption.REPORT_DIRECTORY.getKey());
        return result;
    }

    public File getTmpDirectory() {
        File result = this.applicationConfig.getOptionAsFile(TuttiServiceConfigOption.TMP_DIRECTORY.getKey());
        return result;
    }

    public File newTempFile(String basename) {
        return new File(this.getTmpDirectory(), basename + "_" + System.nanoTime());
    }

    public char getCsvSeparator() {
        return this.applicationConfig.getOption(TuttiServiceConfigOption.CSV_SEPARATOR.getKey()).charAt(0);
    }

    public String getExportCountryId() {
        return this.applicationConfig.getOption(TuttiServiceConfigOption.EXPORT_COUNTRY_ID.getKey());
    }

    public List<Integer> getSamplingOrderIds() {
        ApplicationConfig.OptionList result = this.applicationConfig.getOptionAsList(TuttiServiceConfigOption.SAMPLING_CATEGORY_ORDER_IDS.getKey());
        return result.getOptionAsInt();
    }

    public WeightUnit getSpeciesWeightUnit() {
        return (WeightUnit)((Object)this.applicationConfig.getOption(WeightUnit.class, TuttiServiceConfigOption.WEIGHT_UNIT_SPECIES.getKey()));
    }

    public WeightUnit getBenthosWeightUnit() {
        return (WeightUnit)((Object)this.applicationConfig.getOption(WeightUnit.class, TuttiServiceConfigOption.WEIGHT_UNIT_BENTHOS.getKey()));
    }

    public WeightUnit getMarineLitterWeightUnit() {
        return (WeightUnit)((Object)this.applicationConfig.getOption(WeightUnit.class, TuttiServiceConfigOption.WEIGHT_UNIT_MARINE_LITTER.getKey()));
    }

    public WeightUnit getIndividualObservationWeightUnit() {
        return (WeightUnit)((Object)this.applicationConfig.getOption(WeightUnit.class, TuttiServiceConfigOption.WEIGHT_UNIT_INDIVIDUAL_OBSERVATION.getKey()));
    }

    public WeightUnit getAccidentalCatchWeightUnit() {
        return (WeightUnit)((Object)this.applicationConfig.getOption(WeightUnit.class, TuttiServiceConfigOption.WEIGHT_UNIT_ACCIDENTAL_CATCH.getKey()));
    }

    public void prepareDirectories() {
        File dataDirectory = this.getDataDirectory();
        TuttiIOUtil.forceMkdir((File)dataDirectory, (String)I18n._((String)"tutti.service.mkDir.error", (Object[])new Object[]{dataDirectory}));
        File tmpDirectory = this.getTmpDirectory();
        if (tmpDirectory.exists()) {
            TuttiIOUtil.deleteDirectory((File)tmpDirectory, (String)I18n._((String)"tutti.service.config.deleteTempDirectory.error", (Object[])new Object[]{tmpDirectory}));
        }
        TuttiIOUtil.forceMkdir((File)tmpDirectory, (String)I18n._((String)"tutti.service.mkDir.error", (Object[])new Object[]{tmpDirectory}));
    }

    public void setCsvSeparator(char c) {
        this.applicationConfig.setOption(TuttiServiceConfigOption.CSV_SEPARATOR.getKey(), c + "");
    }

    public void setExportCountry(String exportCountryId) {
        this.applicationConfig.setOption(TuttiServiceConfigOption.EXPORT_COUNTRY_ID.getKey(), exportCountryId);
    }
}

