/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.catches.multipost;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.service.TuttiCsvUtil;
import fr.ifremer.tutti.service.catches.multipost.CatchFrequencyRow;
import java.util.List;
import org.nuiton.csv.ValueFormatter;

public class CatchFrequencyRowModel
extends TuttiCsvUtil.AbstractTuttiImportExportModel<CatchFrequencyRow> {
    public CatchFrequencyRowModel(char separator) {
        this(separator, null);
    }

    public CatchFrequencyRowModel(char separator, List<Caracteristic> caracteristics) {
        super(separator);
        this.newColumnForImportExport("batchId");
        this.newColumnForExport("lengthStepCaracteristic", (ValueFormatter)new ValueFormatter<Caracteristic>(){

            public String format(Caracteristic value) {
                return value != null ? value.getId() : "";
            }
        });
        if (caracteristics == null) {
            caracteristics = Lists.newArrayList();
        }
        ImmutableMap caracteristicMap = Maps.uniqueIndex((Iterable)caracteristics, (Function)TuttiEntities.GET_ID);
        this.newForeignKeyColumn("lengthStepCaracteristic", Caracteristic.class, "id", caracteristicMap);
        this.newColumnForImportExport("lengthStep", TuttiCsvUtil.FLOAT);
        this.newColumnForImportExport("number", TuttiCsvUtil.INTEGER);
        this.newColumnForImportExport("weight", TuttiCsvUtil.FLOAT);
    }

    public CatchFrequencyRow newEmptyInstance() {
        return new CatchFrequencyRow();
    }
}

