/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core;

import liquibase.database.AbstractDatabase;
import liquibase.database.DatabaseConnection;
import liquibase.exception.DatabaseException;

public class CacheDatabase
extends AbstractDatabase {
    public static final String PRODUCT_NAME = "cache";

    public String getCurrentDateTimeFunction() {
        if (this.currentDateTimeFunction != null) {
            return this.currentDateTimeFunction;
        }
        return "SYSDATE";
    }

    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:Cache")) {
            return "com.intersys.jdbc.CacheDriver";
        }
        return null;
    }

    public int getPriority() {
        return 1;
    }

    public String getTypeName() {
        return PRODUCT_NAME;
    }

    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        return PRODUCT_NAME.equalsIgnoreCase(conn.getDatabaseProductName());
    }

    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    public String getLineComment() {
        return "--";
    }

    protected String getDefaultDatabaseSchemaName() throws DatabaseException {
        return "";
    }

    public boolean supportsSequences() {
        return false;
    }

    public boolean supportsTablespaces() {
        return false;
    }

    public boolean supportsAutoIncrement() {
        return false;
    }

    public String getViewDefinition(String schemaName, String viewName) throws DatabaseException {
        return null;
    }
}

