/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeLogIterator {
    private DatabaseChangeLog databaseChangeLog;
    private List<ChangeSetFilter> changeSetFilters;

    public ChangeLogIterator(DatabaseChangeLog databaseChangeLog, ChangeSetFilter ... changeSetFilters) {
        this.databaseChangeLog = databaseChangeLog;
        this.changeSetFilters = Arrays.asList(changeSetFilters);
    }

    public ChangeLogIterator(List<RanChangeSet> changeSetList, DatabaseChangeLog changeLog, ChangeSetFilter ... changeSetFilters) {
        final ArrayList<ChangeSet> changeSets = new ArrayList<ChangeSet>();
        for (RanChangeSet ranChangeSet : changeSetList) {
            ChangeSet changeSet = changeLog.getChangeSet(ranChangeSet);
            if (changeSet == null) continue;
            changeSets.add(changeSet);
        }
        this.databaseChangeLog = new DatabaseChangeLog(){

            @Override
            public List<ChangeSet> getChangeSets() {
                return changeSets;
            }
        };
        this.changeSetFilters = Arrays.asList(changeSetFilters);
    }

    public void run(ChangeSetVisitor visitor, Database database) throws LiquibaseException {
        List<ChangeSet> changeSetList = this.databaseChangeLog.getChangeSets();
        if (visitor.getDirection().equals((Object)ChangeSetVisitor.Direction.REVERSE)) {
            Collections.reverse(changeSetList);
        }
        for (ChangeSet changeSet : changeSetList) {
            boolean shouldVisit = true;
            if (this.changeSetFilters != null) {
                for (ChangeSetFilter filter : this.changeSetFilters) {
                    if (filter.accepts(changeSet)) continue;
                    shouldVisit = false;
                    break;
                }
            }
            if (!shouldVisit) continue;
            visitor.visit(changeSet, this.databaseChangeLog, database);
        }
    }
}

