/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import java.util.HashSet;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import jaxx.runtime.SwingUtil;
import org.jdesktop.swingx.JXTable;
import org.nuiton.i18n.I18n;

public class RemoveSpeciesSubBatchAction
extends AbstractTuttiAction<SpeciesBatchUIModel, SpeciesBatchUI, SpeciesBatchUIHandler> {
    protected int rowIndex;

    public RemoveSpeciesSubBatchAction(SpeciesBatchUIHandler handler) {
        super(handler, false);
    }

    @Override
    public boolean prepareAction() throws Exception {
        boolean result = super.prepareAction();
        this.rowIndex = -1;
        if (result) {
            int answer = JOptionPane.showConfirmDialog(this.getContext().getActionUI(), I18n._((String)"tutti.editSpeciesBatch.action.removeSubBatch.confirm.message", (Object[])new Object[0]), I18n._((String)"tutti.editSpeciesBatch.action.removeSubBatch.confirm.title", (Object[])new Object[0]), 0);
            result = answer == 0;
        }
        return result;
    }

    @Override
    public void doAction() throws Exception {
        PersistenceService persistenceService = this.getContext().getPersistenceService();
        JXTable table = ((SpeciesBatchUIHandler)this.handler).getTable();
        this.rowIndex = SwingUtil.getSelectedModelRow((JTable)table);
        Preconditions.checkState((this.rowIndex != -1 ? 1 : 0) != 0, (Object)"Cant remove sub batch if no batch selected");
        SpeciesBatchRowModel parentBatch = (SpeciesBatchRowModel)((SpeciesBatchUIHandler)this.handler).getTableModel().getEntry(this.rowIndex);
        Preconditions.checkState((!TuttiEntities.isNew(parentBatch) ? 1 : 0) != 0, (Object)"Can't remove sub batch if batch is not persisted");
        persistenceService.deleteSpeciesSubBatch(parentBatch.getId());
        HashSet rowToRemove = Sets.newHashSet();
        ((SpeciesBatchUIHandler)this.handler).collectChildren(parentBatch, rowToRemove);
        ((SpeciesBatchUIModel)this.getModel()).getRows().removeAll(rowToRemove);
        parentBatch.setChildBatch(null);
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        JXTable table = ((SpeciesBatchUIHandler)this.handler).getTable();
        ((SpeciesBatchUIHandler)this.handler).getTableModel().fireTableDataChanged();
        TuttiUIUtil.selectFirstCellOnRow(table, this.rowIndex, true);
    }
}

