/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.service.TuttiEnumerationFile;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.pupitri.PupitriImportExportService;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.ImportPupitriPopupUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionHelper;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.nuiton.i18n.I18n;

public class ImportPupitriAction
extends AbstractTuttiAction<SpeciesBatchUIModel, SpeciesBatchUI, SpeciesBatchUIHandler> {
    protected File importedTrunkFile;
    protected File importedCarrouselFile;
    protected ImportPupitriPopupUI importPupitriDialog;
    protected PersistenceService persistenceService = this.getContext().getPersistenceService();
    protected EditFishingOperationAction editAction;

    public ImportPupitriAction(SpeciesBatchUIHandler handler) {
        super(handler, false);
        this.importPupitriDialog = new ImportPupitriPopupUI(handler.getContext());
    }

    public EditFishingOperationAction getEditAction() {
        if (this.editAction == null) {
            this.editAction = TuttiActionHelper.createLogicAction(((SpeciesBatchUIHandler)this.getHandler()).getParentUi().getHandler().getParentHandler(), EditFishingOperationAction.class);
        }
        return this.editAction;
    }

    @Override
    public boolean prepareAction() throws Exception {
        SpeciesBatchUIModel speciesBatchUIModel;
        boolean result = true;
        TuttiEnumerationFile enumerationFile = this.persistenceService.getEnumerationFile();
        SampleCategoryModel sampleCategoryModel = this.getDataContext().getSampleCategoryModel();
        ArrayList missingCategories = Lists.newArrayList();
        if (!sampleCategoryModel.containsCategoryId(enumerationFile.PMFM_ID_SIZE_CATEGORY)) {
            missingCategories.add("<li>" + this.persistenceService.getSizeCategoryCaracteristic().getParameterName() + "</li>");
        }
        if (!sampleCategoryModel.containsCategoryId(enumerationFile.PMFM_ID_SEX)) {
            missingCategories.add("<li>" + this.persistenceService.getSexCaracteristic().getParameterName() + "</li>");
        }
        if (!missingCategories.isEmpty()) {
            result = false;
            JOptionPane.showMessageDialog(this.getContext().getActionUI(), I18n._((String)"tutti.editSpeciesBatch.action.importPupitri.invalidSampleCategoryModel.message", (Object[])new Object[]{Joiner.on((String)"").join((Iterable)missingCategories)}), I18n._((String)"tutti.editSpeciesBatch.action.importPupitri.invalidSampleCategoryModel.title", (Object[])new Object[0]), 0, UIManager.getIcon("error"));
        }
        if (result && (speciesBatchUIModel = ((SpeciesBatchUI)this.getUI()).getModel()).getRowCount() > 0) {
            String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n._((String)"tutti.editSpeciesBatch.action.importPupitri.existingData.message", (Object[])new Object[0]), I18n._((String)"tutti.editSpeciesBatch.action.importPupitri.existingData.help", (Object[])new Object[0]));
            int answer = JOptionPane.showConfirmDialog(this.getContext().getActionUI(), htmlMessage, I18n._((String)"tutti.editSpeciesBatch.action.importPupitri.existingData.title", (Object[])new Object[0]), 2, 2);
            boolean bl = result = answer == 0;
        }
        if (result) {
            this.importPupitriDialog.open();
            this.importedTrunkFile = this.importPupitriDialog.getTrunkFile().getSelectedFile();
            this.importedCarrouselFile = this.importPupitriDialog.getCarrouselFile().getSelectedFile();
            result = this.importedTrunkFile != null && this.importedCarrouselFile != null;
        }
        return result;
    }

    @Override
    public void doAction() throws Exception {
        PupitriImportExportService pupitriImportExportService = this.getContext().getTuttiPupitriImportExportService();
        EditCatchesUIModel model = ((SpeciesBatchUI)this.getUI()).getHandler().getParentUi().getModel();
        FishingOperation operation = model.getFishingOperation();
        CatchBatch catchBatch = model.toEntity();
        int rejectedSpeciesNb = pupitriImportExportService.importPupitri(this.importedTrunkFile, this.importedCarrouselFile, operation, catchBatch);
        this.getEditAction().loadCatchBatch(operation);
        this.sendMessage(I18n._((String)"tutti.editSpeciesBatch.action.importPupitri.success", (Object[])new Object[]{((SpeciesBatchUIModel)this.getModel()).getRootNumber(), rejectedSpeciesNb}));
    }

    @Override
    public void releaseAction() {
        super.releaseAction();
        this.importedTrunkFile = null;
        this.importedCarrouselFile = null;
    }
}

