/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.Result;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.config.entities.InterceptorConfig;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import com.opensymphony.xwork2.conversion.TypeConverter;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.Interceptor;
import com.opensymphony.xwork2.util.ClassLoaderUtil;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import com.opensymphony.xwork2.util.reflection.ReflectionException;
import com.opensymphony.xwork2.util.reflection.ReflectionExceptionHandler;
import com.opensymphony.xwork2.util.reflection.ReflectionProvider;
import com.opensymphony.xwork2.validator.Validator;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectFactory
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectFactory.class);
    private transient ClassLoader ccl;
    private Container container;
    protected ReflectionProvider reflectionProvider;

    @Inject(value="objectFactory.classloader", required=false)
    public void setClassLoader(ClassLoader cl) {
        this.ccl = cl;
    }

    @Inject
    public void setReflectionProvider(ReflectionProvider prov) {
        this.reflectionProvider = prov;
    }

    public ObjectFactory() {
    }

    public ObjectFactory(ReflectionProvider prov) {
        this.reflectionProvider = prov;
    }

    @Inject
    public void setContainer(Container container) {
        this.container = container;
    }

    @Deprecated
    public static ObjectFactory getObjectFactory() {
        return ActionContext.getContext().getContainer().getInstance(ObjectFactory.class);
    }

    public boolean isNoArgConstructorRequired() {
        return true;
    }

    public Class getClassInstance(String className) throws ClassNotFoundException {
        if (this.ccl != null) {
            return this.ccl.loadClass(className);
        }
        return ClassLoaderUtil.loadClass(className, this.getClass());
    }

    public Object buildAction(String actionName, String namespace, ActionConfig config, Map<String, Object> extraContext) throws Exception {
        return this.buildBean(config.getClassName(), extraContext);
    }

    public Object buildBean(Class clazz, Map<String, Object> extraContext) throws Exception {
        return clazz.newInstance();
    }

    protected Object injectInternalBeans(Object obj) {
        if (obj != null && this.container != null) {
            this.container.inject(obj);
        }
        return obj;
    }

    public Object buildBean(String className, Map<String, Object> extraContext) throws Exception {
        return this.buildBean(className, extraContext, true);
    }

    public Object buildBean(String className, Map<String, Object> extraContext, boolean injectInternal) throws Exception {
        Class clazz = this.getClassInstance(className);
        Object obj = this.buildBean(clazz, extraContext);
        if (injectInternal) {
            this.injectInternalBeans(obj);
        }
        return obj;
    }

    public Interceptor buildInterceptor(InterceptorConfig interceptorConfig, Map<String, String> interceptorRefParams) throws ConfigurationException {
        String message;
        Throwable cause;
        String interceptorClassName = interceptorConfig.getClassName();
        Map<String, String> thisInterceptorClassParams = interceptorConfig.getParams();
        HashMap<String, String> params = thisInterceptorClassParams == null ? new HashMap<String, String>() : new HashMap<String, String>(thisInterceptorClassParams);
        params.putAll(interceptorRefParams);
        try {
            Interceptor interceptor = (Interceptor)this.buildBean(interceptorClassName, null);
            this.reflectionProvider.setProperties(params, interceptor);
            interceptor.init();
            return interceptor;
        }
        catch (InstantiationException e) {
            cause = e;
            message = "Unable to instantiate an instance of Interceptor class [" + interceptorClassName + "].";
        }
        catch (IllegalAccessException e) {
            cause = e;
            message = "IllegalAccessException while attempting to instantiate an instance of Interceptor class [" + interceptorClassName + "].";
        }
        catch (ClassCastException e) {
            cause = e;
            message = "Class [" + interceptorClassName + "] does not implement com.opensymphony.xwork2.interceptor.Interceptor";
        }
        catch (Exception e) {
            cause = e;
            message = "Caught Exception while registering Interceptor class " + interceptorClassName;
        }
        catch (NoClassDefFoundError e) {
            cause = e;
            message = "Could not load class " + interceptorClassName + ". Perhaps it exists but certain dependencies are not available?";
        }
        throw new ConfigurationException(message, cause, interceptorConfig);
    }

    public Result buildResult(ResultConfig resultConfig, Map<String, Object> extraContext) throws Exception {
        String resultClassName = resultConfig.getClassName();
        Result result = null;
        if (resultClassName != null) {
            result = (Result)this.buildBean(resultClassName, extraContext);
            Map<String, String> params = resultConfig.getParams();
            if (params != null) {
                for (Map.Entry<String, String> paramEntry : params.entrySet()) {
                    try {
                        this.reflectionProvider.setProperty(paramEntry.getKey(), paramEntry.getValue(), result, extraContext, true);
                    }
                    catch (ReflectionException ex) {
                        if (!(result instanceof ReflectionExceptionHandler)) continue;
                        ((ReflectionExceptionHandler)((Object)result)).handle(ex);
                    }
                }
            }
        }
        return result;
    }

    public Validator buildValidator(String className, Map<String, Object> params, Map<String, Object> extraContext) throws Exception {
        Validator validator = (Validator)this.buildBean(className, extraContext);
        this.reflectionProvider.setProperties(params, validator, extraContext);
        return validator;
    }

    public TypeConverter buildConverter(Class<? extends TypeConverter> converterClass) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating converter of type [#0]", converterClass.getCanonicalName());
        }
        return this.container.getInstance(converterClass);
    }

    public TypeConverter buildConverter(Class<? extends TypeConverter> converterClass, String name) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating converter of type [#0] with name [#1]", converterClass.getCanonicalName(), name);
        }
        return this.container.getInstance(converterClass, name);
    }

    public TypeConverter buildConverter(String name) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating converter with name [#0]", name);
        }
        TypeConverter instance = this.container.getInstance(TypeConverter.class, name);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Converter of Type [#0] with name [#1], created!", instance.getClass().getCanonicalName(), name);
        }
        return instance;
    }

    static class ContinuationsClassLoader
    extends ClassLoader {
        ContinuationsClassLoader() {
        }
    }
}

