/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.comment;

import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import jaxx.runtime.SwingUtil;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.i18n.I18n;

public class CommentCellRenderer
extends DefaultTableCellRenderer {
    public static final String TEXT_PATTERN = "<html><body>%s</body></html>";
    private static final long serialVersionUID = 1L;
    private final String noneText;

    public static CommentCellRenderer newRender() {
        return new CommentCellRenderer();
    }

    protected CommentCellRenderer() {
        this.setHorizontalAlignment(0);
        this.setIcon(SwingUtil.createActionIcon((String)"edit-comment"));
        this.noneText = I18n.n_((String)"tutti.commentEditor.none.tip", (Object[])new Object[0]);
    }

    @Override
    protected void setValue(Object value) {
    }

    @Override
    public JComponent getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String comment = (String)value;
        String toolTipTextValue = StringUtils.isEmpty((CharSequence)comment) ? "<i>" + I18n._((String)this.noneText, (Object[])new Object[0]) + "</i>" : String.valueOf(value).replace("\n", "<br/>");
        boolean editable = table.isCellEditable(row, column);
        toolTipTextValue = String.format(TEXT_PATTERN, toolTipTextValue);
        this.setEnabled(editable);
        this.setToolTipText(toolTipTextValue);
        this.setBackground(null);
        return this;
    }
}

