/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.action;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.service.TuttiDataContext;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfig;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionUI;
import java.awt.Component;
import java.io.File;
import javax.swing.JOptionPane;
import jaxx.runtime.FileChooserUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.beans.AbstractBean;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.util.StringUtil;

public abstract class AbstractTuttiAction<M extends AbstractBean, UI extends TuttiUI<M, ?>, H extends AbstractTuttiUIHandler<M, UI>>
extends AbstractBean {
    private static final Log log = LogFactory.getLog(AbstractTuttiAction.class);
    public static final String PROPERTY_DONE = "done";
    protected final H handler;
    protected String actionDescription;
    protected final boolean hideBody;
    protected final Object lock = new Object();

    public abstract void doAction() throws Exception;

    protected AbstractTuttiAction(H handler, boolean hideBody) {
        this.handler = handler;
        this.hideBody = hideBody;
    }

    public boolean prepareAction() throws Exception {
        return true;
    }

    protected void releaseAction() {
        this.firePropertyChange(PROPERTY_DONE, null, true);
    }

    public void postSuccessAction() {
    }

    public void postFailedAction(Throwable error) {
    }

    public H getHandler() {
        return this.handler;
    }

    public M getModel() {
        return (M)((AbstractBean)((AbstractTuttiUIHandler)this.handler).getModel());
    }

    public final UI getUI() {
        return ((AbstractTuttiUIHandler)this.handler).getUI();
    }

    public TuttiUIContext getContext() {
        return ((AbstractTuttiUIHandler)this.handler).getContext();
    }

    public String getActionDescription() {
        return this.actionDescription;
    }

    public void setActionDescription(String actionDescription) {
        this.actionDescription = actionDescription;
    }

    public void setProgressionModel(ProgressionModel progressionModel) {
        this.getContext().getActionUI().getModel().setProgressionModel(progressionModel);
    }

    protected ProgressionModel getProgressionModel() {
        return this.getContext().getActionUI().getModel().getProgressionModel();
    }

    public boolean isHideBody() {
        return this.hideBody;
    }

    public TuttiDataContext getDataContext() {
        return this.getContext().getDataContext();
    }

    protected TuttiApplicationConfig getConfig() {
        return this.getContext().getConfig();
    }

    protected void sendMessage(String message) {
        this.getContext().showInformationMessage(message);
    }

    protected <O> Decorator<O> getDecorator(Class<O> type, String name) {
        Decorator<O> decorator = ((AbstractTuttiUIHandler)this.handler).getDecorator(type, name);
        Preconditions.checkNotNull(decorator);
        return decorator;
    }

    protected String decorate(Object object) {
        return this.getDecorator(object.getClass(), null).toString(object);
    }

    protected String decorate(Object object, String context) {
        return this.getDecorator(object.getClass(), context).toString(object);
    }

    protected boolean askAdminPassword(String askMessage, String askMessageTitle, String errorMessage, String errorMessageTitle) {
        String answer;
        boolean result;
        TuttiActionUI container = this.getContext().getActionUI();
        do {
            if ((answer = JOptionPane.showInputDialog(container, askMessage, askMessageTitle, 2)) != null) {
                String correctAnswer;
                String cryptedAnswer = StringUtil.encodeMD5((String)answer);
                result = StringUtils.equals((CharSequence)cryptedAnswer, (CharSequence)(correctAnswer = this.getConfig().getAdminPassword()));
                if (result) continue;
                JOptionPane.showMessageDialog(container, errorMessage, errorMessageTitle, 0);
                continue;
            }
            result = false;
        } while (!result && answer != null);
        return result;
    }

    protected File chooseFile(String title, String buttonLabel, String ... filters) {
        File file = FileChooserUtil.getFile((String)title, (String)buttonLabel, (Component)this.getContext().getMainUI(), (String[])filters);
        if (log.isDebugEnabled()) {
            log.debug((Object)(title + " : " + file));
        }
        if (file != null) {
            File newDir = file.isDirectory() ? file : file.getParentFile();
            FileChooserUtil.setCurrentDirectory((File)newDir);
        }
        return file;
    }

    protected File saveFile(File defaultFile, String filename, String extension, String title, String buttonLabel, String ... filters) {
        if (defaultFile != null && FileChooserUtil.isCurrentDirectoryDefault()) {
            FileChooserUtil.setCurrentDirectory((File)defaultFile);
        }
        File file = this.saveFile(filename, extension, title, buttonLabel, filters);
        return file;
    }

    protected File saveFile(String filename, String extension, String title, String buttonLabel, String ... filters) {
        boolean withExtension = StringUtils.isNotBlank((CharSequence)extension);
        String filenameSuffix = withExtension ? "." + extension : "";
        File file = FileChooserUtil.saveFile((String)(filename + filenameSuffix), (String)title, (String)buttonLabel, (Component)this.getContext().getMainUI(), (String[])filters);
        if (log.isDebugEnabled()) {
            log.debug((Object)(title + " : " + file));
        }
        if (file != null) {
            boolean confirm;
            Preconditions.checkState((!file.isDirectory() ? 1 : 0) != 0);
            if (withExtension && !file.getName().endsWith(filenameSuffix)) {
                file = new File(file.getParentFile(), file.getName() + filenameSuffix);
            }
            if (confirm = this.askOverwriteFile(file)) {
                FileChooserUtil.setCurrentDirectory((File)file.getParentFile());
            } else {
                file = null;
            }
        }
        return file;
    }

    private boolean askOverwriteFile(File file) {
        boolean result;
        if (file.exists()) {
            String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n._((String)"tutti.common.askOverwriteFile.message", (Object[])new Object[]{file}), I18n._((String)"tutti.common.askOverwriteFile.help", (Object[])new Object[0]));
            result = JOptionPane.showConfirmDialog(((AbstractTuttiUIHandler)this.getHandler()).getTopestUI(), htmlMessage, I18n._((String)"tutti.common.askOverwriteFile.title", (Object[])new Object[0]), 2, 3) == 0;
        } else {
            result = true;
        }
        return result;
    }

    protected boolean askBeforeDelete(String title, String message) {
        String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", message, I18n._((String)"tutti.common.askBeforeDelete.help", (Object[])new Object[0]));
        int i = JOptionPane.showConfirmDialog(((AbstractTuttiUIHandler)this.getHandler()).getTopestUI(), htmlMessage, title, 2, 3);
        boolean result = i == 0;
        return result;
    }

    protected void displayInfoMessage(String title, String message) {
        JOptionPane.showMessageDialog(((AbstractTuttiUIHandler)this.getHandler()).getTopestUI(), message, title, 1);
    }

    protected void displayWarningMessage(String title, String message) {
        JOptionPane.showMessageDialog(((AbstractTuttiUIHandler)this.getHandler()).getTopestUI(), message, title, 2);
    }
}

