/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.split;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.tutti.persistence.entities.data.SampleCategory;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModelEntry;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SelectedCategoryAble;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.split.SplitBenthosBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.split.SplitBenthosBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.split.SplitBenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.split.SplitBenthosBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.Cancelable;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIHandler;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class SplitBenthosBatchUIHandler
extends AbstractTuttiTableUIHandler<SplitBenthosBatchRowModel, SplitBenthosBatchUIModel, SplitBenthosBatchUI>
implements Cancelable {
    private static final Log log = LogFactory.getLog(SplitBenthosBatchUIHandler.class);

    public SplitBenthosBatchUIHandler(EditCatchesUI parentUi, SplitBenthosBatchUI ui) {
        super(parentUi.getHandler().getContext(), ui, "selected", "categoryValue", "weight");
    }

    public SplitBenthosBatchTableModel getTableModel() {
        return (SplitBenthosBatchTableModel)this.getTable().getModel();
    }

    @Override
    public JXTable getTable() {
        return ((SplitBenthosBatchUI)this.ui).getTable();
    }

    @Override
    protected boolean isRowValid(SplitBenthosBatchRowModel row) {
        return row.isSelected();
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<SplitBenthosBatchRowModel> rowMonitor, SplitBenthosBatchRowModel row) {
        if (rowMonitor.wasModified()) {
            if (row.isValid() && log.isInfoEnabled()) {
                log.info((Object)"Change row that was modified and valid");
            }
            rowMonitor.clearModified();
        }
    }

    @Override
    protected void onAfterSelectedRowChanged(int oldRowIndex, SplitBenthosBatchRowModel oldRow, int newRowIndex, SplitBenthosBatchRowModel newRow) {
        super.onAfterSelectedRowChanged(oldRowIndex, oldRow, newRowIndex, newRow);
        if (newRow != null) {
            this.recomputeRowValidState(newRow);
            this.computeSampleWeight();
        }
    }

    @Override
    protected void onRowModified(int rowIndex, SplitBenthosBatchRowModel row, String propertyName, Object oldValue, Object newValue) {
        this.recomputeRowValidState(row);
        this.computeSampleWeight();
    }

    @Override
    public SwingValidator<SplitBenthosBatchUIModel> getValidator() {
        return ((SplitBenthosBatchUI)this.ui).getValidator();
    }

    @Override
    public void beforeInitUI() {
        SampleCategoryModel sampleCategoryModel = this.getDataContext().getSampleCategoryModel();
        SplitBenthosBatchUIModel model = new SplitBenthosBatchUIModel(this.getConfig().getBenthosWeightUnit(), sampleCategoryModel);
        ((SplitBenthosBatchUI)this.ui).setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        this.initUI(this.ui);
        SplitBenthosBatchUIModel model = (SplitBenthosBatchUIModel)this.getModel();
        model.addPropertyChangeListener("category", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SplitBenthosBatchUIModel source = (SplitBenthosBatchUIModel)evt.getSource();
                source.setSelectedCategory(null);
                List data = (List)evt.getNewValue();
                ((SplitBenthosBatchUI)SplitBenthosBatchUIHandler.this.ui).getCategoryComboBox().setModel(new DefaultComboBoxModel<Object>(data.toArray()));
            }
        });
        model.addPropertyChangeListener("selectedCategory", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SplitBenthosBatchUIModel source = (SplitBenthosBatchUIModel)evt.getSource();
                source.setSampleWeight(null);
                SampleCategoryModelEntry newValue = (SampleCategoryModelEntry)evt.getNewValue();
                SplitBenthosBatchUIHandler.this.generateTableModel(newValue);
            }
        });
        ((SplitBenthosBatchUI)this.ui).getCategoryComboBox().setRenderer(this.newListCellRender(SampleCategoryModelEntry.class));
        ((SplitBenthosBatchUI)this.ui).getCategoryComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox comboBox = (JComboBox)e.getSource();
                ((SplitBenthosBatchUIModel)SplitBenthosBatchUIHandler.this.getModel()).setSelectedCategory((SampleCategoryModelEntry)comboBox.getSelectedItem());
            }
        });
        this.generateTableModel(null);
        this.initTable(this.getTable());
        this.listenValidatorValid((SimpleBeanValidator)((SplitBenthosBatchUI)this.ui).getValidator(), model);
    }

    @Override
    protected JComponent getComponentToFocus() {
        return ((SplitBenthosBatchUI)this.getUI()).getCategoryComboBox();
    }

    @Override
    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        ((SplitBenthosBatchUI)this.ui).getValidator().setBean(null);
        ((SplitBenthosBatchUIModel)this.getModel()).setValid(false);
        ((SplitBenthosBatchUIModel)this.getModel()).setSelectedCategory(null);
        EditCatchesUI parent = (EditCatchesUI)SwingUtil.getParentContainer((Object)this.ui, EditCatchesUI.class);
        parent.getHandler().setBenthosSelectedCard("main");
    }

    @Override
    public void cancel() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cancel UI " + this.ui));
        }
        this.closeUI(this.ui);
    }

    public void editBatch(BenthosBatchRowModel batch) {
        ArrayList categories = Lists.newArrayList();
        if (batch != null) {
            SampleCategoryModel sampleCategoryModel = ((SplitBenthosBatchUIModel)this.getModel()).getSampleCategoryModel();
            categories.addAll(sampleCategoryModel.getCategory());
            SampleCategory lastCategory = batch.getFinestCategory();
            Preconditions.checkNotNull((Object)lastCategory, (Object)"Can't split a benthos batch with no sample category.");
            int firstOrder = lastCategory.getCategoryDef().getOrder();
            for (Integer sampleCategoryId : sampleCategoryModel.getSamplingOrder()) {
                SampleCategory<?> sampleCategory = batch.getSampleCategoryById(sampleCategoryId);
                int order = sampleCategory.getCategoryDef().getOrder();
                if (order >= firstOrder && !sampleCategory.isValid()) continue;
                categories.remove(sampleCategory.getCategoryDef());
            }
        }
        SplitBenthosBatchUIModel model = (SplitBenthosBatchUIModel)this.getModel();
        ((SplitBenthosBatchUI)this.ui).getValidator().setBean((Object)model);
        model.setSampleWeight(null);
        model.setCategory(categories);
        if (CollectionUtils.isNotEmpty((Collection)categories)) {
            model.setSelectedCategory((SampleCategoryModelEntry)categories.get(0));
        }
        model.setBatch(batch);
    }

    public void editBatch(BenthosBatchRowModel batch, int sampleCategoryId) {
        Preconditions.checkNotNull((Object)batch);
        Preconditions.checkNotNull((Object)sampleCategoryId);
        List<BenthosBatchRowModel> rows = batch.getChildBatch();
        Preconditions.checkNotNull(rows);
        ArrayList categories = Lists.newArrayList();
        SampleCategoryModel sampleCategoryModel = ((SplitBenthosBatchUIModel)this.getModel()).getSampleCategoryModel();
        SampleCategoryModelEntry selectedCategory = sampleCategoryModel.getCategoryById(sampleCategoryId);
        categories.add(selectedCategory);
        SplitBenthosBatchUIModel model = (SplitBenthosBatchUIModel)this.getModel();
        ((SplitBenthosBatchUI)this.ui).getValidator().setBean((Object)model);
        model.setSampleWeight(null);
        model.setCategory(categories);
        model.setSelectedCategory(selectedCategory);
        model.setBatch(batch);
        ImmutableMap rowsByValue = Maps.uniqueIndex(model.getRows(), (Function)new Function<SplitBenthosBatchRowModel, Serializable>(){

            public Serializable apply(SplitBenthosBatchRowModel input) {
                return input.getCategoryValue();
            }
        });
        for (BenthosBatchRowModel row : rows) {
            SampleCategory<?> sampleCategory = row.getSampleCategoryById(sampleCategoryId);
            Object categoryValue = sampleCategory.getCategoryValue();
            SplitBenthosBatchRowModel splitRow = (SplitBenthosBatchRowModel)rowsByValue.get(categoryValue);
            splitRow.setWeight(sampleCategory.getCategoryWeight());
            splitRow.setSelected(true);
            splitRow.setEditable(false);
        }
        this.computeSampleWeight();
        this.getTableModel().fireTableDataChanged();
    }

    public void save() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Save UI " + this.ui));
        }
        EditCatchesUI parent = (EditCatchesUI)SwingUtil.getParentContainer((Object)this.ui, EditCatchesUI.class);
        SplitBenthosBatchUIModel model = (SplitBenthosBatchUIModel)this.getModel();
        if (model.isValid()) {
            if (model.isSplitMode()) {
                parent.getBenthosTabContent().getHandler().splitBatch(model.getSelectedCategory(), model.getRows(), model.getSampleWeight());
            } else {
                parent.getBenthosTabContent().getHandler().addSampleCategoryBatch(model.getBatch(), model.getSelectedCategory(), model.getRows(), model.getSampleWeight());
            }
        }
        this.closeUI(this.ui);
    }

    protected void computeSampleWeight() {
        Float result = null;
        List rows = this.getTableModel().getRows();
        for (SplitBenthosBatchRowModel row : rows) {
            Float weight;
            if (!row.isSelected() || (weight = row.getWeight()) == null) continue;
            if (result == null) {
                result = Float.valueOf(0.0f);
            }
            result = Float.valueOf(result.floatValue() + weight.floatValue());
        }
        ((SplitBenthosBatchUIModel)this.getModel()).setSampleWeight(result);
    }

    protected void generateTableModel(SampleCategoryModelEntry category) {
        ((SplitBenthosBatchUIModel)this.getModel()).setRows(null);
        Caracteristic data = null;
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        this.addBooleanColumnToModel((TableColumnModel)columnModel, SplitBenthosBatchTableModel.SELECTED, (JTable)this.getTable());
        boolean editableCategoryValue = false;
        if (category != null) {
            if (!category.getCaracteristic().isQualitativeValueEmpty()) {
                data = category.getCaracteristic();
            } else {
                editableCategoryValue = true;
                this.addFloatColumnToModel((TableColumnModel)columnModel, SplitBenthosBatchTableModel.EDITABLE_CATEGORY_VALUE, TuttiUI.DECIMAL1_PATTERN);
            }
            if (data != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Got " + data.sizeQualitativeValue() + " qualitative data to add"));
                }
                this.addColumnToModel((TableColumnModel)columnModel, null, this.newTableCellRender(CaracteristicQualitativeValue.class), SplitBenthosBatchTableModel.READ_ONLY_CATEGORY_VALUE);
            }
            this.addFloatColumnToModel((TableColumnModel)columnModel, SplitBenthosBatchTableModel.WEIGHT, this.getConfig().getBenthosWeightUnit());
        }
        SplitBenthosBatchTableModel tableModel = new SplitBenthosBatchTableModel((TableColumnModelExt)columnModel, (SelectedCategoryAble)this.getModel(), editableCategoryValue, ((SplitBenthosBatchUIModel)this.getModel()).isSplitMode());
        JXTable table = this.getTable();
        this.uninstallTableSaveOnRowChangedSelectionListener();
        this.uninstallTableKeyListener();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Install new table model " + tableModel));
        }
        table.setModel((TableModel)tableModel);
        table.setColumnModel((TableColumnModel)columnModel);
        this.installTableSaveOnRowChangedSelectionListener();
        this.installTableKeyListener((TableColumnModel)columnModel, (JTable)table);
        ArrayList rows = Lists.newArrayList();
        if (data != null) {
            for (CaracteristicQualitativeValue qualitativeValue : data.getQualitativeValue()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Add QV: " + qualitativeValue));
                }
                SplitBenthosBatchRowModel newRow = tableModel.createNewRow();
                newRow.setCategoryValue(qualitativeValue);
                rows.add(newRow);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will add " + rows.size() + " rows in table model " + "(can add a first empty row? " + editableCategoryValue + ")."));
        }
        ((SplitBenthosBatchUIModel)this.getModel()).setRows(rows);
    }
}

