package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.create;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModelEntry;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class CreateBenthosBatchUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<CreateBenthosBatchUIModel, CreateBenthosBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BATCH_COUNT_FIELD_MODEL = "batchCountField.model";
    public static final String BINDING_BATCH_COUNT_FIELD_NUMBER_PATTERN = "batchCountField.numberPattern";
    public static final String BINDING_BATCH_WEIGHT_FIELD_MODEL = "batchWeightField.model";
    public static final String BINDING_CATEGORY_COMBO_BOX_DATA = "categoryComboBox.data";
    public static final String BINDING_CATEGORY_COMBO_BOX_ENABLED = "categoryComboBox.enabled";
    public static final String BINDING_CATEGORY_COMBO_BOX_SELECTED_ITEM = "categoryComboBox.selectedItem";
    public static final String BINDING_CATEGORY_PANEL_VISIBLE = "categoryPanel.visible";
    public static final String BINDING_SAMPLE_CATEGORY_COMBO_BOX_SELECTED_ITEM = "sampleCategoryComboBox.selectedItem";
    public static final String BINDING_SAMPLE_WEIGHT_FIELD_TEXT = "sampleWeightField.text";
    public static final String BINDING_SAVE_AND_CLOSE_BUTTON_ENABLED = "saveAndCloseButton.enabled";
    public static final String BINDING_SAVE_AND_CONTINUE_BUTTON_ENABLED = "saveAndContinueButton.enabled";
    public static final String BINDING_SPECIES_COMBO_BOX_DATA = "speciesComboBox.data";
    public static final String BINDING_SPECIES_COMBO_BOX_SELECTED_ITEM = "speciesComboBox.selectedItem";
    public static final String BINDING_TABLE_ENABLED = "table.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(CreateBenthosBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addSpeciesButton;
    @ValidatorField( validatorId = "validator",  propertyName = "batchCount",  editorName = "batchCountField")
    protected NumberEditor batchCountField;
    protected JLabel batchCountLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "batchWeight",  editorName = "batchWeightField")
    protected NumberEditor batchWeightField;
    protected JLabel batchWeightLabel;
    protected TuttiHelpBroker broker;
    protected JButton cancelButton;
    @ValidatorField( validatorId = "validator",  propertyName = "selectedCategory",  editorName = "categoryComboBox")
    protected BeanFilterableComboBox<SampleCategoryModelEntry> categoryComboBox;
    protected Table categoryConfigurationPanel;
    protected JLabel categoryLabel;
    protected JPanel categoryPanel;
    protected Table configurationPanel;
    protected CreateBenthosBatchUI createBenthosBatchTopPanel = this;
    protected CreateBenthosBatchUIHandler handler;
    protected CreateBenthosBatchUIModel model;
    @ValidatorField( validatorId = "validator",  propertyName = "sampleCategory",  editorName = "sampleCategoryComboBox")
    protected BeanFilterableComboBox<CaracteristicQualitativeValue> sampleCategoryComboBox;
    protected JLabel sampleCategoryLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "sampleWeight",  editorName = "sampleWeightField")
    protected JTextField sampleWeightField;
    protected JLabel sampleWeightLabel;
    protected JButton saveAndCloseButton;
    protected JButton saveAndContinueButton;
    @ValidatorField( validatorId = "validator",  propertyName = "species",  editorName = "speciesComboBox")
    protected BeanFilterableComboBox<Species> speciesComboBox;
    protected JLabel speciesLabel;
    protected JXTable table;
    protected JScrollPane tableScrollPane;
    @Validator( validatorId = "validator")
    protected SwingValidator<CreateBenthosBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JSeparator $JSeparator0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CreateBenthosBatchUI(EditCatchesUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            CreateBenthosBatchUIHandler handler = new CreateBenthosBatchUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public CreateBenthosBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CreateBenthosBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateBenthosBatchUI() {
        $initialize();
    }

    public CreateBenthosBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateBenthosBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public CreateBenthosBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateBenthosBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public CreateBenthosBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__saveAndCloseButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.saveAndClose();
    }

    public void doActionPerformed__on__saveAndContinueButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.saveAndContinue();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddSpeciesButton() {
        return addSpeciesButton;
    }

    public NumberEditor getBatchCountField() {
        return batchCountField;
    }

    public JLabel getBatchCountLabel() {
        return batchCountLabel;
    }

    public NumberEditor getBatchWeightField() {
        return batchWeightField;
    }

    public JLabel getBatchWeightLabel() {
        return batchWeightLabel;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public BeanFilterableComboBox<SampleCategoryModelEntry> getCategoryComboBox() {
        return categoryComboBox;
    }

    public Table getCategoryConfigurationPanel() {
        return categoryConfigurationPanel;
    }

    public JLabel getCategoryLabel() {
        return categoryLabel;
    }

    public JPanel getCategoryPanel() {
        return categoryPanel;
    }

    public Table getConfigurationPanel() {
        return configurationPanel;
    }

    public CreateBenthosBatchUIHandler getHandler() {
        return handler;
    }

    public CreateBenthosBatchUIModel getModel() {
        return model;
    }

    public BeanFilterableComboBox<CaracteristicQualitativeValue> getSampleCategoryComboBox() {
        return sampleCategoryComboBox;
    }

    public JLabel getSampleCategoryLabel() {
        return sampleCategoryLabel;
    }

    public JTextField getSampleWeightField() {
        return sampleWeightField;
    }

    public JLabel getSampleWeightLabel() {
        return sampleWeightLabel;
    }

    public JButton getSaveAndCloseButton() {
        return saveAndCloseButton;
    }

    public JButton getSaveAndContinueButton() {
        return saveAndContinueButton;
    }

    public BeanFilterableComboBox<Species> getSpeciesComboBox() {
        return speciesComboBox;
    }

    public JLabel getSpeciesLabel() {
        return speciesLabel;
    }

    public JXTable getTable() {
        return table;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public SwingValidator<CreateBenthosBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCategoryConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        categoryConfigurationPanel.add($JSeparator0, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        categoryConfigurationPanel.add(categoryLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        categoryConfigurationPanel.add(SwingUtil.boxComponentWithJxLayer(categoryComboBox), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        categoryConfigurationPanel.add(sampleWeightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        categoryConfigurationPanel.add(SwingUtil.boxComponentWithJxLayer(sampleWeightField), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToCategoryPanel() {
        if (!allComponentsCreated) {
            return;
        }
        categoryPanel.add(categoryConfigurationPanel, BorderLayout.NORTH);
        categoryPanel.add(tableScrollPane, BorderLayout.CENTER);
    }

    protected void addChildrenToConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configurationPanel.add(speciesLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(speciesComboBox), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(addSpeciesButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(batchWeightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(batchWeightField), new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(batchCountLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(batchCountField), new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(sampleCategoryLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(sampleCategoryComboBox), new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToCreateBenthosBatchTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(configurationPanel, BorderLayout.NORTH);
        add(categoryPanel, BorderLayout.CENTER);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAddSpeciesButton() {
        $objectMap.put("addSpeciesButton", addSpeciesButton = new JButton());
        
        addSpeciesButton.setName("addSpeciesButton");
        addSpeciesButton.setText(_("tutti.createBenthosBatch.action.addSpecies"));
        addSpeciesButton.setToolTipText(_("tutti.createBenthosBatch.action.addSpecies.tip"));
        addSpeciesButton.putClientProperty("help", "tutti.createBenthosBatch.action.addSpecies.help");
        addSpeciesButton.putClientProperty("tuttiAction", SelectSpeciesForBenthosBatchAction.class);
    }

    protected void createBatchCountField() {
        $objectMap.put("batchCountField", batchCountField = new NumberEditor(this));
        
        batchCountField.setName("batchCountField");
        batchCountField.setProperty("batchCount");
        batchCountField.setUseFloat(false);
        batchCountField.setShowReset(true);
    }

    protected void createBatchCountLabel() {
        $objectMap.put("batchCountLabel", batchCountLabel = new JLabel());
        
        batchCountLabel.setName("batchCountLabel");
        batchCountLabel.setText(_("tutti.createBenthosBatch.field.batchCount"));
        batchCountLabel.setToolTipText(_("tutti.createBenthosBatch.field.batchCount.tip"));
        batchCountLabel.putClientProperty("help", "tutti.createBenthosBatch.field.batchCount.help");
    }

    protected void createBatchWeightField() {
        $objectMap.put("batchWeightField", batchWeightField = new NumberEditor(this));
        
        batchWeightField.setName("batchWeightField");
        batchWeightField.setProperty("batchWeight");
        batchWeightField.setUseFloat(true);
        batchWeightField.setShowReset(true);
    }

    protected void createBatchWeightLabel() {
        $objectMap.put("batchWeightLabel", batchWeightLabel = new JLabel());
        
        batchWeightLabel.setName("batchWeightLabel");
        batchWeightLabel.setText(_("tutti.createBenthosBatch.field.batchWeight"));
        batchWeightLabel.setToolTipText(_("tutti.createBenthosBatch.field.batchWeight.tip"));
        batchWeightLabel.putClientProperty("help", "tutti.createBenthosBatch.field.batchWeight.help");
        batchWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getBenthosWeightUnit());
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.createBenthosBatch.help"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("tutti.createBenthosBatch.action.cancel"));
        cancelButton.setToolTipText(_("tutti.createBenthosBatch.action.cancel.tip"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
        cancelButton.putClientProperty("help", "tutti.createBenthosBatch.action.cancel.help");
    }

    protected void createCategoryComboBox() {
        $objectMap.put("categoryComboBox", categoryComboBox = new BeanFilterableComboBox<SampleCategoryModelEntry>(this));
        
        categoryComboBox.setName("categoryComboBox");
        categoryComboBox.setShowDecorator(false);
        categoryComboBox.setSortable(false);
        categoryComboBox.setProperty("selectedCategory");
        categoryComboBox.setShowReset(false);
    }

    protected void createCategoryConfigurationPanel() {
        $objectMap.put("categoryConfigurationPanel", categoryConfigurationPanel = new Table());
        
        categoryConfigurationPanel.setName("categoryConfigurationPanel");
    }

    protected void createCategoryLabel() {
        $objectMap.put("categoryLabel", categoryLabel = new JLabel());
        
        categoryLabel.setName("categoryLabel");
        categoryLabel.setText(_("tutti.createBenthosBatch.field.category"));
        categoryLabel.setToolTipText(_("tutti.createBenthosBatch.field.category.tip"));
        categoryLabel.putClientProperty("help", "tutti.createBenthosBatch.field.categoryField.help");
    }

    protected void createCategoryPanel() {
        $objectMap.put("categoryPanel", categoryPanel = new JPanel());
        
        categoryPanel.setName("categoryPanel");
        categoryPanel.setLayout(new BorderLayout());
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new Table());
        
        configurationPanel.setName("configurationPanel");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(CreateBenthosBatchUIHandler.class));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(CreateBenthosBatchUIModel.class));
    }

    protected void createSampleCategoryComboBox() {
        $objectMap.put("sampleCategoryComboBox", sampleCategoryComboBox = new BeanFilterableComboBox<CaracteristicQualitativeValue>(this));
        
        sampleCategoryComboBox.setName("sampleCategoryComboBox");
        sampleCategoryComboBox.setProperty("sampleCategory");
        sampleCategoryComboBox.setShowReset(true);
    }

    protected void createSampleCategoryLabel() {
        $objectMap.put("sampleCategoryLabel", sampleCategoryLabel = new JLabel());
        
        sampleCategoryLabel.setName("sampleCategoryLabel");
        sampleCategoryLabel.setText(_("tutti.createBenthosBatch.field.sampleCategory"));
        sampleCategoryLabel.setToolTipText(_("tutti.createBenthosBatch.field.sampleCategory.tip"));
        sampleCategoryLabel.putClientProperty("help", "tutti.createBenthosBatch.field.sampleCategory.help");
    }

    protected void createSampleWeightField() {
        $objectMap.put("sampleWeightField", sampleWeightField = new JTextField());
        
        sampleWeightField.setName("sampleWeightField");
        sampleWeightField.setColumns(15);
        sampleWeightField.setEnabled(false);
        sampleWeightField.setEditable(false);
    }

    protected void createSampleWeightLabel() {
        $objectMap.put("sampleWeightLabel", sampleWeightLabel = new JLabel());
        
        sampleWeightLabel.setName("sampleWeightLabel");
        sampleWeightLabel.setText(_("tutti.createBenthosBatch.field.sampleWeight"));
        sampleWeightLabel.setToolTipText(_("tutti.createBenthosBatch.field.sampleWeight.tip"));
        sampleWeightLabel.putClientProperty("help", "tutti.createBenthosBatch.field.sampleWeightField.help");
        sampleWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getBenthosWeightUnit());
    }

    protected void createSaveAndCloseButton() {
        $objectMap.put("saveAndCloseButton", saveAndCloseButton = new JButton());
        
        saveAndCloseButton.setName("saveAndCloseButton");
        saveAndCloseButton.setText(_("tutti.createBenthosBatch.action.saveAndClose"));
        saveAndCloseButton.setToolTipText(_("tutti.createBenthosBatch.action.saveAndClose.tip"));
        saveAndCloseButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveAndCloseButton"));
        saveAndCloseButton.putClientProperty("help", "tutti.createBenthosBatch.action.saveAndClose.help");
    }

    protected void createSaveAndContinueButton() {
        $objectMap.put("saveAndContinueButton", saveAndContinueButton = new JButton());
        
        saveAndContinueButton.setName("saveAndContinueButton");
        saveAndContinueButton.setText(_("tutti.createBenthosBatch.action.saveAndContinue"));
        saveAndContinueButton.setToolTipText(_("tutti.createBenthosBatch.action.saveAndContinue.tip"));
        saveAndContinueButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveAndContinueButton"));
        saveAndContinueButton.putClientProperty("help", "tutti.createBenthosBatch.action.saveAndContinue.help");
    }

    protected void createSpeciesComboBox() {
        $objectMap.put("speciesComboBox", speciesComboBox = new BeanFilterableComboBox<Species>(this));
        
        speciesComboBox.setName("speciesComboBox");
        speciesComboBox.setProperty("species");
        speciesComboBox.setShowReset(true);
    }

    protected void createSpeciesLabel() {
        $objectMap.put("speciesLabel", speciesLabel = new JLabel());
        
        speciesLabel.setName("speciesLabel");
        speciesLabel.setText(_("tutti.createBenthosBatch.field.species"));
        speciesLabel.setToolTipText(_("tutti.createBenthosBatch.field.species.tip"));
        speciesLabel.putClientProperty("help", "tutti.createBenthosBatch.field.species.help");
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(CreateBenthosBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToCreateBenthosBatchTopPanel();
        addChildrenToValidator();
        addChildrenToConfigurationPanel();
        addChildrenToCategoryPanel();
        addChildrenToCategoryConfigurationPanel();
        addChildrenToTableScrollPane();
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(saveAndContinueButton);
        $JPanel0.add(saveAndCloseButton);
        
        // apply 14 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 31 property setters
        speciesComboBox.setBeanType(Species.class);
        sampleCategoryComboBox.setBeanType(CaracteristicQualitativeValue.class);
        categoryComboBox.setBeanType(SampleCategoryModelEntry.class);
        speciesLabel.setLabelFor(speciesComboBox);
        speciesComboBox.setBean(model);
        addSpeciesButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.createBenthosBatch.action.addSpecies.mnemonic"),'Z'));
        batchWeightLabel.setLabelFor(batchWeightField);
        batchWeightField.setBean(model);
        batchWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        batchWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        batchCountLabel.setLabelFor(batchCountField);
        batchCountField.setBean(model);
        batchCountField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        batchCountField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        sampleCategoryLabel.setLabelFor(sampleCategoryComboBox);
        sampleCategoryComboBox.setBean(model);
        categoryLabel.setLabelFor(categoryComboBox);
        categoryComboBox.setBean(model);
        sampleWeightLabel.setLabelFor(sampleWeightField);
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        table.setSelectionForeground(Color.BLACK);
        table.setSelectionBackground(null);
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.createBenthosBatch.action.cancel.mnemonic"),'Z'));
        saveAndContinueButton.setIcon(SwingUtil.createActionIcon("save"));
        saveAndContinueButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.createBenthosBatch.action.saveAndContinue.mnemonic"),'Z'));
        saveAndCloseButton.setIcon(SwingUtil.createActionIcon("save"));
        saveAndCloseButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.createBenthosBatch.action.saveAndClose.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, createBenthosBatchTopPanel, "tutti.createBenthosBatch.help");
        registerHelpId(_broker, speciesLabel, "tutti.createBenthosBatch.field.species.help");
        registerHelpId(_broker, addSpeciesButton, "tutti.createBenthosBatch.action.addSpecies.help");
        registerHelpId(_broker, batchWeightLabel, "tutti.createBenthosBatch.field.batchWeight.help");
        registerHelpId(_broker, batchCountLabel, "tutti.createBenthosBatch.field.batchCount.help");
        registerHelpId(_broker, sampleCategoryLabel, "tutti.createBenthosBatch.field.sampleCategory.help");
        registerHelpId(_broker, categoryLabel, "tutti.createBenthosBatch.field.categoryField.help");
        registerHelpId(_broker, sampleWeightLabel, "tutti.createBenthosBatch.field.sampleWeightField.help");
        registerHelpId(_broker, cancelButton, "tutti.createBenthosBatch.action.cancel.help");
        registerHelpId(_broker, saveAndContinueButton, "tutti.createBenthosBatch.action.saveAndContinue.help");
        registerHelpId(_broker, saveAndCloseButton, "tutti.createBenthosBatch.action.saveAndClose.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("createBenthosBatchTopPanel", createBenthosBatchTopPanel);
        createHandler();
        createModel();
        createValidator();
        createBroker();
        createConfigurationPanel();
        createSpeciesLabel();
        createSpeciesComboBox();
        createAddSpeciesButton();
        createBatchWeightLabel();
        createBatchWeightField();
        createBatchCountLabel();
        createBatchCountField();
        createSampleCategoryLabel();
        createSampleCategoryComboBox();
        createCategoryPanel();
        createCategoryConfigurationPanel();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createCategoryLabel();
        createCategoryComboBox();
        createSampleWeightLabel();
        createSampleWeightField();
        createTableScrollPane();
        createTable();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createCancelButton();
        createSaveAndContinueButton();
        createSaveAndCloseButton();
        // inline creation of createBenthosBatchTopPanel
        setName("createBenthosBatchTopPanel");
        setLayout(new BorderLayout());
        createBenthosBatchTopPanel.putClientProperty("help", "tutti.createBenthosBatch.help");
        
        // registers 14 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 14 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("species", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesComboBox.setSelectedItem(model.getSpecies());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("species", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_COMBO_BOX_DATA, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("availableSpecies", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesComboBox.setData(model.getAvailableSpecies());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("availableSpecies", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BATCH_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("batchWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    batchWeightField.setModel(model.getBatchWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("batchWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BATCH_COUNT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("batchCount", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    batchCountField.setModel(model.getBatchCount());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("batchCount", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BATCH_COUNT_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                batchCountField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAMPLE_CATEGORY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("sampleCategory", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    sampleCategoryComboBox.setSelectedItem(model.getSampleCategory());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("sampleCategory", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATEGORY_PANEL_VISIBLE, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("species", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("batchCount", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    categoryPanel.setVisible(model.getSpecies() != null && model.getBatchCount() == null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("species", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("batchCount", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATEGORY_COMBO_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("batchCount", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    categoryComboBox.setEnabled(model.getBatchCount() == null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("batchCount", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATEGORY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedCategory", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    categoryComboBox.setSelectedItem(model.getSelectedCategory());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedCategory", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATEGORY_COMBO_BOX_DATA, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("category", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    categoryComboBox.setData(model.getCategory());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("category", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAMPLE_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("sampleWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(sampleWeightField, getStringValue(model.getSampleWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("sampleWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TABLE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedCategory", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("batchCount", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    table.setEnabled(model.getSelectedCategory() != null && model.getBatchCount() == null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedCategory", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("batchCount", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_AND_CONTINUE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveAndContinueButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_AND_CLOSE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveAndCloseButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}