/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.catches.multipost;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.TuttiCsvUtil;
import fr.ifremer.tutti.service.catches.multipost.AccidentalCatchRow;
import java.util.List;
import java.util.Map;
import org.nuiton.csv.ValueFormatter;

public class AccidentalCatchRowModel
extends TuttiCsvUtil.AbstractTuttiImportExportModel<AccidentalCatchRow> {
    public AccidentalCatchRowModel(char separator) {
        this(separator, null, null, null, null);
    }

    public AccidentalCatchRowModel(char separator, List<Species> species, List<CaracteristicQualitativeValue> genderValues, List<Caracteristic> lengthStepCaracteristics, List<CaracteristicQualitativeValue> deadOrAliveValues) {
        super(separator);
        ValueFormatter<CaracteristicQualitativeValue> cqvFormatter = new ValueFormatter<CaracteristicQualitativeValue>(){

            public String format(CaracteristicQualitativeValue value) {
                String result = "";
                if (value != null) {
                    result = value.getId();
                }
                return result;
            }
        };
        this.newColumnForImportExport("batchId");
        this.newColumnForExport("species", (ValueFormatter)new ValueFormatter<Species>(){

            public String format(Species value) {
                return value != null ? String.valueOf(value.getReferenceTaxonId()) : null;
            }
        });
        if (species == null) {
            species = Lists.newArrayList();
        }
        Map speciesMap = TuttiEntities.splitByTaxonId((Iterable)species);
        this.newForeignKeyColumn("species", Species.class, "referenceTaxonId", speciesMap);
        this.newColumnForExport("gender", (ValueFormatter)cqvFormatter);
        if (genderValues == null) {
            genderValues = Lists.newArrayList();
        }
        ImmutableMap genderValuesMap = Maps.uniqueIndex((Iterable)genderValues, (Function)TuttiEntities.GET_ID);
        this.newForeignKeyColumn("gender", CaracteristicQualitativeValue.class, "id", genderValuesMap);
        this.newColumnForImportExport("weight", TuttiCsvUtil.FLOAT);
        this.newColumnForImportExport("size", TuttiCsvUtil.FLOAT);
        this.newColumnForExport("lengthStepCaracteristic", (ValueFormatter)new ValueFormatter<Caracteristic>(){

            public String format(Caracteristic value) {
                return value != null ? value.getId() : "";
            }
        });
        if (lengthStepCaracteristics == null) {
            lengthStepCaracteristics = Lists.newArrayList();
        }
        ImmutableMap caracteristicMap = Maps.uniqueIndex((Iterable)lengthStepCaracteristics, (Function)TuttiEntities.GET_ID);
        this.newForeignKeyColumn("lengthStepCaracteristic", Caracteristic.class, "id", caracteristicMap);
        this.newColumnForExport("deadOrAlive", (ValueFormatter)cqvFormatter);
        if (deadOrAliveValues == null) {
            deadOrAliveValues = Lists.newArrayList();
        }
        ImmutableMap deadOraliveValuesMap = Maps.uniqueIndex((Iterable)deadOrAliveValues, (Function)TuttiEntities.GET_ID);
        this.newForeignKeyColumn("deadOrAlive", CaracteristicQualitativeValue.class, "id", deadOraliveValuesMap);
        this.newColumnForImportExport("comment");
    }

    public AccidentalCatchRow newEmptyInstance() {
        return new AccidentalCatchRow();
    }
}

