/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import org.hibernate.AssertionFailure;
import org.hibernate.LockMode;
import org.hibernate.action.EntityIncrementVersionProcess;
import org.hibernate.action.EntityVerifyVersionProcess;
import org.hibernate.classic.Lifecycle;
import org.hibernate.engine.EntityEntry;
import org.hibernate.event.PostLoadEvent;
import org.hibernate.event.PostLoadEventListener;
import org.hibernate.persister.entity.EntityPersister;

public class DefaultPostLoadEventListener
implements PostLoadEventListener {
    public void onPostLoad(PostLoadEvent event) {
        Object entity = event.getEntity();
        EntityEntry entry = event.getSession().getPersistenceContext().getEntry(entity);
        if (entry == null) {
            throw new AssertionFailure("possible non-threadsafe access to the session");
        }
        LockMode lockMode = entry.getLockMode();
        if (LockMode.PESSIMISTIC_FORCE_INCREMENT.equals(lockMode)) {
            EntityPersister persister = entry.getPersister();
            Object nextVersion = persister.forceVersionIncrement(entry.getId(), entry.getVersion(), event.getSession());
            entry.forceLocked(entity, nextVersion);
        } else if (LockMode.OPTIMISTIC_FORCE_INCREMENT.equals(lockMode)) {
            EntityIncrementVersionProcess incrementVersion = new EntityIncrementVersionProcess(entity, entry);
            event.getSession().getActionQueue().registerProcess(incrementVersion);
        } else if (LockMode.OPTIMISTIC.equals(lockMode)) {
            EntityVerifyVersionProcess verifyVersion = new EntityVerifyVersionProcess(entity, entry);
            event.getSession().getActionQueue().registerProcess(verifyVersion);
        }
        if (event.getPersister().implementsLifecycle(event.getSession().getEntityMode())) {
            ((Lifecycle)event.getEntity()).onLoad(event.getSession(), event.getId());
        }
    }
}

