package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos;

/*
 * #%L
 * Tutti :: UI
 * $Id: BenthosBatchUIModel.java 1066 2013-05-31 16:20:21Z kmorin $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.5/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/benthos/BenthosBatchUIModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Multimap;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.operation.AbstractTuttiBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.TableViewMode;
import fr.ifremer.tutti.ui.swing.util.TabContentModel;
import fr.ifremer.tutti.ui.swing.util.TuttiComputedOrNotData;
import org.apache.commons.collections.CollectionUtils;

import static org.nuiton.i18n.I18n.n_;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class BenthosBatchUIModel extends AbstractTuttiBatchUIModel<BenthosBatchRowModel, BenthosBatchUIModel>
        implements TabContentModel {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_TABLE_VIEW_MODE = "tableViewMode";

    public static final String PROPERTY_CREATE_BATCH_ENABLED = "createBatchEnabled";

    public static final String PROPERTY_SPLIT_BATCH_ENABLED = "splitBatchEnabled";

    public static final String PROPERTY_REMOVE_SUB_BATCH_ENABLED = "removeSubBatchEnabled";

    public static final String PROPERTY_RENAME_BATCH_ENABLED = "renameBatchEnabled";

    public static final String PROPERTY_REMOVE_BATCH_ENABLED = "removeBatchEnabled";

    public static final String PROPERTY_CREATE_MELAG_ENABLED = "createMelagEnabled";

    public static final String PROPERTY_EDIT_FREQUENCIES_ENABLED = "editFrequenciesEnabled";

    public static final String PROPERTY_TABLE_VIEW_MODE_ALL = "tableViewModeAll";

    public static final String PROPERTY_TABLE_VIEW_MODE_LEAF = "tableViewModeLeaf";

    public static final String PROPERTY_TABLE_VIEW_MODE_ROOT = "tableViewModeRoot";

    public static final String PROPERTY_ROOT_NUMBER = "rootNumber";

    public static final String PROPERTY_LEAF_NUMBER = "leafNumber";

    /**
     * Can user create a new species batch ?
     *
     * @since 0.3
     */
    protected boolean createBatchEnabled;

    /**
     * Can user split a selected species batch ?
     *
     * @since 0.3
     */
    protected boolean splitBatchEnabled;

    /**
     * Can user remove a selected species batch?
     *
     * @since 0.3
     */
    protected boolean removeBatchEnabled;

    /**
     * Can user remove a selected species sub batches?
     *
     * @since 0.3
     */
    protected boolean removeSubBatchEnabled;

    /**
     * Can user create a melag from the selected species?
     *
     * @since 0.3
     */
    protected boolean createMelagEnabled = true;

    /**
     * Can user rename the selected species?
     *
     * @since 0.3
     */
    protected boolean renameBatchEnabled;

    /**
     * Can user edit frequencies for the selected species?
     *
     * @since 2.3
     */
    private boolean editFrequenciesEnabled;

    /**
     * What to show in the table.
     *
     * @since 0.3
     */
    protected TableViewMode tableViewMode;

    /** @since 1.0 */
    protected int rootNumber;

    /** @since 1.0 */
    protected int leafNumber;

    public BenthosBatchUIModel(EditCatchesUIModel catchesUIModel) {
        super(catchesUIModel,
              EditCatchesUIModel.PROPERTY_BENTHOS_TOTAL_COMPUTED_WEIGHT,
              EditCatchesUIModel.PROPERTY_BENTHOS_TOTAL_SORTED_WEIGHT,
              EditCatchesUIModel.PROPERTY_BENTHOS_TOTAL_UNSORTED_COMPUTED_WEIGHT,
              EditCatchesUIModel.PROPERTY_BENTHOS_TOTAL_SAMPLE_SORTED_COMPUTED_WEIGHT,
              EditCatchesUIModel.PROPERTY_BENTHOS_TOTAL_INERT_WEIGHT,
              EditCatchesUIModel.PROPERTY_BENTHOS_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT,
              EditCatchesUIModel.PROPERTY_BATCH_UPDATED);
    }

    @Override
    public boolean isEmpty() {
        return CollectionUtils.isEmpty(getRows())
               && getBenthosTotalSortedWeight() == null
               && getBenthosTotalInertWeight() == null
               && getBenthosTotalLivingNotItemizedWeight() == null;
    }

    @Override
    public String getTitle() {
        return n_("tutti.label.tab.benthos");
    }

    @Override
    public String getIcon() {
        return null;
    }

    public Float getBenthosTotalComputedWeight() {
        return catchesUIModel.getBenthosTotalComputedWeight();
    }

    public void setBenthosTotalComputedWeight(Float speciesTotalComputedWeight) {
        catchesUIModel.setBenthosTotalComputedWeight(speciesTotalComputedWeight);
    }

    public TuttiComputedOrNotData<Float> getBenthosTotalSortedComputedOrNotWeight() {
        return catchesUIModel.getBenthosTotalSortedComputedOrNotWeight();
    }

    public Float getBenthosTotalSortedWeight() {
        return catchesUIModel.getBenthosTotalSortedWeight();
    }

    public void setBenthosTotalSortedWeight(Float speciesTotalSortedWeight) {
        catchesUIModel.setBenthosTotalSortedWeight(speciesTotalSortedWeight);
    }

    public Float getBenthosTotalSortedComputedWeight() {
        return catchesUIModel.getBenthosTotalSortedComputedWeight();
    }

    public void setBenthosTotalSortedComputedWeight(Float speciesTotalSortedComputedWeight) {
        catchesUIModel.setBenthosTotalSortedComputedWeight(speciesTotalSortedComputedWeight);
    }

    public Float getBenthosTotalUnsortedComputedWeight() {
        return catchesUIModel.getBenthosTotalUnsortedComputedWeight();
    }

    public void setBenthosTotalUnsortedComputedWeight(Float speciesTotalUnsortedComputedWeight) {
        catchesUIModel.setBenthosTotalUnsortedComputedWeight(speciesTotalUnsortedComputedWeight);
    }

    public Float getBenthosTotalSampleSortedComputedWeight() {
        return catchesUIModel.getBenthosTotalSampleSortedComputedWeight();
    }

    public void setBenthosTotalSampleSortedComputedWeight(Float speciesTotalSampleSortedComputedWeight) {
        catchesUIModel.setBenthosTotalSampleSortedComputedWeight(speciesTotalSampleSortedComputedWeight);
    }

    public TuttiComputedOrNotData<Float> getBenthosTotalInertComputedOrNotWeight() {
        return catchesUIModel.getBenthosTotalInertComputedOrNotWeight();
    }

    public Float getBenthosTotalInertWeight() {
        return catchesUIModel.getBenthosTotalInertWeight();
    }

    public void setBenthosTotalInertWeight(Float speciesTotalInertWeight) {
        catchesUIModel.setBenthosTotalInertWeight(speciesTotalInertWeight);
    }

    public Float getBenthosTotalInertComputedWeight() {
        return catchesUIModel.getBenthosTotalInertComputedWeight();
    }

    public void setBenthosTotalInertComputedWeight(Float speciesTotalInertComputedWeight) {
        catchesUIModel.setBenthosTotalInertComputedWeight(speciesTotalInertComputedWeight);
    }

    public TuttiComputedOrNotData<Float> getBenthosTotalLivingNotItemizedComputedOrNotWeight() {
        return catchesUIModel.getBenthosTotalLivingNotItemizedComputedOrNotWeight();
    }

    public Float getBenthosTotalLivingNotItemizedWeight() {
        return catchesUIModel.getBenthosTotalLivingNotItemizedWeight();
    }

    public void setBenthosTotalLivingNotItemizedWeight(Float speciesTotalLivingNotItemizedWeight) {
        catchesUIModel.setBenthosTotalLivingNotItemizedWeight(speciesTotalLivingNotItemizedWeight);
    }

    public Float getBenthosTotalLivingNotItemizedComputedWeight() {
        return catchesUIModel.getBenthosTotalLivingNotItemizedComputedWeight();
    }

    public void setBenthosTotalLivingNotItemizedComputedWeight(Float speciesTotalLivingNotItemizedComputedWeight) {
        catchesUIModel.setBenthosTotalLivingNotItemizedComputedWeight(speciesTotalLivingNotItemizedComputedWeight);
    }

    public TableViewMode getTableViewMode() {
        return tableViewMode;
    }

    public void setTableViewMode(TableViewMode tableViewMode) {
        Object oldValue = getTableViewMode();
        this.tableViewMode = tableViewMode;
        firePropertyChange(PROPERTY_TABLE_VIEW_MODE, oldValue, tableViewMode);
        firePropertyChange(PROPERTY_TABLE_VIEW_MODE_ALL, null, isTableViewModeAll());
        firePropertyChange(PROPERTY_TABLE_VIEW_MODE_LEAF, null, isTableViewModeLeaf());
        firePropertyChange(PROPERTY_TABLE_VIEW_MODE_ROOT, null, isTableViewModeRoot());
    }

    public boolean isTableViewModeAll() {
        return TableViewMode.ALL.equals(tableViewMode);
    }

    public boolean isTableViewModeLeaf() {
        return TableViewMode.LEAF.equals(tableViewMode);
    }

    public boolean isTableViewModeRoot() {
        return TableViewMode.ROOT.equals(tableViewMode);
    }

    public Multimap<CaracteristicQualitativeValue, Species> getSpeciesUsed() {
        return catchesUIModel.getSpeciesUsed();
    }

    public int getRootNumber() {
        return rootNumber;
    }

    public void setRootNumber(int rootNumber) {
        Object oldValue = getRootNumber();
        this.rootNumber = rootNumber;
        firePropertyChange(PROPERTY_ROOT_NUMBER, oldValue, rootNumber);
    }

    public int getLeafNumber() {
        return leafNumber;
    }

    public void setLeafNumber(int leafNumber) {
        Object oldValue = getLeafNumber();
        this.leafNumber = leafNumber;
        firePropertyChange(PROPERTY_LEAF_NUMBER, oldValue, leafNumber);
    }

    public boolean isCreateBatchEnabled() {
        return createBatchEnabled;
    }

    public void setCreateBatchEnabled(boolean createBatchEnabled) {
        this.createBatchEnabled = createBatchEnabled;
        firePropertyChange(PROPERTY_CREATE_BATCH_ENABLED, null, createBatchEnabled);
    }

    public boolean isSplitBatchEnabled() {
        return splitBatchEnabled;
    }

    public void setSplitBatchEnabled(boolean splitBatchEnabled) {
        this.splitBatchEnabled = splitBatchEnabled;
        firePropertyChange(PROPERTY_SPLIT_BATCH_ENABLED, null, splitBatchEnabled);
    }

    public boolean isRemoveBatchEnabled() {
        return removeBatchEnabled;
    }

    public void setRemoveBatchEnabled(boolean removeBatchEnabled) {
        this.removeBatchEnabled = removeBatchEnabled;
        firePropertyChange(PROPERTY_REMOVE_BATCH_ENABLED, null, removeBatchEnabled);
    }

    public boolean isRemoveSubBatchEnabled() {
        return removeSubBatchEnabled;
    }

    public void setRemoveSubBatchEnabled(boolean removeSubBatchEnabled) {
        this.removeSubBatchEnabled = removeSubBatchEnabled;
        firePropertyChange(PROPERTY_REMOVE_SUB_BATCH_ENABLED, null, removeSubBatchEnabled);
    }

    public boolean isRenameBatchEnabled() {
        return renameBatchEnabled;
    }

    public void setRenameBatchEnabled(boolean renameBatchEnabled) {
        this.renameBatchEnabled = renameBatchEnabled;
        firePropertyChange(PROPERTY_RENAME_BATCH_ENABLED, null, renameBatchEnabled);
    }

    public boolean isCreateMelagEnabled() {
        return createMelagEnabled;
    }

    public void setCreateMelagEnabled(boolean createMelagEnabled) {
        this.createMelagEnabled = createMelagEnabled;
        firePropertyChange(PROPERTY_CREATE_MELAG_ENABLED, null, createMelagEnabled);
    }

    public boolean isEditFrequenciesEnabled() {
        return editFrequenciesEnabled;
    }

    public void setEditFrequenciesEnabled(boolean editFrequenciesEnabled) {
        this.editFrequenciesEnabled = editFrequenciesEnabled;
        firePropertyChange(PROPERTY_EDIT_FREQUENCIES_ENABLED, null, editFrequenciesEnabled);
    }
}
