/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import fr.ifremer.adagio.core.dao.administration.user.Person;
import fr.ifremer.adagio.core.dao.administration.user.PersonExtendDao;
import fr.ifremer.adagio.core.dao.data.vessel.VesselExtendDao;
import fr.ifremer.adagio.core.dao.referential.Status;
import fr.ifremer.adagio.core.dao.referential.StatusDao;
import fr.ifremer.adagio.core.dao.referential.gear.FishingGear;
import fr.ifremer.adagio.core.dao.referential.gear.FishingGearExtendDao;
import fr.ifremer.adagio.core.dao.referential.gear.GearClassification;
import fr.ifremer.adagio.core.dao.referential.location.LocationExtendDao;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonNameExtendDao;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonRefVO;
import fr.ifremer.adagio.core.service.technical.CacheService;
import fr.ifremer.tutti.persistence.entities.TuttiBeanFactory;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicType;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.ObjectType;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.StatusBean;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.persistence.entities.referential.TuttiReferentialEntity;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.ReferentialPersistenceService;
import fr.ifremer.tutti.persistence.service.TuttiEnumerationFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.hibernate.type.DateType;
import org.hibernate.type.IntegerType;
import org.hibernate.type.StringType;
import org.springframework.cache.Cache;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.stereotype.Service;

@Service(value="referentialPersistenceService")
public class ReferentialPersistenceServiceImpl
extends AbstractPersistenceService
implements ReferentialPersistenceService {
    private static final Log log = LogFactory.getLog(ReferentialPersistenceServiceImpl.class);
    @Resource(name="taxonNameDao")
    protected TaxonNameExtendDao taxonNameDao;
    @Resource(name="statusDao")
    protected StatusDao statusDao;
    @Resource(name="personDao")
    protected PersonExtendDao personDao;
    @Resource(name="fishingGearDao")
    protected FishingGearExtendDao fishingGearDao;
    @Resource(name="vesselExtendDao")
    protected VesselExtendDao vesselExtendDao;
    @Resource(name="locationDao")
    protected LocationExtendDao locationDao;
    @Resource(name="cacheService")
    protected CacheService cacheService;
    @Resource(name="referentialPersistenceService")
    protected ReferentialPersistenceService thisService;

    @Override
    public List<TuttiLocation> getAllProgramZone() {
        Iterator<Object[]> list = this.queryListWithStatus("allLocationsByLevelAndClassificiation", "locationClassificationId", IntegerType.INSTANCE, this.enumeration.LOCATION_CLASSIFICATION_ID_SECTOR, "locationLevelId", IntegerType.INSTANCE, this.enumeration.LOCATION_LEVEL_ID_PROGRAM);
        ArrayList result = Lists.newArrayList();
        while (list.hasNext()) {
            Object[] source = list.next();
            TuttiLocation target = this.loadLocation(source);
            result.add(target);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<TuttiLocation> getAllCountry() {
        Iterator<Object[]> list = this.queryListWithStatus("allLocationsByLevelAndClassificiation", "locationClassificationId", IntegerType.INSTANCE, this.enumeration.LOCATION_CLASSIFICATION_ID_TERRITORIAL, "locationLevelId", IntegerType.INSTANCE, this.enumeration.LOCATION_LEVEL_ID_COUNTRY);
        ArrayList result = Lists.newArrayList();
        while (list.hasNext()) {
            Object[] source = list.next();
            TuttiLocation target = this.loadLocation(source);
            result.add(target);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<TuttiLocation> getAllHarbour() {
        Iterator<Object[]> list = this.queryListWithStatus("allLocationsByLevelAndClassificiation", "locationClassificationId", IntegerType.INSTANCE, this.enumeration.LOCATION_CLASSIFICATION_ID_TERRITORIAL, "locationLevelId", IntegerType.INSTANCE, this.enumeration.LOCATION_LEVEL_ID_HARBOUR);
        ArrayList result = Lists.newArrayList();
        while (list.hasNext()) {
            Object[] source = list.next();
            TuttiLocation target = this.loadLocation(source);
            result.add(target);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<TuttiLocation> getAllFishingOperationStrata(String zoneId) {
        Preconditions.checkNotNull((Object)zoneId);
        List<TuttiLocation> result = this.getFishingOperationLocationsByParent(this.enumeration.LOCATION_LEVEL_ID_STRATA, Integer.valueOf(zoneId), this.enumeration.LOCATION_LEVEL_ID_PROGRAM);
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<TuttiLocation> getAllFishingOperationSubStrata(String zoneId, String strataId) {
        Integer parentLocationLevelId;
        String parentId;
        if (strataId != null) {
            parentId = strataId;
            parentLocationLevelId = this.enumeration.LOCATION_LEVEL_ID_STRATA;
        } else {
            parentId = zoneId;
            parentLocationLevelId = this.enumeration.LOCATION_LEVEL_ID_PROGRAM;
        }
        Preconditions.checkNotNull((Object)parentId);
        List<TuttiLocation> result = this.getFishingOperationLocationsByParent(this.enumeration.LOCATION_LEVEL_ID_SUB_STRATA, Integer.valueOf(parentId), parentLocationLevelId);
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<TuttiLocation> getAllFishingOperationLocation(String zoneId, String strataId, String subStrataId) {
        Integer parentLocationLevelId;
        String parentId;
        if (subStrataId != null) {
            parentId = subStrataId;
            parentLocationLevelId = this.enumeration.LOCATION_LEVEL_ID_SUB_STRATA;
        } else if (strataId != null) {
            parentId = strataId;
            parentLocationLevelId = this.enumeration.LOCATION_LEVEL_ID_STRATA;
        } else {
            parentId = zoneId;
            parentLocationLevelId = this.enumeration.LOCATION_LEVEL_ID_PROGRAM;
        }
        Preconditions.checkNotNull((Object)parentId);
        List<TuttiLocation> result = this.getFishingOperationLocationsByParent(this.enumeration.LOCATION_LEVEL_ID_LOCALITE, Integer.valueOf(parentId), parentLocationLevelId);
        return Collections.unmodifiableList(result);
    }

    @Override
    public TuttiLocation getLocation(String id) {
        Object[] source = this.queryUnique("locationById", "locationId", IntegerType.INSTANCE, Integer.valueOf(id));
        if (source == null) {
            return null;
        }
        TuttiLocation target = this.loadLocation(source);
        return target;
    }

    @Override
    public List<Vessel> getAllScientificVessel() {
        Iterator<Object[]> list = this.queryListWithStatus("allVessels", "refDate", DateType.INSTANCE, new Date(), "vesselTypeId", IntegerType.INSTANCE, this.enumeration.VESSEL_TYPE_ID_SCIENTIFIC);
        ArrayList result = Lists.newArrayList();
        Cache vesselByCodeCache = this.cacheService.getCache("vesselByCode");
        while (list.hasNext()) {
            Object[] source = list.next();
            Vessel target = this.loadVessel(source, true);
            result.add(target);
            vesselByCodeCache.put((Object)target.getId(), (Object)target);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<Vessel> getAllFishingVessel() {
        Iterator<Object[]> list = this.queryListWithStatus("allVessels", "refDate", DateType.INSTANCE, new Date(), "vesselTypeId", IntegerType.INSTANCE, this.enumeration.VESSEL_TYPE_ID_FISHING);
        ArrayList result = Lists.newArrayList();
        Cache vesselByCodeCache = this.cacheService.getCache("vesselByCode");
        while (list.hasNext()) {
            Object[] source = list.next();
            Vessel target = this.loadVessel(source, true);
            target.setScientificVessel(false);
            result.add(target);
            vesselByCodeCache.put((Object)target.getId(), (Object)target);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Vessel getVessel(String vesselCode) {
        Iterator<Object[]> source;
        if (log.isDebugEnabled()) {
            log.debug((Object)("get vessel: " + vesselCode));
        }
        Vessel result = (source = this.queryListWithStatus("vessel", "vesselCode", StringType.INSTANCE, vesselCode, "refDate", DateType.INSTANCE, new Date())).hasNext() ? this.loadVessel(source.next(), false) : null;
        return result;
    }

    @Override
    public List<Gear> getAllScientificGear() {
        Iterator<Object[]> sources = this.queryListWithStatus("allGears", "gearClassificiationId", IntegerType.INSTANCE, this.enumeration.GEAR_CLASSIFICIATION_ID_SCIENTIFIC);
        ArrayList result = Lists.newArrayList();
        while (sources.hasNext()) {
            Object[] source = sources.next();
            Gear target = this.loadGear(source);
            result.add(target);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<Gear> getAllFishingGear() {
        Iterator<Object[]> sources = this.queryListWithStatus("allGears", "gearClassificiationId", IntegerType.INSTANCE, this.enumeration.GEAR_CLASSIFICIATION_ID_FISHING);
        ArrayList result = Lists.newArrayList();
        while (sources.hasNext()) {
            Object[] source = sources.next();
            Gear target = this.loadGear(source);
            result.add(target);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<fr.ifremer.tutti.persistence.entities.referential.Person> getAllPerson() {
        Iterator<Object[]> list = this.queryListWithStatus("allPersons", "observerProfilId", IntegerType.INSTANCE, this.enumeration.USER_PROFIL_ID_OBSERVER, "projectMemberProfilId", IntegerType.INSTANCE, this.enumeration.USER_PROFIL_ID_PROJECT_MEMBER, "userProfilId", IntegerType.INSTANCE, this.enumeration.USER_PROFIL_ID_USER);
        ArrayList result = Lists.newArrayList();
        while (list.hasNext()) {
            Object[] source = list.next();
            fr.ifremer.tutti.persistence.entities.referential.Person target = this.loadPerson(source);
            result.add(target);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public fr.ifremer.tutti.persistence.entities.referential.Person getPerson(Integer personId) {
        Object[] source = this.queryUnique("person", "personId", IntegerType.INSTANCE, personId);
        fr.ifremer.tutti.persistence.entities.referential.Person result = source == null ? null : this.loadPerson(source);
        return result;
    }

    @Override
    public Gear getGear(Integer gearId) {
        Object[] source = this.queryUnique("gear", "gearId", IntegerType.INSTANCE, gearId);
        Gear result = source == null ? null : this.loadGear(source);
        return result;
    }

    @Override
    public List<Species> getAllSpecies() {
        TaxonRefVO[] sources = this.taxonNameDao.getAllTaxonNames(true, this.enumeration.TRANSCRIBING_TYPE_ID_REFTAX);
        ArrayList result = Lists.newArrayListWithCapacity((int)sources.length);
        ArrayList referenceTaxonsOnly = Lists.newArrayList();
        Cache referentSpeciesByIdCache = this.cacheService.getCache("referentSpeciesById");
        for (TaxonRefVO source : sources) {
            Species target = this.loadSpecies(source);
            target.setRefTaxCode(StringUtils.trim((String)target.getExternalCode()));
            if (target.isReferenceTaxon()) {
                referentSpeciesByIdCache.put((Object)target.getReferenceTaxonId(), (Object)target);
                referenceTaxonsOnly.add(target);
            }
            result.add(target);
        }
        Cache allReferentSpeciesCache = this.cacheService.getCache("referentSpecies");
        allReferentSpeciesCache.put((Object)"", (Object)referenceTaxonsOnly);
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<Species> getAllReferentSpecies() {
        TaxonRefVO[] sources = this.taxonNameDao.getAllTaxonNames(false, this.enumeration.TRANSCRIBING_TYPE_ID_REFTAX);
        ArrayList result = Lists.newArrayListWithCapacity((int)sources.length);
        Cache referentSpeciesByIdCache = this.cacheService.getCache("referentSpeciesById");
        for (TaxonRefVO source : sources) {
            Species target = this.loadSpecies(source);
            target.setRefTaxCode(StringUtils.trim((String)target.getExternalCode()));
            referentSpeciesByIdCache.put((Object)target.getReferenceTaxonId(), (Object)target);
            result.add(target);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Species getSpeciesByReferenceTaxonId(Integer speciesId) {
        Species result = this.getSpeciesByReferenceTaxonId(speciesId, this.enumeration.TRANSCRIBING_TYPE_ID_REFTAX);
        if (result != null) {
            result.setRefTaxCode(result.getExternalCode());
        }
        return result;
    }

    @Override
    public Species getSpeciesByReferenceTaxonIdWithVernacularCode(Integer speciesId) {
        Species result = this.getSpeciesByReferenceTaxonId(speciesId, this.enumeration.TRANSCRIBING_TYPE_ID_VERNACULAIRE);
        if (result != null) {
            result.setVernacularCode(result.getExternalCode());
        }
        return result;
    }

    protected Species getSpeciesByReferenceTaxonId(Integer speciesId, Integer transcribingTypeId) {
        Species target;
        try {
            TaxonRefVO source = this.taxonNameDao.getTaxonNameReferent(speciesId, transcribingTypeId);
            target = this.loadSpecies(source);
        }
        catch (DataRetrievalFailureException drfe) {
            target = null;
        }
        return target;
    }

    @Override
    public List<Caracteristic> getAllCaracteristic() {
        return this.getAllCaracteristics(false);
    }

    @Override
    public List<Caracteristic> getAllCaracteristicWithProtected() {
        return this.getAllCaracteristics(true);
    }

    @Override
    public List<Caracteristic> getAllCaracteristicForSampleCategory() {
        List<Caracteristic> allCaracteristicWithProtected = this.thisService.getAllCaracteristicWithProtected();
        ArrayList result = Lists.newArrayList((Iterable)Iterables.filter(allCaracteristicWithProtected, TuttiEntities.newSampleCategoryModelPredicate()));
        return result;
    }

    protected List<Caracteristic> getAllCaracteristics(boolean withProtected) {
        Iterator<Object[]> sources = this.queryListWithStatus("allPmfm", "unitIdNone", IntegerType.INSTANCE, this.enumeration.UNIT_ID_NONE);
        ArrayList result = Lists.newArrayList();
        Cache pmfmByIdCache = this.cacheService.getCache("pmfmById");
        while (sources.hasNext()) {
            Object[] source = sources.next();
            Integer pmfmId = (Integer)source[0];
            Caracteristic target = this.loadCaracteristic(source);
            if (withProtected || !this.enumeration.isProtectedCaracteristic(pmfmId)) {
                result.add(target);
            }
            pmfmByIdCache.put((Object)pmfmId, (Object)target);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<ObjectType> getAllObjectType() {
        Iterator<Object[]> sources = this.queryList("allObjectType", new Object[0]);
        ArrayList result = Lists.newArrayList();
        Cache cache = this.cacheService.getCache("objectTypeByCode");
        while (sources.hasNext()) {
            Object[] source = sources.next();
            String code = (String)source[0];
            ObjectType target = this.loadObjectType(source);
            cache.put((Object)code, (Object)target);
            result.add(target);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public ObjectType getObjectType(String objectTypeCode) {
        Object[] source = this.queryUnique("objectType", "objectTypeCode", StringType.INSTANCE, objectTypeCode);
        ObjectType target = this.loadObjectType(source);
        return target;
    }

    @Override
    public List<Caracteristic> getAllNumericCaracteristic() {
        ArrayList result = Lists.newArrayList();
        for (Caracteristic caracteristic : this.getAllCaracteristic()) {
            if (!caracteristic.isNumericType()) continue;
            result.add(caracteristic);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Caracteristic getSizeCategoryCaracteristic() {
        Integer pmfmId = this.enumeration.PMFM_ID_SIZE_CATEGORY;
        Caracteristic result = this.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    public Caracteristic getSexCaracteristic() {
        Integer pmfmId = this.enumeration.PMFM_ID_SEX;
        Caracteristic result = this.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    public Caracteristic getSortedUnsortedCaracteristic() {
        Integer pmfmId = this.enumeration.PMFM_ID_SORTED_UNSORTED;
        Caracteristic result = this.thisService.getCaracteristic(pmfmId);
        ArrayList qualitativeValue = Lists.newArrayList(result.getQualitativeValue());
        Iterator iterator = qualitativeValue.iterator();
        while (iterator.hasNext()) {
            CaracteristicQualitativeValue qv = (CaracteristicQualitativeValue)iterator.next();
            if (!this.enumeration.QUALITATIVE_UNSORTED_ID.equals(Integer.valueOf(qv.getId()))) continue;
            iterator.remove();
            break;
        }
        result.setQualitativeValue(Collections.unmodifiableList(qualitativeValue));
        return result;
    }

    @Override
    public Caracteristic getMaturityCaracteristic() {
        Integer pmfmId = this.enumeration.PMFM_ID_MATURITY;
        Caracteristic result = this.thisService.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    public Caracteristic getAgeCaracteristic() {
        Integer pmfmId = this.enumeration.PMFM_ID_AGE;
        Caracteristic result = this.thisService.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    public Caracteristic getMarineLitterCategoryCaracteristic() {
        Integer pmfmId = this.enumeration.PMFM_ID_MARINE_LITTER_TYPE;
        Caracteristic result = this.thisService.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    public Caracteristic getMarineLitterSizeCategoryCaracteristic() {
        Integer pmfmId = this.enumeration.PMFM_ID_MARINE_LITTER_SIZE_CATEGORY;
        Caracteristic result = this.thisService.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    public Caracteristic getVerticalOpeningCaracteristic() {
        Integer pmfmId = this.enumeration.PMFM_ID_VERTICAL_OPENING;
        Caracteristic result = this.thisService.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    public Caracteristic getHorizontalOpeningWingCaracteristic() {
        Integer pmfmId = this.enumeration.PMFM_ID_HORIZONTAL_OPENING_WING;
        Caracteristic result = this.thisService.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    public Caracteristic getHorizontalOpeningDoorCaracteristic() {
        Integer pmfmId = this.enumeration.PMFM_ID_HORIZONTAL_OPENING_DOOR;
        Caracteristic result = this.thisService.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    public Caracteristic getDeadOrAliveCaracteristic() {
        Integer pmfmId = this.enumeration.PMFM_ID_DEAD_OR_ALIVE;
        Caracteristic result = this.thisService.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    public Caracteristic getSampleIdCaracteristic() {
        Integer pmfmId = this.enumeration.PMFM_ID_SAMPLE_ID;
        Caracteristic result = this.thisService.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    public Caracteristic getOtolitheIdCaracteristic() {
        Integer pmfmId = this.enumeration.PMFM_ID_OTOLITHE_ID;
        Caracteristic result = this.thisService.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    public Caracteristic getPmfmIdCaracteristic() {
        Integer pmfmId = this.enumeration.PMFM_ID_ID_PSFM;
        Caracteristic result = this.thisService.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    public Caracteristic getWeightMeasuredCaracteristic() {
        Integer pmfmId = this.enumeration.PMFM_ID_WEIGHT_MEASURED;
        Caracteristic result = this.thisService.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    public boolean isTemporary(TuttiReferentialEntity entity) {
        Preconditions.checkNotNull((Object)entity);
        Preconditions.checkNotNull((Object)entity.getStatus());
        return this.enumeration.STATUS_TEMPORARY_CODE.equals(entity.getStatus().getId());
    }

    @Override
    public Caracteristic getCaracteristic(Integer pmfmId) {
        Object[] source = this.queryUniqueWithStatus("pmfmById", "pmfmId", IntegerType.INSTANCE, pmfmId, "unitIdNone", IntegerType.INSTANCE, this.enumeration.UNIT_ID_NONE);
        Caracteristic target = this.loadCaracteristic(source);
        return target;
    }

    @Override
    public List<Species> importTemporarySpecies(List<Species> species) {
        ArrayList result = Lists.newArrayList();
        for (Species source : species) {
            source = this.importTemporarySpecies(source);
            result.add(source);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<Vessel> importTemporaryVessel(List<Vessel> vessels) {
        ArrayList result = Lists.newArrayList();
        Status status = this.statusDao.load(this.enumeration.STATUS_TEMPORARY_CODE);
        Integer countryLocationId = this.locationDao.getLocationIdByLabelAndLocationLevel(this.enumeration.LOCATION_LABEL_DEFAULT_COUNTRY, new Integer[]{this.enumeration.LOCATION_LEVEL_ID_COUNTRY});
        if (countryLocationId == null) {
            throw new DataIntegrityViolationException("Default country location not found, with label=" + this.enumeration.LOCATION_LABEL_DEFAULT_COUNTRY);
        }
        for (Vessel source : vessels) {
            source = this.importTemporaryVessel(source, countryLocationId, status);
            result.add(source);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<fr.ifremer.tutti.persistence.entities.referential.Person> importTemporaryPerson(List<fr.ifremer.tutti.persistence.entities.referential.Person> persons) {
        ArrayList result = Lists.newArrayList();
        Status status = this.statusDao.load(this.enumeration.STATUS_TEMPORARY_CODE);
        for (fr.ifremer.tutti.persistence.entities.referential.Person source : persons) {
            source = this.importTemporaryPerson(source, status);
            result.add(source);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<Gear> importTemporaryGear(List<Gear> gears) {
        ArrayList result = Lists.newArrayList();
        Status status = this.statusDao.load(this.enumeration.STATUS_TEMPORARY_CODE);
        for (Gear source : gears) {
            source = this.importTemporaryGear(source, status);
            result.add(source);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public TuttiEnumerationFile getEnumerationFile() {
        return this.enumeration;
    }

    public Vessel importTemporaryVessel(Vessel source, Integer registrationLocationId, Status status) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)source.getName());
        Preconditions.checkNotNull((Object)source.getInternationalRegistrationCode());
        Integer vesselTypeId = source.isScientificVessel() ? this.enumeration.VESSEL_TYPE_ID_SCIENTIFIC : this.enumeration.VESSEL_TYPE_ID_FISHING;
        fr.ifremer.adagio.core.dao.data.vessel.Vessel target = this.vesselExtendDao.createAsTemporary(null, source.getInternationalRegistrationCode(), registrationLocationId, source.getName(), vesselTypeId);
        Vessel result = TuttiBeanFactory.newVessel();
        result.setId(target.getCode());
        result.setName(source.getName());
        result.setRegistrationCode(source.getRegistrationCode());
        result.setInternationalRegistrationCode(source.getInternationalRegistrationCode());
        result.setScientificVessel(source.isScientificVessel());
        this.setStatus(status, result);
        return result;
    }

    public fr.ifremer.tutti.persistence.entities.referential.Person importTemporaryPerson(fr.ifremer.tutti.persistence.entities.referential.Person source, Status status) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)source.getFirstName());
        Preconditions.checkNotNull((Object)source.getLastName());
        Person target = this.personDao.createAsTemporary(source.getLastName(), source.getFirstName(), this.enumeration.DEPARTMENT_ID_UNKNOWN_RECORDER_DEPARTMENT);
        fr.ifremer.tutti.persistence.entities.referential.Person result = TuttiBeanFactory.newPerson();
        result.setId(target.getId().toString());
        result.setLastName(source.getLastName());
        result.setFirstName(source.getFirstName());
        this.setStatus(status, result);
        return result;
    }

    protected Species importTemporarySpecies(Species source) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)source.getName());
        TaxonRefVO taxonName = new TaxonRefVO();
        taxonName.setName(source.getName());
        taxonName = this.taxonNameDao.createAsTemporary(taxonName, "Added by tutti (file import).");
        Species result = this.loadSpecies(taxonName);
        result.setRefTaxCode(result.getExternalCode());
        Cache cache = this.cacheService.getCache("referentSpeciesById");
        cache.put((Object)Integer.valueOf(result.getId()), (Object)result);
        return result;
    }

    public Gear importTemporaryGear(Gear source, Status status) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)source.getLabel());
        Preconditions.checkNotNull((Object)source.getName());
        Integer gearClassificationId = source.isScientificGear() ? this.enumeration.GEAR_CLASSIFICIATION_ID_SCIENTIFIC : this.enumeration.GEAR_CLASSIFICIATION_ID_FISHING;
        FishingGear target = this.fishingGearDao.createAsTemporary(source.getLabel(), source.getName(), gearClassificationId);
        Gear result = TuttiBeanFactory.newGear();
        result.setId(target.getId().toString());
        result.setLabel(source.getLabel());
        result.setName(source.getName());
        result.setScientificGear(source.isScientificGear());
        this.setStatus(status, result);
        return result;
    }

    protected List<TuttiLocation> getFishingOperationLocationsByParent(Integer locationLevelId, Integer parentId, Integer parentLocationLevelId) {
        Iterator<Object[]> sources = this.queryListWithStatus("allFishingOperationLocationByParent", "parentId", IntegerType.INSTANCE, parentId, "parentLocationLevelId", IntegerType.INSTANCE, parentLocationLevelId, "locationClassificationId", IntegerType.INSTANCE, this.enumeration.LOCATION_CLASSIFICATION_ID_SECTOR, "locationLevelId", IntegerType.INSTANCE, locationLevelId);
        ArrayList result = Lists.newArrayList();
        while (sources.hasNext()) {
            Object[] source = sources.next();
            TuttiLocation target = this.loadLocation(source);
            result.add(target);
        }
        return result;
    }

    protected Caracteristic loadCaracteristic(Object[] source) {
        Integer pmfmId = (Integer)source[0];
        Caracteristic result = TuttiBeanFactory.newCaracteristic();
        result.setId(pmfmId.toString());
        result.setParameterName((String)source[1]);
        result.setMatrixName((String)source[2]);
        result.setFractionName((String)source[3]);
        result.setMethodName((String)source[4]);
        CaracteristicType type = TuttiEntities.getType((Boolean)source[5], (Boolean)source[6]);
        result.setCaracteristicType(type);
        result.setSignifFiguresNumber((Integer)source[7]);
        result.setMaximumNumberDecimals((Integer)source[8]);
        result.setPrecision((Float)source[9]);
        result.setUnit((String)source[10]);
        this.setStatus((Status)source[11], result);
        if (TuttiEntities.isQualitativeCaracteristic(result)) {
            Iterator<Object[]> sources = this.queryListWithStatus("pmfmQualitativeValues", "pmfmId", IntegerType.INSTANCE, pmfmId);
            ArrayList values = Lists.newArrayList();
            while (sources.hasNext()) {
                Object[] source2 = sources.next();
                CaracteristicQualitativeValue target2 = TuttiBeanFactory.newCaracteristicQualitativeValue();
                target2.setId(String.valueOf(source2[0]));
                target2.setName(String.valueOf(source2[1]));
                this.setStatus((Status)source2[2], target2);
                values.add(target2);
            }
            result.setQualitativeValue(Collections.unmodifiableList(values));
        }
        return result;
    }

    protected ObjectType loadObjectType(Object[] source) {
        ObjectType result = TuttiBeanFactory.newObjectType();
        result.setId((String)source[0]);
        result.setName((String)source[1]);
        result.setDescription((String)source[2]);
        return result;
    }

    protected Species loadSpecies(TaxonRefVO source) {
        Species target = TuttiBeanFactory.newSpecies();
        target.setId(String.valueOf(source.getTaxonNameId()));
        target.setName(source.getName());
        target.setExternalCode(source.getExternalCode());
        target.setReferenceTaxonId(source.getReferenceTaxonId());
        target.setReferenceTaxon(source.getIsReference());
        Status status = this.statusDao.load(source.getStatus().getValue());
        this.setStatus(status, target);
        return target;
    }

    protected Vessel loadVessel(Object[] source, boolean scientificVessel) {
        Vessel target = TuttiBeanFactory.newVessel();
        target.setId((String)source[0]);
        target.setRegistrationCode((String)source[1]);
        target.setInternationalRegistrationCode((String)source[2]);
        target.setName((String)source[3]);
        target.setScientificVessel(scientificVessel);
        this.setStatus((Status)source[4], target);
        return target;
    }

    protected fr.ifremer.tutti.persistence.entities.referential.Person loadPerson(Object[] source) {
        fr.ifremer.tutti.persistence.entities.referential.Person target = TuttiBeanFactory.newPerson();
        target.setId(String.valueOf(source[0]));
        target.setLastName((String)source[1]);
        target.setFirstName((String)source[2]);
        target.setDepartment((String)source[3]);
        this.setStatus((Status)source[4], target);
        return target;
    }

    protected Gear loadGear(Object[] source) {
        Gear result = TuttiBeanFactory.newGear();
        result.setId(String.valueOf(source[0]));
        result.setLabel((String)source[1]);
        result.setName((String)source[2]);
        GearClassification classification = (GearClassification)source[3];
        boolean scientific = false;
        if (classification != null) {
            scientific = classification.getId().equals(this.enumeration.GEAR_CLASSIFICIATION_ID_SCIENTIFIC);
        }
        result.setScientificGear(scientific);
        this.setStatus((Status)source[4], result);
        return result;
    }

    protected TuttiLocation loadLocation(Object[] source) {
        TuttiLocation target = TuttiBeanFactory.newTuttiLocation();
        target.setId(String.valueOf(source[0]));
        target.setLabel((String)source[1]);
        target.setName((String)source[2]);
        this.setStatus((Status)source[3], target);
        return target;
    }

    protected Iterator<Object[]> queryListWithStatus(String queryName, Object ... params) {
        Query query = this.createQuery(queryName, params);
        query.setString("statusValidCode", this.enumeration.STATUS_VALID_CODE);
        query.setString("statusTemporaryCode", this.enumeration.STATUS_TEMPORARY_CODE);
        Iterator result = query.iterate();
        return result;
    }

    protected Object[] queryUniqueWithStatus(String queryName, Object ... params) {
        Query query = this.createQuery(queryName, params);
        query.setString("statusValidCode", this.enumeration.STATUS_VALID_CODE);
        query.setString("statusTemporaryCode", this.enumeration.STATUS_TEMPORARY_CODE);
        Object result = query.uniqueResult();
        return (Object[])result;
    }

    protected <E extends TuttiReferentialEntity> void setStatus(Status status, E entity) {
        StatusBean newStatus = new StatusBean();
        newStatus.setId(status.getCode());
        newStatus.setName(status.getName());
        entity.setStatus(newStatus);
    }
}

