/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.translation.ocl;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.HashMap;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.translation.Expression;
import org.andromda.core.translation.TranslationUtils;
import org.andromda.core.translation.Translator;
import org.andromda.core.translation.TranslatorException;
import org.andromda.core.translation.library.LibraryTranslation;
import org.andromda.core.translation.library.LibraryTranslationFinder;
import org.andromda.translation.ocl.analysis.DepthFirstAdapter;
import org.andromda.translation.ocl.lexer.Lexer;
import org.andromda.translation.ocl.lexer.LexerException;
import org.andromda.translation.ocl.node.AClassifierContextDeclaration;
import org.andromda.translation.ocl.node.ADefClassifierExpressionBody;
import org.andromda.translation.ocl.node.AInvClassifierExpressionBody;
import org.andromda.translation.ocl.node.AOperationContextDeclaration;
import org.andromda.translation.ocl.node.AOperationExpressionBody;
import org.andromda.translation.ocl.node.Start;
import org.andromda.translation.ocl.parser.OclParser;
import org.andromda.translation.ocl.parser.OclParserException;
import org.andromda.translation.ocl.parser.ParserException;
import org.andromda.translation.ocl.syntax.ConcreteSyntaxUtils;
import org.andromda.translation.ocl.syntax.OperationDeclaration;
import org.apache.log4j.Logger;

public abstract class BaseTranslator
extends DepthFirstAdapter
implements Translator {
    protected Logger logger = Logger.getLogger(this.getClass());
    private Object contextElement = null;
    private Expression translatedExpression = null;
    private LibraryTranslation libraryTranslation = null;
    private OperationDeclaration operation;

    private void setContextElement(Object contextElement) {
        this.contextElement = contextElement;
    }

    public Expression getExpression() {
        String methodName = "BaseTranslator.getExpression";
        if (this.translatedExpression == null) {
            throw new TranslatorException("BaseTranslator.getExpression - translatedExpression can not be null");
        }
        return this.translatedExpression;
    }

    public Object getContextElement() {
        String methodName = "getContextElement";
        if (this.contextElement == null) {
            throw new TranslatorException(methodName + " - the contextElement can not be null");
        }
        return this.contextElement;
    }

    protected void handleTranslationFragment(Object node) {
        ExceptionUtils.checkNull((String)"node", (Object)node);
        if (this.libraryTranslation != null) {
            this.libraryTranslation.handleTranslationFragment(TranslationUtils.trimToEmpty((Object)node), this.getExpression().getKind(), node);
        }
    }

    protected String getTranslationFragment(String fragmentName) {
        ExceptionUtils.checkEmpty((String)"fragmentName", (String)fragmentName);
        String fragmentString = null;
        if (this.libraryTranslation != null) {
            fragmentString = this.libraryTranslation.getTranslationFragment(fragmentName, this.getExpression().getKind());
        }
        return fragmentString;
    }

    public void preProcess() {
        this.contextElement = null;
    }

    public Expression translate(String translationName, String expression, Object contextElement) {
        ExceptionUtils.checkEmpty((String)"translationName", (String)translationName);
        ExceptionUtils.checkEmpty((String)"expression", (String)expression);
        try {
            this.preProcess();
            this.setContextElement(contextElement);
            HashMap<String, Object> templateObjects = new HashMap<String, Object>();
            this.libraryTranslation = LibraryTranslationFinder.findLibraryTranslation((String)translationName);
            String variable = this.libraryTranslation.getVariable();
            if (variable != null) {
                templateObjects.put(variable, contextElement);
            }
            if (this.libraryTranslation != null) {
                this.libraryTranslation.getLibrary().initialize();
                this.libraryTranslation.processTranslation(templateObjects);
                this.process(expression);
                this.libraryTranslation.getLibrary().shutdown();
            }
            this.postProcess();
        }
        catch (Exception ex) {
            String errMsg = "Error translating with translation '" + translationName + "'," + " contextElement '" + contextElement + "' and expression --> '" + expression + "'" + "\nMESSAGE --> '" + ex.getMessage() + "'";
            this.logger.error((Object)errMsg);
            throw new TranslatorException(errMsg, (Throwable)ex);
        }
        return this.translatedExpression;
    }

    protected void process(String expression) throws IOException {
        ExceptionUtils.checkEmpty((String)"expression", (String)expression);
        try {
            Lexer lexer = new Lexer(new PushbackReader(new StringReader(expression)));
            OclParser parser = new OclParser(lexer);
            Start startNode = parser.parse();
            this.translatedExpression = new Expression(expression);
            startNode.apply(this);
        }
        catch (ParserException ex) {
            throw new OclParserException(ex.getMessage());
        }
        catch (LexerException ex) {
            throw new OclParserException(ex.getMessage());
        }
    }

    public void postProcess() {
    }

    public void inAInvClassifierExpressionBody(AInvClassifierExpressionBody expressionBody) {
        ExceptionUtils.checkNull((String)"expressionBody", (Object)expressionBody);
        if (this.translatedExpression != null) {
            this.translatedExpression.setName(TranslationUtils.trimToEmpty((Object)expressionBody.getName()));
            this.translatedExpression.setKind("inv");
        }
    }

    public void inADefClassifierExpressionBody(ADefClassifierExpressionBody expressionBody) {
        ExceptionUtils.checkNull((String)"expressionBody", (Object)expressionBody);
        if (this.translatedExpression != null) {
            this.translatedExpression.setName(TranslationUtils.trimToEmpty((Object)expressionBody.getName()));
            this.translatedExpression.setKind("def");
        }
    }

    public void inAOperationExpressionBody(AOperationExpressionBody operationExpressionBody) {
        ExceptionUtils.checkNull((String)"operationExpressionBody", (Object)operationExpressionBody);
        if (this.translatedExpression != null) {
            this.translatedExpression.setName(TranslationUtils.getPropertyAsString((Object)operationExpressionBody, (String)"name"));
            this.translatedExpression.setKind(TranslationUtils.getPropertyAsString((Object)operationExpressionBody, (String)"operationStereotype"));
        }
    }

    public void inAOperationContextDeclaration(AOperationContextDeclaration declaration) {
        String methodName = "BaseTranslator.inAOperationContextDeclaration";
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("performing BaseTranslator.inAOperationContextDeclaration with declaration --> " + declaration));
        }
        if (this.translatedExpression != null) {
            this.translatedExpression.setContextElement(ConcreteSyntaxUtils.getType(declaration.getName(), declaration.getPathNameTail()));
        }
        this.operation = ConcreteSyntaxUtils.getOperationDeclaration(declaration.getOperation());
    }

    protected OperationDeclaration getOperation() {
        return this.operation;
    }

    protected boolean isOperationArgument(String argument) {
        return this.operation != null && ConcreteSyntaxUtils.getArgumentNames(this.operation.getArguments()).contains(argument);
    }

    public void inAClassifierContextDeclaration(AClassifierContextDeclaration declaration) {
        String methodName = "BaseTranslator.inAClassifierContextDeclaration";
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("performing BaseTranslator.inAClassifierContextDeclaration with declaration --> " + declaration));
        }
        if (this.translatedExpression != null) {
            this.translatedExpression.setContextElement(ConcreteSyntaxUtils.getType(declaration.getName(), declaration.getPathNameTail()));
        }
    }
}

