package fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.create;

/*
 * #%L
 * Tutti :: UI
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.Cancelable;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.species.SelectSpeciesUI;
import fr.ifremer.tutti.ui.swing.util.species.SelectSpeciesUIModel;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.JComponent;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Map;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since 1.4
 */
public class CreateIndividualObservationBatchUIHandler extends AbstractTuttiUIHandler<CreateIndividualObservationBatchUIModel, CreateIndividualObservationBatchUI>
        implements Cancelable {

    private static final Log log =
            LogFactory.getLog(CreateIndividualObservationBatchUIHandler.class);

    public CreateIndividualObservationBatchUIHandler(TuttiUI parentUi,
                                                     CreateIndividualObservationBatchUI ui) {
        super(parentUi.getHandler().getContext(), ui);
    }

    //------------------------------------------------------------------------//
    //-- AbstractTuttiUIHandler methods                                     --//
    //------------------------------------------------------------------------//

    @Override
    public void beforeInitUI() {
        CreateIndividualObservationBatchUIModel model = new CreateIndividualObservationBatchUIModel();
        ui.setContextValue(model);
        listModelIsModify(model);
    }

    @Override
    public void afterInitUI() {

        initUI(ui);

        initBeanFilterableComboBox(ui.getIndividualObservationSpeciesComboBox(),
                                   Lists.newArrayList(getDataContext().getReferentSpeciesWithSurveyCode()),
                                   null);

        List<Caracteristic> lengthStepCaracteristics = getDataContext().getLengthStepCaracteristics();
        initBeanFilterableComboBox(ui.getIndividualObservationLengthStepCaracteristicComboBox(),
                                   Lists.newArrayList(lengthStepCaracteristics),
                                   null);

        if (context.isProtocolFilled()) {

            // get loaded protocol
            TuttiProtocol protocol = getDataContext().getProtocol();
            Preconditions.checkNotNull(protocol,
                                       "Could not find protocol in ui context");

            final Map<Integer, SpeciesProtocol> speciesProtocolMap = Maps.newHashMap();
            for (SpeciesProtocol sp : protocol.getSpecies()) {
                speciesProtocolMap.put(sp.getSpeciesReferenceTaxonId(), sp);
            }

            final Map<String, Caracteristic> lengthStepCaracteristicMap = TuttiEntities.splitById(lengthStepCaracteristics);

            getModel().addPropertyChangeListener(IndividualObservationBatch.PROPERTY_SPECIES,
                                                 new PropertyChangeListener() {
                                                     @Override
                                                     public void propertyChange(PropertyChangeEvent evt) {
                                                         Species species = (Species) evt.getNewValue();
                                                         if (species != null) {
                                                             SpeciesProtocol speciesProtocol = speciesProtocolMap.get(species.getReferenceTaxonId());
                                                             if (speciesProtocol != null) {
                                                                 String lengthStepPmfmId = speciesProtocol.getLengthStepPmfmId();
                                                                 Caracteristic lengthStepCaracteristic = lengthStepCaracteristicMap.get(lengthStepPmfmId);
                                                                 getModel().setLengthStepCaracteristic(lengthStepCaracteristic);
                                                             }
                                                         }
                                                     }
                                                 });
        }

        listenValidatorValid(ui.getValidator(), getModel());
    }

    @Override
    protected JComponent getComponentToFocus() {
        return getUI().getIndividualObservationSpeciesComboBox();
    }

    @Override
    public void onCloseUI() {

        if (log.isDebugEnabled()) {
            log.debug("closing: " + ui);
        }

        // evict model from validator
        ui.getValidator().setBean(null);

        // when canceling always invalid model
        getModel().setValid(false);

        EditCatchesUI parent = SwingUtil.getParentContainer(ui, EditCatchesUI.class);
        parent.getHandler().setIndividualObservationSelectedCard(EditCatchesUIHandler.MAIN_CARD);
    }

    @Override
    public SwingValidator<CreateIndividualObservationBatchUIModel> getValidator() {
        return ui.getValidator();
    }

    //------------------------------------------------------------------------//
    //-- Cancelable methods                                                 --//
    //------------------------------------------------------------------------//

    @Override
    public void cancel() {
        if (log.isDebugEnabled()) {
            log.debug("Cancel UI " + ui);
        }
        closeUI(ui);
    }

    //------------------------------------------------------------------------//
    //-- Public methods                                                     --//
    //------------------------------------------------------------------------//

    public void openUI(IndividualObservationBatchUIModel batchModel) {

        CreateIndividualObservationBatchUIModel model = getModel();

        // connect model to validator
        ui.getValidator().setBean(model);

        model.reset();

        model.setSpecies(batchModel.getLastSpeciesUsed());

        model.setLengthStepCaracteristic(batchModel.getLastLengthStepCaracteristicUsed());

        model.setAvailableSpecies(getDataContext().getReferentSpeciesWithSurveyCode());
    }

    public void save() {

        if (log.isDebugEnabled()) {
            log.debug("Save UI " + ui);
        }

        EditCatchesUI parent = SwingUtil.getParentContainer(ui, EditCatchesUI.class);
        parent.getIndividualObservationTabContent().getHandler().addBatch(getModel());

        // close dialog
        closeUI(ui);
    }

    public Species openAddSpeciesDialog(String title, List<Species> species) {
        SelectSpeciesUI dialogContent = new SelectSpeciesUI(ui);
        SelectSpeciesUIModel model = dialogContent.getModel();
        model.setSelectedSpecies(null);
        model.setSpecies(species);

        openDialog(dialogContent, title, new Dimension(400, 130));

        Species result = model.getSelectedSpecies();
        return result;
    }
}
