/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.content.home.CloneProtocolAction;
import fr.ifremer.tutti.ui.swing.content.home.ImportProtocolAction;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesTableModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.CloseableUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.species.SelectSpeciesUI;
import fr.ifremer.tutti.ui.swing.util.species.SelectSpeciesUIModel;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.editor.bean.BeanDoubleList;
import jaxx.runtime.swing.editor.bean.BeanDoubleListModel;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.editor.bean.BeanUIUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.autocomplete.ComboBoxCellEditor;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.i18n.I18n;
import org.nuiton.util.decorator.Decorator;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class EditProtocolUIHandler
extends AbstractTuttiUIHandler<EditProtocolUIModel, EditProtocolUI>
implements CloseableUI {
    private static final Log log = LogFactory.getLog(EditProtocolUIHandler.class);
    protected SelectSpeciesUI dialog;
    protected final PersistenceService persistenceService;

    public static String getTitle(boolean exist) {
        String result = exist ? I18n._((String)"tutti.editProtocol.title.edit.protocol", (Object[])new Object[0]) : I18n._((String)"tutti.editProtocol.title.create.protocol", (Object[])new Object[0]);
        return result;
    }

    public EditProtocolUIHandler(TuttiUI parentUi, EditProtocolUI ui) {
        super(((AbstractTuttiUIHandler)parentUi.getHandler()).getContext(), ui);
        this.persistenceService = this.context.getPersistenceService();
    }

    public JXTable getSpeciesTable() {
        return ((EditProtocolUI)this.ui).getSpeciesTable();
    }

    public JXTable getBenthosTable() {
        return ((EditProtocolUI)this.ui).getBenthosTable();
    }

    public EditProtocolSpeciesTableModel getSpeciesTableModel() {
        return (EditProtocolSpeciesTableModel)this.getSpeciesTable().getModel();
    }

    public EditProtocolSpeciesTableModel getBenthosTableModel() {
        return (EditProtocolSpeciesTableModel)this.getBenthosTable().getModel();
    }

    @Override
    public SwingValidator<EditProtocolUIModel> getValidator() {
        return ((EditProtocolUI)this.ui).getValidator();
    }

    @Override
    public void beforeInitUI() {
        this.getDataContext().resetValidationDataContext();
        EditProtocolUIModel model = new EditProtocolUIModel();
        ArrayList allSpecies = Lists.newArrayList((Iterable)this.getDataContext().getSpecies());
        model.setAllSpecies(allSpecies);
        Multimap allSpeciesByTaxonId = TuttiEntities.splitByReferenceTaxonId((Iterable)allSpecies);
        model.setAllSpeciesByTaxonId((Multimap<String, Species>)allSpeciesByTaxonId);
        Map allReferentSpeciesByTaxonId = TuttiEntities.splitByTaxonId((Iterable)this.getDataContext().getReferentSpecies());
        model.setAllReferentSpeciesByTaxonId(allReferentSpeciesByTaxonId);
        ArrayList caracteristics = Lists.newArrayList((Iterable)this.getDataContext().getCaracteristics());
        model.setCaracteristics(caracteristics);
        Map allCaracteristic = TuttiEntities.splitById((Iterable)caracteristics);
        model.setAllCaracteristic(allCaracteristic);
        this.listModelIsModify(model);
        ((EditProtocolUI)this.ui).setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        List<Object> benthosRows;
        List<Object> speciesRows;
        TuttiProtocol protocol;
        this.initUI(this.ui);
        EditProtocolUIModel model = (EditProtocolUIModel)((Object)this.getModel());
        if (this.context.isProtocolFilled()) {
            protocol = this.getDataContext().getProtocol();
            model.fromBean(protocol);
        } else {
            protocol = (TuttiProtocol)ImportProtocolAction.IMPORT_PROTOCOL_ENTRY.getContextValue((JAXXContext)this.ui);
            if (protocol != null) {
                ImportProtocolAction.IMPORT_PROTOCOL_ENTRY.removeContextValue((JAXXContext)this.ui);
                model.fromBean(protocol);
                model.setImported(true);
                ((EditProtocolUI)this.ui).getSaveWarning().setText(I18n._((String)"tutti.editProtocol.warn.import", (Object[])new Object[0]));
            } else {
                protocol = (TuttiProtocol)CloneProtocolAction.CLONE_PROTOCOL_ENTRY.getContextValue((JAXXContext)this.ui);
                if (protocol != null) {
                    CloneProtocolAction.CLONE_PROTOCOL_ENTRY.removeContextValue((JAXXContext)this.ui);
                    model.fromBean(protocol);
                    model.setCloned(true);
                    ((EditProtocolUI)this.ui).getSaveWarning().setText(I18n._((String)"tutti.editProtocol.warn.clone", (Object[])new Object[0]));
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)"Will create a new protocol");
                }
            }
        }
        SwingValidator<EditProtocolUIModel> validator = ((EditProtocolUI)this.ui).getValidator();
        this.listenValidatorValid((SimpleBeanValidator)validator, model);
        this.registerValidators(validator);
        Collection<Species> referents = model.getAllReferentSpeciesByTaxonId().values();
        this.initBeanFilterableComboBox(((EditProtocolUI)this.ui).getSpeciesComboBox(), Lists.newArrayList(referents), null);
        this.initBeanFilterableComboBox(((EditProtocolUI)this.ui).getBenthosComboBox(), Lists.newArrayList(referents), null);
        if (protocol == null) {
            speciesRows = Lists.newArrayList();
            benthosRows = Lists.newArrayList();
        } else {
            speciesRows = this.toRows(protocol.getSpecies());
            benthosRows = this.toRows(protocol.getBenthos());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will edit protocol with " + speciesRows.size() + " species and " + benthosRows.size() + " benthos declared."));
            }
        }
        model.setSpeciesRow((List<EditProtocolSpeciesRowModel>)speciesRows);
        model.setBenthosRow((List<EditProtocolSpeciesRowModel>)benthosRows);
        ((EditProtocolUI)this.ui).getSpeciesComboBox().getHandler().reset();
        ((EditProtocolUI)this.ui).getBenthosComboBox().getHandler().reset();
        JXTable table = this.getSpeciesTable();
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        this.addColumnToModel((TableColumnModel)columnModel, null, this.newTableCellRender(Species.class), EditProtocolSpeciesTableModel.SPECIES_ID);
        this.addColumnToModel((TableColumnModel)columnModel, null, null, EditProtocolSpeciesTableModel.SURVEY_CODE_ID);
        this.addLengthClassesColumnToModel((TableColumnModel)columnModel, model.getLengthClassesPmfmId());
        this.addBooleanColumnToModel((TableColumnModel)columnModel, EditProtocolSpeciesTableModel.WEIGHT_ENABLED, (JTable)table);
        this.addBooleanColumnToModel((TableColumnModel)columnModel, EditProtocolSpeciesTableModel.COUNT_IF_NO_FREQUENCY_ENABLED, (JTable)table);
        this.addBooleanColumnToModel((TableColumnModel)columnModel, EditProtocolSpeciesTableModel.SIZE_ENABLED, (JTable)table);
        this.addBooleanColumnToModel((TableColumnModel)columnModel, EditProtocolSpeciesTableModel.SEX_ENABLED, (JTable)table);
        this.addBooleanColumnToModel((TableColumnModel)columnModel, EditProtocolSpeciesTableModel.MATURITY_ENABLED, (JTable)table);
        this.addBooleanColumnToModel((TableColumnModel)columnModel, EditProtocolSpeciesTableModel.AGE_ENABLED, (JTable)table);
        this.addBooleanColumnToModel((TableColumnModel)columnModel, EditProtocolSpeciesTableModel.CALCIFY_SAMPLE_ENABLED, (JTable)table);
        EditProtocolSpeciesTableModel tableModel = new EditProtocolSpeciesTableModel((TableColumnModelExt)columnModel);
        table.setModel((TableModel)tableModel);
        table.setColumnModel((TableColumnModel)columnModel);
        this.initTable(table);
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel source = (ListSelectionModel)e.getSource();
                ((EditProtocolUI)EditProtocolUIHandler.this.ui).getRemoveSpeciesProtocolButton().setEnabled(!source.isSelectionEmpty());
            }
        });
        tableModel.setRows(speciesRows);
        table = this.getBenthosTable();
        columnModel = new DefaultTableColumnModelExt();
        this.addColumnToModel((TableColumnModel)columnModel, null, this.newTableCellRender(Species.class), EditProtocolSpeciesTableModel.SPECIES_ID);
        this.addColumnToModel((TableColumnModel)columnModel, null, null, EditProtocolSpeciesTableModel.SURVEY_CODE_ID);
        this.addLengthClassesColumnToModel((TableColumnModel)columnModel, model.getLengthClassesPmfmId());
        this.addBooleanColumnToModel((TableColumnModel)columnModel, EditProtocolSpeciesTableModel.WEIGHT_ENABLED, (JTable)table);
        this.addBooleanColumnToModel((TableColumnModel)columnModel, EditProtocolSpeciesTableModel.COUNT_IF_NO_FREQUENCY_ENABLED, (JTable)table);
        this.addBooleanColumnToModel((TableColumnModel)columnModel, EditProtocolSpeciesTableModel.SIZE_ENABLED, (JTable)table);
        this.addBooleanColumnToModel((TableColumnModel)columnModel, EditProtocolSpeciesTableModel.SEX_ENABLED, (JTable)table);
        this.addBooleanColumnToModel((TableColumnModel)columnModel, EditProtocolSpeciesTableModel.MATURITY_ENABLED, (JTable)table);
        this.addBooleanColumnToModel((TableColumnModel)columnModel, EditProtocolSpeciesTableModel.AGE_ENABLED, (JTable)table);
        this.addBooleanColumnToModel((TableColumnModel)columnModel, EditProtocolSpeciesTableModel.CALCIFY_SAMPLE_ENABLED, (JTable)table);
        tableModel = new EditProtocolSpeciesTableModel((TableColumnModelExt)columnModel);
        table.setModel((TableModel)tableModel);
        table.setColumnModel((TableColumnModel)columnModel);
        this.initTable(table);
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel source = (ListSelectionModel)e.getSource();
                ((EditProtocolUI)EditProtocolUIHandler.this.ui).getRemoveBenthosProtocolButton().setEnabled(!source.isSelectionEmpty());
            }
        });
        tableModel.setRows(benthosRows);
        this.initDoubleList("lengthClassesPmfmId", ((EditProtocolUI)this.ui).getLengthClassesList(), Lists.newArrayList(model.getCaracteristics()), model.getLengthClassesPmfmId(), new Predicate<Caracteristic>(){

            public boolean apply(Caracteristic input) {
                boolean result = !((EditProtocolUI)EditProtocolUIHandler.this.ui).getGearUseFeatureList().getModel().getSelected().contains(input);
                return result &= !((EditProtocolUI)EditProtocolUIHandler.this.ui).getVesselUseFeatureList().getModel().getSelected().contains(input);
            }
        });
        this.initDoubleList("gearUseFeaturePmfmId", ((EditProtocolUI)this.ui).getGearUseFeatureList(), Lists.newArrayList(model.getCaracteristics()), model.getGearUseFeaturePmfmId(), new Predicate<Caracteristic>(){

            public boolean apply(Caracteristic input) {
                boolean result = !((EditProtocolUI)EditProtocolUIHandler.this.ui).getLengthClassesList().getModel().getSelected().contains(input);
                return result &= !((EditProtocolUI)EditProtocolUIHandler.this.ui).getVesselUseFeatureList().getModel().getSelected().contains(input);
            }
        });
        this.initDoubleList("vesselUseFeaturePmfmId", ((EditProtocolUI)this.ui).getVesselUseFeatureList(), Lists.newArrayList(model.getCaracteristics()), model.getVesselUseFeaturePmfmId(), new Predicate<Caracteristic>(){

            public boolean apply(Caracteristic input) {
                boolean result = !((EditProtocolUI)EditProtocolUIHandler.this.ui).getGearUseFeatureList().getModel().getSelected().contains(input);
                return result &= !((EditProtocolUI)EditProtocolUIHandler.this.ui).getLengthClassesList().getModel().getSelected().contains(input);
            }
        });
        model.setModify(model.isCreate());
        ((EditProtocolUI)this.ui).getCaracteristicPane().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                BeanDoubleList<Caracteristic> selectedDoubleList;
                JTabbedPane tabPanel = (JTabbedPane)e.getSource();
                int selectedIndex = tabPanel.getSelectedIndex();
                log.debug((Object)("selected " + selectedIndex));
                switch (selectedIndex) {
                    case 0: {
                        selectedDoubleList = ((EditProtocolUI)EditProtocolUIHandler.this.ui).getLengthClassesList();
                        break;
                    }
                    case 1: {
                        selectedDoubleList = ((EditProtocolUI)EditProtocolUIHandler.this.ui).getGearUseFeatureList();
                        break;
                    }
                    case 2: {
                        selectedDoubleList = ((EditProtocolUI)EditProtocolUIHandler.this.ui).getVesselUseFeatureList();
                        break;
                    }
                    default: {
                        selectedDoubleList = null;
                    }
                }
                if (selectedDoubleList != null) {
                    selectedDoubleList.getHandler().refreshFilteredElements();
                }
            }
        });
        this.dialog = new SelectSpeciesUI(this.ui);
    }

    @Override
    protected JComponent getComponentToFocus() {
        return ((EditProtocolUI)this.getUI()).getNameField();
    }

    public List<EditProtocolSpeciesRowModel> toRows(List<SpeciesProtocol> speciesProtocols) {
        BeanFilterableComboBox<Species> speciesComboBox = ((EditProtocolUI)this.ui).getSpeciesComboBox();
        Preconditions.checkNotNull((Object)speciesComboBox.getData());
        BeanFilterableComboBox<Species> benthosComboBox = ((EditProtocolUI)this.ui).getBenthosComboBox();
        Preconditions.checkNotNull((Object)benthosComboBox.getData());
        EditProtocolUIModel model = (EditProtocolUIModel)((Object)this.getModel());
        Map<String, Species> allReferentSpeciesByTaxonId = model.getAllReferentSpeciesByTaxonId();
        Map<String, Caracteristic> allCaracteristic = model.getAllCaracteristic();
        ArrayList result = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(speciesProtocols)) {
            for (SpeciesProtocol speciesProtocol : speciesProtocols) {
                Integer taxonId = speciesProtocol.getSpeciesReferenceTaxonId();
                String taxonIdStr = String.valueOf(taxonId);
                Collection<Species> allSynonyms = model.getAllSynonyms(taxonIdStr);
                model.getAllSynonyms().removeAll(allSynonyms);
                Species species = allReferentSpeciesByTaxonId.get(taxonIdStr);
                speciesComboBox.removeItem((Object)species);
                benthosComboBox.removeItem((Object)species);
                EditProtocolSpeciesRowModel row = EditProtocolSpeciesTableModel.newRow();
                row.setSpecies(species);
                row.setLengthStepPmfm(allCaracteristic.get(speciesProtocol.getLengthStepPmfmId()));
                row.fromBean(speciesProtocol);
                result.add(row);
            }
        }
        return result;
    }

    @Override
    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        this.clearValidators();
        ((EditProtocolUI)this.ui).getTabPanel().setSelectedIndex(0);
    }

    @Override
    public boolean quitUI() {
        boolean result = this.quitScreen(((EditProtocolUIModel)((Object)this.getModel())).isValid(), ((EditProtocolUIModel)((Object)this.getModel())).isModify(), I18n._((String)"tutti.editProtocol.askCancelEditBeforeLeaving.cancelSaveProtocol", (Object[])new Object[0]), I18n._((String)"tutti.editProtocol.askSaveBeforeLeaving.saveProtocol", (Object[])new Object[0]), ((EditProtocolUI)this.ui).getSaveButton().getAction());
        return result;
    }

    public void addDoubleListListeners() {
        EditProtocolUIModel model = (EditProtocolUIModel)((Object)this.getModel());
        String id = (String)((EditProtocolUI)this.ui).getLengthClassesList().getClientProperty((Object)"_updateListenerId");
        UpdateSelectedList updateListener = (UpdateSelectedList)((EditProtocolUI)this.ui).getLengthClassesList().getClientProperty((Object)"_updateListener");
        model.addPropertyChangeListener(id, updateListener);
        id = (String)((EditProtocolUI)this.ui).getVesselUseFeatureList().getClientProperty((Object)"_updateListenerId");
        updateListener = (UpdateSelectedList)((EditProtocolUI)this.ui).getVesselUseFeatureList().getClientProperty((Object)"_updateListener");
        model.addPropertyChangeListener(id, updateListener);
        id = (String)((EditProtocolUI)this.ui).getGearUseFeatureList().getClientProperty((Object)"_updateListenerId");
        updateListener = (UpdateSelectedList)((EditProtocolUI)this.ui).getGearUseFeatureList().getClientProperty((Object)"_updateListener");
        model.addPropertyChangeListener(id, updateListener);
    }

    public void removeDoubleListListeners() {
        EditProtocolUIModel model = (EditProtocolUIModel)((Object)this.getModel());
        String id = (String)((EditProtocolUI)this.ui).getLengthClassesList().getClientProperty((Object)"_updateListenerId");
        UpdateSelectedList updateListener = (UpdateSelectedList)((EditProtocolUI)this.ui).getLengthClassesList().getClientProperty((Object)"_updateListener");
        model.removePropertyChangeListener(id, updateListener);
        id = (String)((EditProtocolUI)this.ui).getVesselUseFeatureList().getClientProperty((Object)"_updateListenerId");
        updateListener = (UpdateSelectedList)((EditProtocolUI)this.ui).getVesselUseFeatureList().getClientProperty((Object)"_updateListener");
        model.removePropertyChangeListener(id, updateListener);
        id = (String)((EditProtocolUI)this.ui).getGearUseFeatureList().getClientProperty((Object)"_updateListenerId");
        updateListener = (UpdateSelectedList)((EditProtocolUI)this.ui).getGearUseFeatureList().getClientProperty((Object)"_updateListener");
        model.removePropertyChangeListener(id, updateListener);
    }

    public Species openSelectOtherSpeciesDialog(String title, List<Species> species) {
        SelectSpeciesUIModel model = this.dialog.getModel();
        model.setSpecies(species);
        model.setSelectedSpecies(null);
        this.openDialog(this.dialog, title, new Dimension(400, 130));
        return model.getSelectedSpecies();
    }

    protected void initDoubleList(String propertyId, BeanDoubleList<Caracteristic> widget, List<Caracteristic> availableCaracteristics, List<String> selectedCaracteristics, Predicate<Caracteristic> filter) {
        this.initBeanList(widget, availableCaracteristics, Lists.newArrayList());
        UpdateSelectedList listener = new UpdateSelectedList(widget, ((EditProtocolUIModel)((Object)this.getModel())).getAllCaracteristic());
        widget.putClientProperty((Object)"_updateListener", (Object)listener);
        widget.putClientProperty((Object)"_updateListenerId", (Object)propertyId);
        listener.select(selectedCaracteristics);
        widget.getHandler().addFilter(filter);
    }

    protected void selectLengthClasses(List<String> ids, JComboBox comboBox) {
        ArrayList dataToList;
        Map<String, Caracteristic> allCaracteristic = ((EditProtocolUIModel)((Object)this.getModel())).getAllCaracteristic();
        ArrayList selection = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(ids)) {
            for (String id : ids) {
                selection.add(allCaracteristic.get(id));
            }
        }
        if (!(dataToList = Lists.newArrayList((Iterable)selection)).isEmpty() && dataToList.get(0) != null) {
            dataToList.add(0, null);
        }
        SwingUtil.fillComboBox((JComboBox)comboBox, (Collection)dataToList, null);
    }

    protected void addLengthClassesColumnToModel(TableColumnModel model, List<String> selectedIds) {
        Decorator<Caracteristic> decorator = this.getDecorator(Caracteristic.class, null);
        final JComboBox comboBox = new JComboBox();
        ((EditProtocolUIModel)((Object)this.getModel())).addPropertyChangeListener("lengthClassesPmfmId", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                List ids = (List)evt.getNewValue();
                EditProtocolUIHandler.this.selectLengthClasses(ids, comboBox);
            }
        });
        comboBox.setRenderer(this.newListCellRender(decorator));
        this.selectLengthClasses(selectedIds, comboBox);
        ObjectToStringConverter converter = BeanUIUtil.newDecoratedObjectToStringConverter(decorator);
        BeanUIUtil.decorate(comboBox, (ObjectToStringConverter)converter);
        ComboBoxCellEditor editor = new ComboBoxCellEditor(comboBox);
        this.addColumnToModel(model, (TableCellEditor)editor, this.newTableCellRender(decorator), EditProtocolSpeciesTableModel.LENGTH_STEP_PMFM_ID);
    }

    protected void initTable(JXTable table) {
        table.getTableHeader().setReorderingAllowed(false);
        this.addHighlighters(table);
        SwingUtil.scrollToTableSelection((JTable)table);
        table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                ((EditProtocolUIModel)((Object)EditProtocolUIHandler.this.getModel())).setModify(true);
            }
        });
    }

    protected void addHighlighters(final JXTable table) {
        Highlighter readOnlyHighlighter = TuttiUIUtil.newBackgroundColorHighlighter(HighlightPredicate.READ_ONLY, this.getConfig().getColorRowReadOnly());
        table.addHighlighter(readOnlyHighlighter);
        Highlighter validHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{HighlightPredicate.EDITABLE, new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                boolean result = false;
                if (adapter.isEditable()) {
                    EditProtocolSpeciesTableModel model = (EditProtocolSpeciesTableModel)table.getModel();
                    EditProtocolSpeciesRowModel row = (EditProtocolSpeciesRowModel)((Object)model.getEntry(adapter.row));
                    result = !row.isValid();
                }
                return result;
            }
        }}), this.getConfig().getColorRowInvalid());
        table.addHighlighter(validHighlighter);
    }

    protected static class UpdateSelectedList
    implements PropertyChangeListener {
        private final BeanDoubleListModel<Caracteristic> model;
        private final Map<String, Caracteristic> caracteristicMap;
        private boolean valueIsAdjusting;

        public UpdateSelectedList(BeanDoubleList<Caracteristic> doubleList, Map<String, Caracteristic> caracteristicMap) {
            this.model = doubleList.getModel();
            this.caracteristicMap = caracteristicMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!this.valueIsAdjusting) {
                this.valueIsAdjusting = true;
                try {
                    List selectedIds = (List)evt.getNewValue();
                    if (log.isInfoEnabled()) {
                        log.info((Object)("[" + evt.getPropertyName() + "] selected ids: " + selectedIds));
                    }
                    this.select(selectedIds);
                }
                finally {
                    this.valueIsAdjusting = false;
                }
            }
        }

        public void select(List<String> selectedIds) {
            ArrayList selection = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty(selectedIds)) {
                for (String selectedId : selectedIds) {
                    Caracteristic e = this.caracteristicMap.get(selectedId);
                    Preconditions.checkNotNull((Object)e, (Object)("Could not find caracteristic with id: " + selectedId));
                    selection.add(e);
                }
            }
            this.model.setSelected((List)selection);
        }
    }
}

