/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.home;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.TuttiIOUtil;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.export.TuttiExportService;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUI;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUIHandler;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import java.io.File;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ExportProgramAction
extends AbstractTuttiAction<SelectCruiseUIModel, SelectCruiseUI, SelectCruiseUIHandler> {
    private static final Log log = LogFactory.getLog(ExportProgramAction.class);
    protected File file;

    public ExportProgramAction(SelectCruiseUIHandler handler) {
        super(handler, true);
    }

    @Override
    protected boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        Program program = ((SelectCruiseUIModel)this.getModel()).getProgram();
        if (doAction) {
            this.file = TuttiUIUtil.saveFile("exportProgram-" + program.getName() + ".zip", this.getContext().getMainUI(), I18n._((String)"tutti.selectCruise.title.choose.exportProgramFile", (Object[])new Object[0]), I18n._((String)"tutti.selectCruise.action.chooseProgramExportFile", (Object[])new Object[0]), "^.+\\.zip$", I18n._((String)"tutti.common.file.zip", (Object[])new Object[0]));
            boolean bl = doAction = this.file != null;
            if (doAction) {
                this.file = TuttiIOUtil.addExtensionIfMissing(this.file, ".zip");
                doAction = ((SelectCruiseUIHandler)this.getHandler()).askOverwriteFile(this.file);
            }
        }
        return doAction;
    }

    @Override
    protected void releaseAction() {
        this.file = null;
        super.releaseAction();
    }

    @Override
    protected void doAction() throws Exception {
        Program program = ((SelectCruiseUIModel)this.getModel()).getProgram();
        Preconditions.checkNotNull((Object)program);
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will save program " + program.getId() + " to file: " + this.file));
        }
        List allCruise = this.getContext().getPersistenceService().getAllCruise(program.getId());
        ProgressionModel progressionModel = new ProgressionModel();
        this.setProgressionModel(progressionModel);
        progressionModel.setTotal(9 * allCruise.size() + 1);
        TuttiProtocol protocol = null;
        if (this.getContext().isProtocolFilled()) {
            protocol = this.getDataContext().getProtocol();
            if (log.isInfoEnabled()) {
                log.info((Object)("Will use protocol " + protocol.getName()));
            }
        }
        TuttiExportService service = this.getContext().getTuttiExportService();
        service.exportProgram(program.getId(), protocol, this.file, progressionModel);
        ((SelectCruiseUIHandler)this.getHandler()).resetEditProgramAction();
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        Program program = ((SelectCruiseUIModel)this.getModel()).getProgram();
        this.sendMessage(I18n._((String)"tutti.exportProgram.action.success", (Object[])new Object[]{program.getName(), this.file.getName()}));
    }
}

