/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency;

import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIModel;
import java.util.List;
import java.util.Set;

public class SpeciesFrequencyUIModel
extends AbstractTuttiTableUIModel<SpeciesBatchRowModel, SpeciesFrequencyRowModel, SpeciesFrequencyUIModel> {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_BATCH = "batch";
    public static final String PROPERTY_CONFIGURATION_MODE = "configurationMode";
    public static final String PROPERTY_STEP = "step";
    private static final String PROPERTY_MIN_STEP = "minStep";
    private static final String PROPERTY_MAX_STEP = "maxStep";
    public static final String PROPERTY_CAN_GENERATE = "canGenerate";
    public static final String PROPERTY_SIMPLE_MODE = "simpleMode";
    public static final String PROPERTY_AUTO_GEN_MODE = "autoGenMode";
    public static final String PROPERTY_RAFALE_MODE = "rafaleMode";
    public static final String PROPERTY_SIMPLE_COUNTING_MODE = "simpleCountingMode";
    public static final String PROPERTY_SIMPLE_COUNT = "simpleCount";
    public static final String PROPERTY_LENGHT_STEP_CARACTERISTIC = "lengthStepCaracteristic";
    public static final String PROPERTY_TOTAL_NUMBER = "totalNumber";
    public static final String PROPERTY_TOTAL_WEIGHT = "totalWeight";
    public static final String PROPERTY_EMPTY_ROWS = "emptyRows";
    protected ConfigurationMode configurationMode;
    protected SpeciesBatchRowModel batch;
    protected float step;
    protected Float minStep;
    protected Float maxStep;
    protected Caracteristic lengthStepCaracteristic;
    protected Integer totalNumber;
    protected Float totalWeight;
    protected Integer simpleCount;
    protected Set<SpeciesFrequencyRowModel> emptyRows;

    public SpeciesFrequencyUIModel() {
        super(SpeciesBatchRowModel.class, null, null);
        this.setEmptyRows(Sets.newHashSet());
    }

    @Override
    public void setRows(List<SpeciesFrequencyRowModel> rows) {
        super.setRows(rows);
        this.setEmptyRows(Sets.newHashSet());
    }

    public ConfigurationMode getConfigurationMode() {
        return this.configurationMode;
    }

    public void setConfigurationMode(ConfigurationMode configurationMode) {
        ConfigurationMode oldValue = this.getConfigurationMode();
        this.configurationMode = configurationMode;
        this.firePropertyChange(PROPERTY_CONFIGURATION_MODE, (Object)oldValue, (Object)configurationMode);
        this.firePropertyChange(PROPERTY_SIMPLE_MODE, null, this.isSimpleMode());
        this.firePropertyChange(PROPERTY_AUTO_GEN_MODE, null, this.isAutoGenMode());
        this.firePropertyChange(PROPERTY_RAFALE_MODE, null, this.isRafaleMode());
        this.firePropertyChange(PROPERTY_SIMPLE_COUNTING_MODE, null, this.isSimpleCountingMode());
    }

    public float getStep() {
        return this.step;
    }

    public void setStep(float step) {
        Float oldValue = Float.valueOf(this.getStep());
        this.step = step;
        this.firePropertyChange(PROPERTY_STEP, oldValue, Float.valueOf(step));
    }

    public Caracteristic getLengthStepCaracteristic() {
        return this.lengthStepCaracteristic;
    }

    public void setLengthStepCaracteristic(Caracteristic lengthStepCaracteristic) {
        Caracteristic oldValue = this.getLengthStepCaracteristic();
        this.lengthStepCaracteristic = lengthStepCaracteristic;
        this.firePropertyChange(PROPERTY_LENGHT_STEP_CARACTERISTIC, oldValue, lengthStepCaracteristic);
        this.firePropertyChange(PROPERTY_CAN_GENERATE, null, this.isCanGenerate());
    }

    public Float getMinStep() {
        return this.minStep;
    }

    public void setMinStep(Float minStep) {
        Float oldValue = this.getMinStep();
        this.minStep = minStep;
        this.firePropertyChange(PROPERTY_MIN_STEP, oldValue, minStep);
        this.firePropertyChange(PROPERTY_CAN_GENERATE, null, this.isCanGenerate());
    }

    public Float getMaxStep() {
        return this.maxStep;
    }

    public void setMaxStep(Float maxStep) {
        Float oldValue = this.getMaxStep();
        this.maxStep = maxStep;
        this.firePropertyChange(PROPERTY_MAX_STEP, oldValue, maxStep);
        this.firePropertyChange(PROPERTY_CAN_GENERATE, null, this.isCanGenerate());
    }

    public Integer getSimpleCount() {
        return this.simpleCount;
    }

    public void setSimpleCount(Integer simpleCount) {
        Integer oldValue = this.getSimpleCount();
        this.simpleCount = simpleCount;
        this.firePropertyChange(PROPERTY_SIMPLE_COUNT, oldValue, simpleCount);
    }

    public boolean isSimpleMode() {
        return ConfigurationMode.SIMPLE == this.configurationMode;
    }

    public boolean isAutoGenMode() {
        return ConfigurationMode.AUTO_GEN == this.configurationMode;
    }

    public boolean isRafaleMode() {
        return ConfigurationMode.RAFALE == this.configurationMode;
    }

    public boolean isSimpleCountingMode() {
        return ConfigurationMode.SIMPLE_COUNTING == this.configurationMode;
    }

    public boolean isCanGenerate() {
        return this.minStep != null && this.maxStep != null && this.maxStep.floatValue() > this.minStep.floatValue() && this.lengthStepCaracteristic != null;
    }

    public SpeciesBatchRowModel getBatch() {
        return this.batch;
    }

    public void setBatch(SpeciesBatchRowModel batch) {
        this.batch = batch;
        this.firePropertyChange(PROPERTY_BATCH, null, batch);
    }

    public float getLengthStep(float lengthStep) {
        int intValue = (int)(lengthStep * 10.0f);
        int intStep = (int)(this.step * 10.0f);
        int correctIntStep = intValue - intValue % intStep;
        float result = (float)correctIntStep / 10.0f;
        return result;
    }

    public Integer getTotalNumber() {
        return this.totalNumber;
    }

    public void setTotalNumber(Integer totalNumber) {
        Integer oldValue = this.getTotalNumber();
        this.totalNumber = totalNumber;
        this.firePropertyChange(PROPERTY_TOTAL_NUMBER, oldValue, totalNumber);
    }

    public Float getTotalWeight() {
        return this.totalWeight;
    }

    public void setTotalWeight(Float totalWeight) {
        Float oldValue = this.getTotalWeight();
        this.totalWeight = totalWeight;
        this.firePropertyChange(PROPERTY_TOTAL_WEIGHT, oldValue, totalWeight);
    }

    public Set<SpeciesFrequencyRowModel> getEmptyRows() {
        return this.emptyRows;
    }

    public void setEmptyRows(Set<SpeciesFrequencyRowModel> emptyRows) {
        this.emptyRows = emptyRows;
        this.firePropertyChange(PROPERTY_EMPTY_ROWS, null, emptyRows);
    }

    public void addEmptyRow(SpeciesFrequencyRowModel row) {
        this.emptyRows.add(row);
        this.firePropertyChange(PROPERTY_EMPTY_ROWS, null, this.emptyRows);
    }

    public void removeEmptyRow(SpeciesFrequencyRowModel row) {
        this.emptyRows.remove(row);
        this.firePropertyChange(PROPERTY_EMPTY_ROWS, null, this.emptyRows);
    }

    @Override
    protected SpeciesBatchRowModel newEntity() {
        return new SpeciesBatchRowModel();
    }

    public static enum ConfigurationMode {
        SIMPLE,
        AUTO_GEN,
        RAFALE,
        SIMPLE_COUNTING;

    }
}

