/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.metafacade;

import java.io.Serializable;
import java.util.List;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.metafacade.MetafacadeBase;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;

public class ModelValidationMessage
implements Serializable {
    private String name;
    private String message;
    private MetafacadeBase metafacade;
    private String metafacadeName = null;
    private Class metafacadeClass = null;
    static /* synthetic */ Class class$org$andromda$core$metafacade$ModelValidationMessage;

    public ModelValidationMessage(MetafacadeBase metafacade, String message) {
        this(metafacade, null, message);
    }

    public ModelValidationMessage(MetafacadeBase metafacade, String name, String message) {
        ExceptionUtils.checkNull("metafacade", metafacade);
        ExceptionUtils.checkEmpty("message", message);
        this.metafacade = metafacade;
        this.name = name;
        this.message = message;
    }

    public String getName() {
        return this.name;
    }

    public String getMessage() {
        return this.message;
    }

    public String getMetafacadeName() {
        if (this.metafacadeName == null) {
            String seperator = "::";
            StringBuffer name = new StringBuffer();
            for (MetafacadeBase metafacade = this.metafacade; metafacade != null; metafacade = (MetafacadeBase)metafacade.getValidationOwner()) {
                if (!StringUtils.isNotBlank((String)metafacade.getValidationName())) continue;
                String validationName = metafacade.getValidationName();
                if (metafacade.getValidationOwner() != null) {
                    validationName = validationName.replaceAll(".*::", "");
                }
                if (name.length() > 0) {
                    name.insert(0, "::");
                }
                name.insert(0, validationName);
            }
            this.metafacadeName = name.toString();
        }
        return this.metafacadeName;
    }

    public Class getMetafacadeClass() {
        if (this.metafacadeClass == null) {
            this.metafacadeClass = this.metafacade.getClass();
            List interfaces = ClassUtils.getAllInterfaces(this.metafacade.getClass());
            if (interfaces != null && !interfaces.isEmpty()) {
                this.metafacadeClass = (Class)interfaces.iterator().next();
            }
        }
        return this.metafacadeClass;
    }

    public String toString() {
        StringBuffer toString = new StringBuffer();
        toString.append("[");
        toString.append(this.getMetafacadeName());
        toString.append("]");
        toString.append(":");
        toString.append(this.message);
        return toString.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        boolean equals;
        boolean bl = object != null && (class$org$andromda$core$metafacade$ModelValidationMessage == null ? (class$org$andromda$core$metafacade$ModelValidationMessage = ModelValidationMessage.class$("org.andromda.core.metafacade.ModelValidationMessage")) : class$org$andromda$core$metafacade$ModelValidationMessage) == object.getClass() ? true : (equals = false);
        if (equals) {
            ModelValidationMessage message = (ModelValidationMessage)object;
            equals = message.toString().equals(this.toString());
        }
        return equals;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

