/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches;

import fr.ifremer.tutti.persistence.entities.data.SampleCategory;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.Serializable;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.swing.editor.NumberEditor;
import org.nuiton.util.decorator.Decorator;

public class SampleCategoryComponent {
    public static <C extends Serializable> TableCellRenderer newRender(TableCellRenderer renderer, Decorator<C> decorator, Color computedDataColor) {
        return new SampleCategoryRenderer<C>(renderer, decorator, computedDataColor);
    }

    public static <C extends Serializable> TableCellEditor newEditor(Decorator<C> decorator) {
        return new SampleCategoryEditor<C>(decorator);
    }

    public static class SampleCategoryRenderer<C extends Serializable>
    implements TableCellRenderer {
        protected final TableCellRenderer delegate;
        protected final Decorator<C> categoryDecorator;
        protected final Color computedWeightColor;

        public SampleCategoryRenderer(TableCellRenderer delegate, Decorator<C> categoryDecorator, Color computedWeightColor) {
            this.delegate = delegate;
            this.categoryDecorator = categoryDecorator;
            this.computedWeightColor = computedWeightColor;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Serializable categoryValue;
            SampleCategory sampleCategory = (SampleCategory)value;
            String text = null;
            if (sampleCategory != null && (categoryValue = sampleCategory.getCategoryValue()) != null) {
                Float number = sampleCategory.getCategoryWeight();
                Float computedNumber = sampleCategory.getComputedWeight();
                text = "<html><span style='white-space: nowrap;'>" + this.categoryDecorator.toString((Object)categoryValue) + " /";
                if (sampleCategory.isSubSample()) {
                    text = text + "/";
                }
                text = text + " ";
                if (number != null) {
                    text = text + JAXXUtil.getStringValue((Object)number);
                } else if (computedNumber != null) {
                    if (sampleCategory.hasOnlyOneFrequency()) {
                        text = text + TuttiUIUtil.getWeightStringValue(computedNumber);
                    } else {
                        String color = Integer.toHexString(this.computedWeightColor.getRGB()).substring(2);
                        text = text + "<em style='color: #" + color + "'>" + TuttiUIUtil.getWeightStringValue(computedNumber) + "</em>";
                    }
                } else {
                    text = text + "-";
                }
                text = text + "</span></html>";
            }
            JComponent result = (JComponent)this.delegate.getTableCellRendererComponent(table, text, isSelected, hasFocus, row, column);
            result.setToolTipText(text);
            return result;
        }
    }

    public static class SampleCategoryEditor<C extends Serializable>
    extends AbstractCellEditor
    implements TableCellEditor,
    FocusListener,
    AncestorListener {
        private static final long serialVersionUID = 1L;
        protected final NumberEditor numberEditor;
        protected final JPanel editor;
        protected final JLabel editorLabel;
        protected final Decorator<C> categoryDecorator;

        public SampleCategoryEditor(Decorator<C> categoryDecorator) {
            this.categoryDecorator = categoryDecorator;
            this.numberEditor = new NumberEditor();
            this.numberEditor.getTextField().setHorizontalAlignment(4);
            this.numberEditor.getTextField().setBorder(null);
            this.numberEditor.getTextField().addFocusListener(this);
            this.numberEditor.getTextField().addAncestorListener(this);
            this.numberEditor.setModelType(Float.class);
            this.numberEditor.setUseSign(Boolean.valueOf(false));
            this.numberEditor.init();
            this.editor = new JPanel(new BorderLayout());
            this.editorLabel = new JLabel();
            this.editor.add("West", this.editorLabel);
            this.editor.add("Center", (Component)this.numberEditor);
        }

        public NumberEditor getNumberEditor() {
            return this.numberEditor;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            SampleCategory sampleCategory = (SampleCategory)value;
            Serializable categoryValue = sampleCategory == null ? null : sampleCategory.getCategoryValue();
            Float number = sampleCategory == null ? null : sampleCategory.getCategoryWeight();
            this.numberEditor.setModel((Number)number);
            if (number == null) {
                this.numberEditor.setModelText("");
            } else {
                this.numberEditor.setModelText(String.valueOf(number));
            }
            String label = sampleCategory == null ? "-" : this.categoryDecorator.toString((Object)categoryValue);
            this.editorLabel.setText(label);
            return this.editor;
        }

        @Override
        public Float getCellEditorValue() {
            return (Float)this.numberEditor.getModel();
        }

        @Override
        public void focusGained(FocusEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SampleCategoryEditor.this.numberEditor.getTextField().requestFocus();
                    SampleCategoryEditor.this.numberEditor.getTextField().selectAll();
                }
            });
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SampleCategoryEditor.this.numberEditor.getTextField().requestFocus();
                    SampleCategoryEditor.this.numberEditor.getTextField().selectAll();
                }
            });
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }

        @Override
        public boolean stopCellEditing() {
            boolean result = super.stopCellEditing();
            if (result) {
                this.resetEditor();
            }
            return result;
        }

        @Override
        public void cancelCellEditing() {
            this.resetEditor();
            super.cancelCellEditing();
        }

        protected void resetEditor() {
            this.numberEditor.setModel(null);
            this.numberEditor.setModelText("");
            this.editorLabel.setText("-");
        }
    }
}

