/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.InvalidBatchModelException;
import fr.ifremer.tutti.persistence.entities.TuttiBeanFactory;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.TuttiEntity;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUI;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.SaveFishingOperationAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.ComputeWeightsAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SaveCatchBatchAction;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.GearUseFeatureTabUI;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.VesselUseFeatureTabUI;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionHelper;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.decorator.Decorator;

public class EditFishingOperationAction
extends AbstractTuttiAction<FishingOperationsUIModel, FishingOperationsUI, FishingOperationsUIHandler> {
    private static final Log log = LogFactory.getLog(EditFishingOperationAction.class);
    protected FishingOperation fishingOperation;
    protected boolean checkPreviousEdit = true;
    protected SaveFishingOperationAction saveFishingOperationAction;
    protected ComputeWeightsAction computeWeightsAction;
    protected SaveCatchBatchAction saveCatchBatchAction;
    private final PropertyChangeListener coordinatePropertiesListener = new PropertyChangeListener(){
        private List<String> properties = Lists.newArrayList((Object[])new String[]{"fishingOperationRectiligne", "gearShootingEndLatitude", "gearShootingEndLatitudeDecimalMinute", "gearShootingEndLatitudeDegree", "gearShootingEndLatitudeMinute", "gearShootingEndLatitudeSecond", "gearShootingEndLongitude", "gearShootingEndLongitudeDecimalMinute", "gearShootingEndLongitudeDegree", "gearShootingEndLongitudeMinute", "gearShootingEndLongitudeSecond", "gearShootingStartLatitude", "gearShootingStartLatitudeDecimalMinute", "gearShootingStartLatitudeDegree", "gearShootingStartLatitudeMinute", "gearShootingStartLatitudeSecond", "gearShootingStartLongitude", "gearShootingStartLongitudeDecimalMinute", "gearShootingStartLongitudeDegree", "gearShootingStartLongitudeMinute", "gearShootingStartLongitudeSecond"});

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            EditFishingOperationUIModel source;
            if (this.properties.contains(evt.getPropertyName()) && (source = (EditFishingOperationUIModel)evt.getSource()).isFishingOperationRectiligne()) {
                source.computeDistance();
            }
        }
    };

    public EditFishingOperationAction(FishingOperationsUIHandler handler) {
        super(handler, true);
        this.setActionDescription(I18n._((String)"tutti.editFishingOperation.action.editFishingOperation.tip", (Object[])new Object[0]));
    }

    public void setFishingOperation(FishingOperation fishingOperation) {
        this.fishingOperation = fishingOperation;
    }

    public void setCheckPreviousEdit(boolean checkPreviousEdit) {
        this.checkPreviousEdit = checkPreviousEdit;
    }

    @Override
    protected void releaseAction() {
        this.fishingOperation = null;
        this.checkPreviousEdit = true;
        super.releaseAction();
    }

    protected SaveFishingOperationAction getSaveFishingOperationAction() {
        if (this.saveFishingOperationAction == null) {
            this.saveFishingOperationAction = new SaveFishingOperationAction(((FishingOperationsUI)this.getUI()).getFishingOperationTabContent().getHandler());
        }
        return this.saveFishingOperationAction;
    }

    protected SaveCatchBatchAction getSaveCatchBatchAction() {
        if (this.saveCatchBatchAction == null) {
            this.saveCatchBatchAction = new SaveCatchBatchAction(((FishingOperationsUI)this.getUI()).getCatchesTabContent().getHandler());
        }
        return this.saveCatchBatchAction;
    }

    protected ComputeWeightsAction getComputeWeightsAction() {
        if (this.computeWeightsAction == null) {
            this.computeWeightsAction = new ComputeWeightsAction(((FishingOperationsUI)this.getUI()).getCatchesTabContent().getHandler());
        }
        return this.computeWeightsAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean prepareAction() {
        boolean canContinue = true;
        if (this.checkPreviousEdit) {
            FishingOperationsUI ui = (FishingOperationsUI)this.getUI();
            FishingOperationsUIModel model = ui.getModel();
            FishingOperation editFishingOperation = model.getEditFishingOperation();
            String editFishingOperationId = null;
            if (editFishingOperation == null) {
                canContinue = true;
            } else {
                boolean needSave;
                editFishingOperationId = editFishingOperation.getId();
                boolean create = TuttiEntities.isNew((TuttiEntity)editFishingOperation);
                boolean fishingOperationModified = ((FishingOperationsUIHandler)this.getHandler()).isFishingOperationModified();
                boolean catchBatchModified = ((FishingOperationsUIHandler)this.getHandler()).isCatchBatchModified();
                boolean fishingOperationValid = ((FishingOperationsUIHandler)this.getHandler()).isFishingOperationValid();
                boolean catchBatchValid = ((FishingOperationsUIHandler)this.getHandler()).isCatchBatchValid();
                boolean bl = needSave = create || fishingOperationModified || catchBatchModified;
                if (needSave) {
                    boolean canSave = fishingOperationValid && catchBatchValid;
                    canContinue = false;
                    if (canSave) {
                        String message = create ? I18n._((String)"tutti.editFishingOperation.askSaveBeforeLeaving.createFishingOperation", (Object[])new Object[0]) : (fishingOperationModified ? I18n._((String)"tutti.editFishingOperation.askSaveBeforeLeaving.saveFishingOperation", (Object[])new Object[0]) : I18n._((String)"tutti.editCatchBatch.askSaveBeforeLeaving.saveCatchBatch", (Object[])new Object[0]));
                        int answer = ((FishingOperationsUIHandler)this.getHandler()).askSaveBeforeLeaving(message);
                        switch (answer) {
                            case 0: {
                                if (fishingOperationModified) {
                                    this.getSaveFishingOperationAction().setUpdateUI(false);
                                    TuttiActionHelper.runInternalAction(this.getSaveFishingOperationAction());
                                }
                                if (catchBatchModified) {
                                    this.getSaveCatchBatchAction().setUpdateUI(false);
                                    TuttiActionHelper.runInternalAction(this.getSaveCatchBatchAction());
                                }
                                canContinue = true;
                                break;
                            }
                            case 1: {
                                canContinue = true;
                            }
                        }
                    } else {
                        String message = fishingOperationValid ? I18n._((String)"tutti.editCatchBatch.askCancelEditBeforeLeaving.cancelEditCatchBatch", (Object[])new Object[0]) : I18n._((String)"tutti.editFishingOperation.askCancelEditBeforeLeaving.cancelEditFishingOperation", (Object[])new Object[0]);
                        canContinue = ((FishingOperationsUIHandler)this.handler).askCancelEditBeforeLeaving(message);
                    }
                }
            }
            if (!canContinue) {
                FishingOperation selectFishingOperation = TuttiEntities.isNew((TuttiEntity)editFishingOperation) ? null : model.getFishingOperation(editFishingOperationId);
                model.setEditionAdjusting(true);
                try {
                    model.setSelectedFishingOperation(selectFishingOperation);
                }
                finally {
                    model.setEditionAdjusting(false);
                }
            }
        }
        return canContinue;
    }

    @Override
    protected void doAction() throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("Try to edit fishingOperation: " + this.fishingOperation));
        }
        FishingOperationsUI ui = (FishingOperationsUI)this.getUI();
        FishingOperationsUIModel model = ui.getModel();
        if (log.isInfoEnabled()) {
            log.info((Object)("Edit in ui fishingOperation: " + this.fishingOperation));
        }
        model.setEditFishingOperation(this.fishingOperation);
        String fishingOperationText = this.getFishingOperationTitle(this.fishingOperation);
        this.loadFishingOperation(this.fishingOperation, fishingOperationText);
        this.loadCatchBatch(this.fishingOperation, fishingOperationText, true);
        JTabbedPane form = ui.getTabPane();
        JLabel noContentPane = ui.getNoTraitPane();
        if (this.fishingOperation == null) {
            ui.remove(form);
            ui.add((Component)noContentPane, "Center");
        } else {
            ui.remove(noContentPane);
            ui.add((Component)form, "Center");
            ui.getFishingOperationTabContent().getFishingOperationTabPane().setSelectedIndex(0);
            if (this.checkPreviousEdit) {
                ui.getTabPane().setSelectedIndex(0);
            }
        }
        model.addPropertyChangeListener(this.coordinatePropertiesListener);
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        ((FishingOperationsUI)this.getUI()).getFishingOperationTabContent().getModel().setModify(false);
        ((FishingOperationsUI)this.getUI()).repaint();
    }

    public void loadFishingOperation(FishingOperation bean, String fishingOperationText) {
        EditFishingOperationUI ui = ((FishingOperationsUI)this.getUI()).getFishingOperationTabContent();
        EditFishingOperationUIHandler handler = ui.getHandler();
        EditFishingOperationUIModel editFishingOperationUIModel = ui.getModel();
        editFishingOperationUIModel.setLoadingData(true);
        editFishingOperationUIModel.removeAllAttachment(editFishingOperationUIModel.getAttachment());
        handler.uninstallStartDateListener();
        handler.uninstallCoordinatesListener();
        if (bean == null) {
            editFishingOperationUIModel.fromBean(TuttiBeanFactory.newFishingOperation());
            editFishingOperationUIModel.setFishingOperation(bean);
            handler.clearValidators();
            handler.resetAllModels();
        } else {
            TuttiLocation strata = bean.getStrata();
            TuttiLocation subStrata = bean.getSubStrata();
            TuttiLocation location = bean.getLocation();
            Cruise cruise = bean.getCruise();
            if (cruise != null) {
                ui.getGearComboBox().setData((List)Lists.newArrayList((Iterable)cruise.getGear()));
            }
            editFishingOperationUIModel.fromBean(bean);
            editFishingOperationUIModel.setStrata(null);
            editFishingOperationUIModel.setSubStrata(null);
            editFishingOperationUIModel.setLocation(null);
            editFishingOperationUIModel.convertGearShootingCoordinatesDDToDMS();
            if (strata != null) {
                ui.getStrataComboBox().setSelectedItem((Object)strata);
            }
            if (subStrata != null) {
                ui.getSubStrataComboBox().setSelectedItem((Object)subStrata);
            }
            if (location != null) {
                ui.getLocationComboBox().setSelectedItem((Object)location);
            }
            editFishingOperationUIModel.setFishingOperation(bean);
            List<Person> saisisseur = editFishingOperationUIModel.getRecorderPerson();
            ui.getRecorderPersonList().getHandler().setSelected(saisisseur);
            GearUseFeatureTabUI gearUseFeatureTabContent = ui.getGearUseFeatureTabContent();
            gearUseFeatureTabContent.getHandler().reset(bean);
            VesselUseFeatureTabUI vesselUseFeatureTabContent = ui.getVesselUseFeatureTabContent();
            vesselUseFeatureTabContent.getHandler().reset(bean);
            Integer objectId = editFishingOperationUIModel.getObjectId();
            if (objectId != null) {
                List attachments = this.getContext().getPersistenceService().getAllAttachments(editFishingOperationUIModel.getObjectType(), objectId);
                editFishingOperationUIModel.addAllAttachment(attachments);
            }
            editFishingOperationUIModel.setModify(false);
            handler.getFishingOperationMonitor().clearModified();
            handler.registerValidator();
        }
        editFishingOperationUIModel.setLoadingData(false);
        ui.getTraitGeneralTabPane().setTitle(fishingOperationText);
        ui.getVesselUseFeatureTabPane().setTitle(fishingOperationText);
        ui.getGearUseFeatureTabPane().setTitle(fishingOperationText);
        handler.installStartDateListener();
        handler.installCoordinatesListener();
    }

    public String getFishingOperationTitle(FishingOperation bean) {
        Decorator<FishingOperation> decorator = this.getDecorator(FishingOperation.class, null);
        String fishingOperationText = bean == null ? null : (TuttiEntities.isNew((TuttiEntity)bean) ? I18n._((String)"tutti.editFishingOperation.label.traitReminder", (Object[])new Object[]{I18n._((String)"tutti.editFishingOperation.label.traitReminder.inCreation", (Object[])new Object[0])}) : I18n._((String)"tutti.editFishingOperation.label.traitReminder", (Object[])new Object[]{decorator.toString((Object)bean)}));
        return fishingOperationText;
    }

    public void loadCatchBatch(FishingOperation bean, String fishingOperationText, boolean loadOtherTabs) {
        List attachments;
        CatchBatch batch;
        boolean empty = bean == null || TuttiEntities.isNew((TuttiEntity)bean);
        EditCatchesUI ui = ((FishingOperationsUI)this.getUI()).getCatchesTabContent();
        TuttiBeanMonitor<EditCatchesUIModel> catchBatchMonitor = ui.getHandler().getCatchBatchMonitor();
        EditCatchesUIModel catchesUIModel = ui.getModel();
        catchesUIModel.setLoadingData(true);
        catchesUIModel.reset();
        if (empty) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Create a new CatchBatch (fishing operation is null)");
            }
            batch = TuttiBeanFactory.newCatchBatch();
            batch.setFishingOperation(bean);
            attachments = Collections.emptyList();
            ((FishingOperationsUIModel)((Object)this.getModel())).setCatchEnabled(true);
        } else {
            PersistenceService persistenceService;
            boolean withCatchBath;
            String operationId = bean.getId();
            if (log.isInfoEnabled()) {
                log.info((Object)("Load existing CatchBatch from operation id: " + operationId));
            }
            if (withCatchBath = (persistenceService = this.getContext().getPersistenceService()).isFishingOperationWithCatchBatch(operationId)) {
                try {
                    batch = persistenceService.getCatchBatchFromFishingOperation(operationId);
                    batch.setFishingOperation(bean);
                    Integer objectId = Integer.valueOf(batch.getId());
                    attachments = persistenceService.getAllAttachments(catchesUIModel.getObjectType(), objectId);
                    ((FishingOperationsUIModel)((Object)this.getModel())).setCatchNotFound(false);
                    ((FishingOperationsUIModel)((Object)this.getModel())).setCatchEnabled(true);
                }
                catch (InvalidBatchModelException e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Invalid batch model", (Throwable)e);
                    }
                    batch = null;
                    attachments = Collections.emptyList();
                    ((FishingOperationsUIModel)((Object)this.getModel())).setCatchEnabled(false);
                }
            } else {
                batch = null;
                attachments = Collections.emptyList();
                ((FishingOperationsUIModel)((Object)this.getModel())).setCatchEnabled(false);
                ((FishingOperationsUIModel)((Object)this.getModel())).setCatchNotFound(true);
            }
        }
        catchesUIModel.setCatchBatch(batch);
        catchesUIModel.setFishingOperation(bean);
        catchesUIModel.fromBean(batch);
        catchesUIModel.addAllAttachment(attachments);
        catchesUIModel.setModify(false);
        catchBatchMonitor.clearModified();
        ui.getCatchesCaracteristicsTabPane().setTitle(fishingOperationText);
        ui.getSpeciesTabFishingOperationReminderLabel().setTitle(fishingOperationText);
        ui.getBenthosTabFishingOperationReminderLabel().setTitle(fishingOperationText);
        ui.getMarineLitterTabFishingOperationReminderLabel().setTitle(fishingOperationText);
        ui.getAccidentalTabFishingOperationReminderLabel().setTitle(fishingOperationText);
        ui.getIndividualObservationTabFishingOperationReminderLabel().setTitle(fishingOperationText);
        if (loadOtherTabs) {
            FishingOperation operationToLoad = batch == null ? null : bean;
            ui.getSpeciesTabContent().getHandler().selectFishingOperation(operationToLoad);
            ui.getBenthosTabContent().getHandler().selectFishingOperation(operationToLoad);
            ui.getMarineLitterTabContent().getHandler().selectFishingOperation(operationToLoad);
            ui.getAccidentalTabContent().getHandler().selectFishingOperation(operationToLoad);
            ui.getIndividualObservationTabContent().getHandler().selectFishingOperation(operationToLoad);
        }
        catchesUIModel.setLoadingData(false);
    }
}

