/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.table.AbstractSelectTableAction;
import java.util.HashSet;
import javax.swing.JTable;
import org.jdesktop.swingx.JXTable;

public class RemoveBenthosSubBatchAction
extends AbstractTuttiAction<BenthosBatchUIModel, BenthosBatchUI, BenthosBatchUIHandler> {
    public RemoveBenthosSubBatchAction(BenthosBatchUIHandler handler) {
        super(handler, false);
    }

    @Override
    protected void doAction() throws Exception {
        PersistenceService persistenceService = this.getContext().getPersistenceService();
        JXTable table = ((BenthosBatchUIHandler)this.handler).getTable();
        int rowIndex = table.getSelectedRow();
        Preconditions.checkState((rowIndex != -1 ? 1 : 0) != 0, (Object)"Cant remove sub batch if no batch selected");
        BenthosBatchRowModel parentBatch = (BenthosBatchRowModel)((BenthosBatchUIHandler)this.handler).getTableModel().getEntry(rowIndex);
        Preconditions.checkState((!TuttiEntities.isNew(parentBatch) ? 1 : 0) != 0, (Object)"Can't remove sub batch if batch is not persisted");
        persistenceService.deleteSpeciesSubBatch(parentBatch.getId());
        HashSet rowToRemove = Sets.newHashSet();
        ((BenthosBatchUIHandler)this.handler).collectChildren(parentBatch, rowToRemove);
        table.clearSelection();
        ((BenthosBatchUIModel)this.getModel()).getRows().removeAll(rowToRemove);
        parentBatch.setChildBatch(null);
        ((BenthosBatchUIHandler)this.handler).getTableModel().fireTableDataChanged();
        AbstractSelectTableAction.doSelectCell((JTable)table, rowIndex, 0);
        if (table.isEditing()) {
            table.getCellEditor().stopCellEditing();
        }
    }
}

