/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.export;

import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryEnum;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiCsvUtil;
import fr.ifremer.tutti.service.export.CatchExportRow;
import fr.ifremer.tutti.service.export.ExportSampleCategory;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.nuiton.util.csv.ValueFormatter;

public class CatchExportModel
extends TuttiCsvUtil.AbstractTuttiExportModel<CatchExportRow> {
    public static final String WEIGHT_OR_VOL_TYPE = "Poids";
    Map<SampleCategoryEnum, Caracteristic> sampleCategoryToCaracteristics;

    public CatchExportModel(char separator, List<SampleCategoryEnum> samplingOrder, Map<SampleCategoryEnum, Caracteristic> sampleCategoryToCaracteristics) {
        super(separator);
        this.sampleCategoryToCaracteristics = sampleCategoryToCaracteristics;
        this.newColumnForExport("Annee", "beginDate", (ValueFormatter)TuttiCsvUtil.YEAR);
        this.newColumnForExport("Serie", "program", "name");
        this.newColumnForExport("Serie_Partielle", "surveyPart");
        this.newColumnForExport("Engin", "gear", "name");
        this.newColumnForExport("Poche", "multirigAggregation");
        this.newColumnForExport("Id_Operation", "stationNumber");
        this.newColumnForExport("NumOrdre_Station", "fishingOperationNumber", (ValueFormatter)TuttiCsvUtil.INTEGER);
        this.newColumnForExport("Navire", "vessel", "name");
        this.newColumnForExport("Taxon", "species.referenceTaxonId", (ValueFormatter)TuttiCsvUtil.INTEGER);
        for (SampleCategoryEnum sampleCategoryEnum : samplingOrder) {
            switch (sampleCategoryEnum) {
                case sortedUnsorted: {
                    this.addSampleCategory("Vrac", "sortedUnsortedSampleCategory");
                    break;
                }
                case size: {
                    this.addSampleCategory("Cat_Tri", "sizeSampleCategory");
                    break;
                }
                case sex: {
                    this.addSampleCategory("Sexe", "sexSampleCategory");
                    break;
                }
                case maturity: {
                    this.addSampleCategory("Maturite", "maturitySampleCategory");
                    break;
                }
                case age: {
                    this.addSampleCategory("Age", "ageSampleCategory");
                }
            }
        }
        this.newNullableColumnForExport("Code_Longueur", "frequency.lengthStepCaracteristic.id");
        this.newNullableColumnForExport("Taille", "frequency.lengthStep", TuttiCsvUtil.FLOAT);
        this.newNullableColumnForExport("NumOrdre_Taille_H2", "frequency.rankOrder", TuttiCsvUtil.INTEGER);
        this.newNullableColumnForExport("Poids_Classe_Taille", "frequency.weight", TuttiCsvUtil.FLOAT);
        this.newNullableColumnForExport("Unite_Taille", "frequency.lengthStepCaracteristic.unit");
        this.newNullableColumnForExport("Precision_Mesure", "frequency.lengthStepCaracteristic.precision", TuttiCsvUtil.FLOAT);
        this.newNullableColumnForExport("Nbr", "frequency.number", TuttiCsvUtil.INTEGER);
    }

    public void prepareRows(PersistenceService persistenceService, List<CatchExportRow> rows, Cruise cruise, FishingOperation operation, BatchContainer<SpeciesBatch> rootSpeciesBatch, BatchContainer<BenthosBatch> rootBenthosBatch) {
        CatchExportRow row;
        for (SpeciesBatch speciesBatch : rootSpeciesBatch.getChildren()) {
            row = new CatchExportRow();
            row.setCruise(cruise);
            row.setFishingOperation(operation);
            row.setSpecies(speciesBatch.getSpecies());
            this.prepareRows(persistenceService, row, rows, speciesBatch);
        }
        for (BenthosBatch benthosBatch : rootBenthosBatch.getChildren()) {
            row = new CatchExportRow();
            row.setCruise(cruise);
            row.setFishingOperation(operation);
            row.setSpecies(benthosBatch.getSpecies());
            this.prepareRows(persistenceService, row, rows, benthosBatch);
        }
    }

    public void prepareRows(PersistenceService persistenceService, CatchExportRow currentRow, List<CatchExportRow> rows, SpeciesBatch speciesBatch) {
        ExportSampleCategory sampleCategory = new ExportSampleCategory();
        SampleCategoryEnum sampleCategoryType = speciesBatch.getSampleCategoryType();
        Caracteristic caracteristic = this.sampleCategoryToCaracteristics.get(sampleCategoryType);
        sampleCategory.setCategoryCaracteristic(caracteristic);
        sampleCategory.setCategoryType(sampleCategoryType);
        sampleCategory.setCategoryValue(speciesBatch.getSampleCategoryValue());
        sampleCategory.setCategoryWeight(speciesBatch.getSampleCategoryWeight());
        sampleCategory.setSampleWeight(speciesBatch.getWeight());
        sampleCategory.setComputedWeight(speciesBatch.getSampleCategoryComputedWeight());
        sampleCategory.setNumber(speciesBatch.getNumber());
        sampleCategory.setComputedNumber(speciesBatch.getComputedNumber());
        sampleCategory.setWeightOrVolType(WEIGHT_OR_VOL_TYPE);
        sampleCategory.setRankOrder(speciesBatch.getRankOrder());
        currentRow.addCategory(sampleCategory);
        if (speciesBatch.isChildBatchsEmpty()) {
            List<SpeciesBatchFrequency> speciesBatchFrequency = persistenceService.getAllSpeciesBatchFrequency(speciesBatch.getId());
            if (CollectionUtils.isEmpty(speciesBatchFrequency)) {
                rows.add(currentRow.copy());
            } else {
                for (SpeciesBatchFrequency batchFrequency : speciesBatchFrequency) {
                    CatchExportRow row = currentRow.copy();
                    row.setSpeciesFrequency(batchFrequency);
                    rows.add(row);
                }
            }
        } else {
            for (SpeciesBatch childBatch : speciesBatch.getChildBatchs()) {
                this.prepareRows(persistenceService, currentRow, rows, childBatch);
            }
        }
    }

    public void prepareRows(PersistenceService persistenceService, CatchExportRow currentRow, List<CatchExportRow> rows, BenthosBatch benthosBatch) {
        ExportSampleCategory sampleCategory = new ExportSampleCategory();
        SampleCategoryEnum sampleCategoryType = benthosBatch.getSampleCategoryType();
        Caracteristic caracteristic = this.sampleCategoryToCaracteristics.get(sampleCategoryType);
        sampleCategory.setCategoryCaracteristic(caracteristic);
        sampleCategory.setCategoryType(sampleCategoryType);
        sampleCategory.setCategoryValue(benthosBatch.getSampleCategoryValue());
        sampleCategory.setCategoryWeight(benthosBatch.getSampleCategoryWeight());
        sampleCategory.setSampleWeight(benthosBatch.getWeight());
        sampleCategory.setComputedWeight(benthosBatch.getSampleCategoryComputedWeight());
        sampleCategory.setNumber(benthosBatch.getNumber());
        sampleCategory.setComputedNumber(benthosBatch.getComputedNumber());
        sampleCategory.setWeightOrVolType(WEIGHT_OR_VOL_TYPE);
        sampleCategory.setRankOrder(benthosBatch.getRankOrder());
        currentRow.addCategory(sampleCategory);
        if (benthosBatch.isChildBatchsEmpty()) {
            List<BenthosBatchFrequency> speciesBatchFrequency = persistenceService.getAllBenthosBatchFrequency(benthosBatch.getId());
            if (CollectionUtils.isEmpty(speciesBatchFrequency)) {
                rows.add(currentRow.copy());
            } else {
                for (BenthosBatchFrequency batchFrequency : speciesBatchFrequency) {
                    CatchExportRow row = currentRow.copy();
                    row.setBenthosFrequency(batchFrequency);
                    rows.add(row);
                }
            }
        } else {
            for (BenthosBatch childBatch : benthosBatch.getChildBatchs()) {
                this.prepareRows(persistenceService, currentRow, rows, childBatch);
            }
        }
    }

    protected void addSampleCategory(String headerPrefix, String categoryName) {
        this.newNullableColumnForExport(headerPrefix, categoryName + "." + "categoryValue", TuttiCsvUtil.CARACTERISTIC_VALUE_FORMATTER);
        this.newNullableColumnForExport("Num_Ordre_" + headerPrefix + "_H2", categoryName + "." + "rankOrder", TuttiCsvUtil.INTEGER);
        this.newNullableColumnForExport("Tot_" + headerPrefix, categoryName + "." + "categoryWeight", TuttiCsvUtil.FLOAT);
        this.newNullableColumnForExport("Ech_" + headerPrefix, categoryName + "." + "sampleWeight", TuttiCsvUtil.FLOAT);
        this.newNullableColumnForExport("Type_Volume_Poids_" + headerPrefix, categoryName + "." + "weightOrVolType");
        this.newNullableColumnForExport("Unite_Volume_Poids_" + headerPrefix, categoryName + "." + "categoryCaracteristic" + "." + "unit");
    }
}

