/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content;

import fr.ifremer.tutti.TuttiBusinessException;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.ui.swing.TuttiApplicationUpdaterCallBack;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfig;
import fr.ifremer.tutti.ui.swing.content.AbstractMainUITuttiAction;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import fr.ifremer.tutti.ui.swing.content.db.OpenDbAction;
import fr.ifremer.tutti.ui.swing.util.TuttiErrorHelper;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionHelper;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.updater.ApplicationUpdater;
import org.nuiton.util.updater.ApplicationUpdaterCallback;
import org.nuiton.util.updater.DownloadMonitor;

public class UpdateDbAction
extends AbstractMainUITuttiAction {
    private static final Log log = LogFactory.getLog(UpdateDbAction.class);

    public UpdateDbAction(MainUIHandler handler) {
        super(handler, true);
        this.setActionDescription(I18n._((String)"tutti.dbManager.action.upgradeDb.tip", (Object[])new Object[0]));
    }

    @Override
    protected boolean prepareAction() throws Exception {
        TuttiUIContext context = this.getContext();
        TuttiApplicationConfig config = context.getConfig();
        String url = config.getUpdateUrl();
        try {
            TuttiUIUtil.tryToConnectToUpdateUrl(url, I18n.n_((String)"tutti.error.update.could.not.reach.url", (Object[])new Object[0]));
        }
        catch (TuttiBusinessException e) {
            new TuttiErrorHelper(this.getContext()).showErrorDialog(e.getMessage());
            return false;
        }
        return super.prepareAction();
    }

    @Override
    protected void doAction() {
        TuttiUIContext context = this.getContext();
        TuttiApplicationConfig config = context.getConfig();
        File current = config.getDataDirectory();
        String url = config.getUpdateUrl();
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Try to install / update db (current data location: %s), using update url: %s", current, url));
        }
        File dest = new File(config.getTuttiBasedir(), "NEW");
        ProgressionModel progressionModel = new ProgressionModel();
        context.getActionUI().getModel().setProgressionModel(progressionModel);
        progressionModel.setMessage(I18n._((String)"tutti.dbManager.action.upgradeDb.check", (Object[])new Object[0]));
        TuttiApplicationUpdaterCallBack callback = new TuttiApplicationUpdaterCallBack(this, progressionModel);
        callback.setTypes(TuttiApplicationUpdaterCallBack.UpdateType.DB);
        ApplicationUpdater up = new ApplicationUpdater();
        up.update(url, current, dest, false, (ApplicationUpdaterCallback)callback, (DownloadMonitor)progressionModel);
        if (callback.isDbInstalled()) {
            progressionModel.setMessage(I18n._((String)"tutti.dbManager.action.upgradeDb.opening", (Object[])new Object[0]));
            this.getContext().setDbExist(true);
            TuttiActionHelper.runInternalAction(this.getHandler(), OpenDbAction.class);
        } else if (callback.isDbUpdated()) {
            progressionModel.setMessage(I18n._((String)"tutti.dbManager.action.upgradeDb.reloading", (Object[])new Object[0]));
            TuttiActionHelper.runInternalAction(this.getHandler(), OpenDbAction.class);
        } else {
            this.sendMessage(I18n._((String)"tutti.dbManager.action.upgradeDb.upToDate", (Object[])new Object[0]));
        }
    }
}

