/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.engine;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.andromda.core.ModelValidationException;
import org.andromda.core.cartridge.Cartridge;
import org.andromda.core.common.AndroMDALogger;
import org.andromda.core.common.BuildInformation;
import org.andromda.core.common.ComponentContainer;
import org.andromda.core.common.ExceptionRecorder;
import org.andromda.core.common.Introspector;
import org.andromda.core.common.ResourceWriter;
import org.andromda.core.common.XmlObjectFactory;
import org.andromda.core.configuration.Configuration;
import org.andromda.core.configuration.Filters;
import org.andromda.core.configuration.Model;
import org.andromda.core.configuration.Namespace;
import org.andromda.core.configuration.Namespaces;
import org.andromda.core.configuration.Property;
import org.andromda.core.configuration.Repository;
import org.andromda.core.engine.ModelProcessorException;
import org.andromda.core.metafacade.MetafacadeFactory;
import org.andromda.core.metafacade.ModelAccessFacade;
import org.andromda.core.metafacade.ModelValidationMessage;
import org.andromda.core.namespace.NamespaceComponents;
import org.andromda.core.repository.Repositories;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ModelProcessor {
    private static final Logger logger = Logger.getLogger((Class)(class$org$andromda$core$engine$ModelProcessor == null ? (class$org$andromda$core$engine$ModelProcessor = ModelProcessor.class$("org.andromda.core.engine.ModelProcessor")) : class$org$andromda$core$engine$ModelProcessor));
    private final MetafacadeFactory factory = MetafacadeFactory.getInstance();
    private final Namespaces namespaces = Namespaces.instance();
    private final Repositories repositories = Repositories.instance();
    private Configuration currentConfiguration = null;
    private static final String VERSION = BuildInformation.instance().getBuildVersion();
    private boolean modelValidation = true;
    private boolean failOnValidationErrors = true;
    private List cartridgeFilter = null;
    private boolean negateCartridgeFilter = false;
    private static final String CARTRIDGE_FILTER_NEGATOR = "~";
    static /* synthetic */ Class class$org$andromda$core$engine$ModelProcessor;
    static /* synthetic */ Class class$org$andromda$core$cartridge$Cartridge;

    public static ModelProcessor newInstance() {
        return new ModelProcessor();
    }

    private ModelProcessor() {
    }

    public ModelValidationMessage[] process(Configuration configuration) {
        this.configure(configuration);
        List messages = this.process(configuration.getRepositories());
        return messages != null ? messages.toArray(new ModelValidationMessage[0]) : new ModelValidationMessage[]{};
    }

    private void configure(Configuration configuration) {
        if (this.requiresConfiguration(configuration)) {
            configuration.initialize();
            this.reset();
            Property[] properties = configuration.getProperties();
            int propertyNumber = properties.length;
            Introspector introspector = Introspector.instance();
            for (int ctr = 0; ctr < propertyNumber; ++ctr) {
                Property property = properties[ctr];
                try {
                    introspector.setProperty(this, property.getName(), property.getValue());
                    continue;
                }
                catch (Throwable throwable) {
                    AndroMDALogger.warn("Could not set model processor property '" + property.getName() + "' with a value of '" + property.getValue() + "'");
                }
            }
            this.currentConfiguration = configuration;
        }
    }

    private List process(Repository[] repositories) {
        List messages = null;
        long startTime = System.currentTimeMillis();
        int repositoryNumber = repositories.length;
        for (int ctr = 0; ctr < repositoryNumber; ++ctr) {
            Repository repository = repositories[ctr];
            if (repository == null) continue;
            String repositoryName = repository.getName();
            Model[] models = this.filterInvalidModels(repository.getModels());
            if (models.length > 0) {
                messages = this.processModels(repositoryName, models);
                AndroMDALogger.info("completed model processing --> TIME: " + this.getDurationInSeconds(startTime) + "[s], RESOURCES WRITTEN: " + ResourceWriter.instance().getWrittenCount());
                continue;
            }
            AndroMDALogger.warn("No model(s) found to process for repository '" + repositoryName + "'");
        }
        return messages == null ? Collections.EMPTY_LIST : messages;
    }

    private List processModels(String repositoryName, Model[] models) {
        List messages = null;
        String cartridgeName = null;
        try {
            boolean lastModifiedCheck = true;
            long lastModified = 0L;
            ResourceWriter writer = ResourceWriter.instance();
            for (int ctr = 0; ctr < models.length; ++ctr) {
                Model model = models[ctr];
                writer.resetHistory(model.getUris()[0]);
                boolean bl = lastModifiedCheck = model.isLastModifiedCheck() && lastModifiedCheck;
                if (model.getLastModified() <= lastModified) continue;
                lastModified = model.getLastModified();
            }
            if (!lastModifiedCheck || writer.isHistoryBefore(lastModified)) {
                Collection cartridges = ComponentContainer.instance().findComponentsOfType(class$org$andromda$core$cartridge$Cartridge == null ? (class$org$andromda$core$cartridge$Cartridge = ModelProcessor.class$("org.andromda.core.cartridge.Cartridge")) : class$org$andromda$core$cartridge$Cartridge);
                if (cartridges.isEmpty()) {
                    AndroMDALogger.warn("WARNING! No cartridges found, check your classpath!");
                }
                Map cartridgesByNamespace = this.loadCartridgesByNamespace(cartridges);
                Collection namespaces = this.namespaces.getNamespaces();
                messages = this.loadIfNecessary(models);
                Iterator iterator = namespaces.iterator();
                while (iterator.hasNext()) {
                    Namespace namespace = (Namespace)iterator.next();
                    Cartridge cartridge = (Cartridge)cartridgesByNamespace.get(namespace.getName());
                    if (cartridge == null || !this.shouldProcess(cartridgeName = cartridge.getNamespace())) continue;
                    this.factory.setNamespace(cartridgeName);
                    cartridge.initialize();
                    for (int ctr = 0; ctr < models.length; ++ctr) {
                        Model model = models[ctr];
                        this.factory.setModel(this.repositories.getImplementation(repositoryName).getModel(), model.getType());
                        cartridge.processModelElements(this.factory);
                        writer.writeHistory();
                    }
                    cartridge.shutdown();
                }
            }
        }
        catch (ModelValidationException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            String messsage = "Error performing ModelProcessor.process with model(s) --> '" + StringUtils.join((Object[])models, (String)",") + "'";
            logger.error((Object)messsage);
            ExceptionRecorder.instance().record(messsage, throwable, cartridgeName);
            throw new ModelProcessorException(messsage, throwable);
        }
        return messages == null ? Collections.EMPTY_LIST : messages;
    }

    private Map loadCartridgesByNamespace(Collection cartridges) {
        LinkedHashMap<String, Cartridge> cartridgesByNamespace = new LinkedHashMap<String, Cartridge>();
        Iterator iterator = cartridges.iterator();
        while (iterator.hasNext()) {
            Cartridge cartridge = (Cartridge)iterator.next();
            cartridgesByNamespace.put(cartridge.getNamespace(), cartridge);
        }
        return cartridgesByNamespace;
    }

    public void initialize(Configuration configuration) {
        long startTime = System.currentTimeMillis();
        this.printConsoleHeader();
        this.configure(configuration);
        AndroMDALogger.initialize();
        NamespaceComponents.instance().discover();
        this.repositories.initialize();
        this.factory.initialize();
        this.printWorkCompleteMessage("core initialization", startTime);
    }

    protected final List loadModelIfNecessary(Model model) {
        ArrayList validationMessages = new ArrayList();
        long startTime = System.currentTimeMillis();
        if (this.repositories.loadModel(model)) {
            this.printWorkCompleteMessage("loading", startTime);
            Repository repository = model.getRepository();
            String repositoryName = repository != null ? repository.getName() : null;
            validationMessages.addAll(this.validateModel(repositoryName, model));
        }
        return validationMessages;
    }

    private List validateModel(String repositoryName, Model model) {
        Filters constraints = model != null ? model.getConstraints() : null;
        ArrayList validationMessages = new ArrayList();
        if (this.modelValidation) {
            long startTime = System.currentTimeMillis();
            AndroMDALogger.info("- validating model -");
            Collection cartridges = ComponentContainer.instance().findComponentsOfType(class$org$andromda$core$cartridge$Cartridge == null ? (class$org$andromda$core$cartridge$Cartridge = ModelProcessor.class$("org.andromda.core.cartridge.Cartridge")) : class$org$andromda$core$cartridge$Cartridge);
            ModelAccessFacade modelAccessFacade = this.repositories.getImplementation(repositoryName).getModel();
            this.factory.clearCaches();
            this.factory.setModel(modelAccessFacade, model.getType());
            Iterator iterator = cartridges.iterator();
            while (iterator.hasNext()) {
                Cartridge cartridge = (Cartridge)iterator.next();
                String cartridgeName = cartridge.getNamespace();
                if (!this.shouldProcess(cartridgeName)) continue;
                this.factory.setNamespace(cartridgeName);
                this.factory.validateAllMetafacades();
            }
            List messages = this.factory.getValidationMessages();
            this.filterAndSortValidationMessages(messages, constraints);
            this.printValidationMessages(messages);
            this.printWorkCompleteMessage("validation", startTime);
            if (messages != null && !messages.isEmpty()) {
                validationMessages.addAll(messages);
            }
        }
        return validationMessages;
    }

    private void printWorkCompleteMessage(String unitOfWork, long startTime) {
        AndroMDALogger.info("- " + unitOfWork + " complete: " + this.getDurationInSeconds(startTime) + "[s] -");
    }

    private double getDurationInSeconds(long startTime) {
        return (double)(System.currentTimeMillis() - startTime) / 1000.0;
    }

    private void printValidationMessages(List messages) {
        if (messages != null && !messages.isEmpty()) {
            StringBuffer header = new StringBuffer("Model Validation Failed - " + messages.size() + " VALIDATION ERROR");
            if (messages.size() > 1) {
                header.append("S");
            }
            AndroMDALogger.error(header);
            Iterator iterator = messages.iterator();
            int ctr = 1;
            while (iterator.hasNext()) {
                ModelValidationMessage message = (ModelValidationMessage)iterator.next();
                AndroMDALogger.error(ctr + ") " + message);
                ++ctr;
            }
            AndroMDALogger.reset();
            if (this.failOnValidationErrors) {
                throw new ModelValidationException("Model validation failed!");
            }
        }
    }

    private boolean requiresConfiguration(Configuration configuration) {
        boolean requiresConfiguration;
        boolean bl = requiresConfiguration = this.currentConfiguration == null || this.currentConfiguration.getContents() == null || configuration.getContents() == null;
        if (!requiresConfiguration) {
            requiresConfiguration = !this.currentConfiguration.getContents().equals(configuration.getContents());
        }
        return requiresConfiguration;
    }

    final List loadIfNecessary(Repository[] repositories) {
        ArrayList messages = new ArrayList();
        if (repositories != null && repositories.length > 0) {
            int repositoryNumber = repositories.length;
            for (int repositoryCtr = 0; repositoryCtr < repositoryNumber; ++repositoryCtr) {
                Repository repository = repositories[repositoryCtr];
                if (repository == null) continue;
                messages.addAll(this.loadIfNecessary(repository.getModels()));
            }
        }
        return messages;
    }

    private List loadIfNecessary(Model[] models) {
        ArrayList messages = new ArrayList();
        if (models != null && models.length > 0) {
            int modelNumber = models.length;
            for (int modelCtr = 0; modelCtr < modelNumber; ++modelCtr) {
                messages.addAll(this.loadModelIfNecessary(models[modelCtr]));
            }
        }
        return messages;
    }

    protected void printConsoleHeader() {
        AndroMDALogger.info("");
        AndroMDALogger.info("A n d r o M D A  -  " + VERSION);
        AndroMDALogger.info("");
    }

    public void setModelValidation(boolean modelValidation) {
        this.modelValidation = modelValidation;
    }

    public void setFailOnValidationErrors(boolean failOnValidationErrors) {
        this.failOnValidationErrors = failOnValidationErrors;
    }

    protected boolean shouldProcess(String namespace) {
        boolean shouldProcess = this.namespaces.namespacePresent(namespace);
        if (shouldProcess) {
            boolean bl = shouldProcess = this.cartridgeFilter == null || this.cartridgeFilter.isEmpty();
            if (!shouldProcess) {
                shouldProcess = this.negateCartridgeFilter ^ this.cartridgeFilter.contains(StringUtils.trimToEmpty((String)namespace));
            }
        }
        return shouldProcess;
    }

    public void setCartridgeFilter(String namespaces) {
        if (namespaces != null) {
            if ((namespaces = StringUtils.deleteWhitespace((String)namespaces)).startsWith(CARTRIDGE_FILTER_NEGATOR)) {
                this.negateCartridgeFilter = true;
                namespaces = namespaces.substring(1);
            } else {
                this.negateCartridgeFilter = false;
            }
            if (StringUtils.isNotBlank((String)namespaces)) {
                this.cartridgeFilter = Arrays.asList(namespaces.split(","));
            }
        }
    }

    public void setOutputEncoding(String outputEncoding) {
        ResourceWriter.instance().setEncoding(outputEncoding);
    }

    public void setXmlValidation(boolean xmlValidation) {
        XmlObjectFactory.setDefaultValidating(xmlValidation);
    }

    public void setLoggingConfigurationUri(String loggingConfigurationUri) {
        AndroMDALogger.setLoggingConfigurationUri(loggingConfigurationUri);
    }

    private Model[] filterInvalidModels(Model[] models) {
        ArrayList<Model> validModels = new ArrayList<Model>(Arrays.asList(models));
        Iterator iterator = validModels.iterator();
        while (iterator.hasNext()) {
            Model model = (Model)iterator.next();
            if (model != null && model.getUris() != null && model.getUris().length > 0) continue;
            iterator.remove();
        }
        return validModels.toArray(new Model[0]);
    }

    public void shutdown() {
        this.factory.shutdown();
        this.namespaces.clear();
        ComponentContainer.instance().shutdown();
        NamespaceComponents.instance().shutdown();
        Introspector.instance().shutdown();
        Configuration.clearCaches();
        this.repositories.clear();
    }

    private void reset() {
        this.factory.reset();
        this.cartridgeFilter = null;
        this.setXmlValidation(true);
        this.setOutputEncoding(null);
        this.setModelValidation(true);
        this.setLoggingConfigurationUri(null);
        this.setFailOnValidationErrors(true);
    }

    protected void filterAndSortValidationMessages(List messages, Filters constraints) {
        if (constraints != null) {
            Iterator iterator = messages.iterator();
            while (iterator.hasNext()) {
                ModelValidationMessage message = (ModelValidationMessage)iterator.next();
                if (message == null || constraints.isApply(message.getName())) continue;
                iterator.remove();
            }
        }
        if (messages != null && !messages.isEmpty()) {
            ComparatorChain chain = new ComparatorChain();
            chain.addComparator((Comparator)new ValidationMessageTypeComparator());
            chain.addComparator((Comparator)new ValidationMessageNameComparator());
            Collections.sort(messages, chain);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class ValidationMessageNameComparator
    implements Comparator {
        private final Collator collator = Collator.getInstance();

        ValidationMessageNameComparator() {
            this.collator.setStrength(0);
        }

        public int compare(Object objectA, Object objectB) {
            ModelValidationMessage a = (ModelValidationMessage)objectA;
            ModelValidationMessage b = (ModelValidationMessage)objectB;
            return this.collator.compare(StringUtils.trimToEmpty((String)a.getMetafacadeName()), StringUtils.trimToEmpty((String)b.getMetafacadeName()));
        }
    }

    private static final class ValidationMessageTypeComparator
    implements Comparator {
        private final Collator collator = Collator.getInstance();

        ValidationMessageTypeComparator() {
            this.collator.setStrength(0);
        }

        public int compare(Object objectA, Object objectB) {
            ModelValidationMessage a = (ModelValidationMessage)objectA;
            ModelValidationMessage b = (ModelValidationMessage)objectB;
            return this.collator.compare(a.getMetafacadeClass().getName(), b.getMetafacadeClass().getName());
        }
    }
}

