/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.export;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import fr.ifremer.tutti.TuttiBusinessException;
import fr.ifremer.tutti.TuttiIOUtil;
import fr.ifremer.tutti.TuttiTechnicalException;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryEnum;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiCsvUtil;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.catches.TuttiWeightComputingService;
import fr.ifremer.tutti.service.export.CatchExportModel;
import fr.ifremer.tutti.service.export.CatchExportRow;
import fr.ifremer.tutti.service.export.OperationExportModel;
import fr.ifremer.tutti.service.export.OperationExportRow;
import fr.ifremer.tutti.service.export.ParameterExportModel;
import fr.ifremer.tutti.service.export.ParameterExportRow;
import fr.ifremer.tutti.service.export.SurveyExportModel;
import fr.ifremer.tutti.service.export.SurveyExportRow;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.decorator.Decorator;

public class TuttiExportService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(TuttiExportService.class);
    protected PersistenceService persistenceService;
    protected DecoratorService decoratorService;
    protected TuttiWeightComputingService tuttiWeightComputingService;
    protected char csvSeparator;
    protected Caracteristic verticalOpeningCaracteristic;
    protected Caracteristic horizontalOpeningWingCaracteristic;
    protected Caracteristic horizontalOpeningDoorCaracteristic;
    protected TuttiLocation country;
    protected List<SampleCategoryEnum> samplingOrder;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.decoratorService = this.getService(DecoratorService.class);
        this.tuttiWeightComputingService = this.getService(TuttiWeightComputingService.class);
        this.csvSeparator = context.getConfig().getCsvSeparator();
        this.verticalOpeningCaracteristic = this.persistenceService.getVerticalOpeningCaracteristic();
        this.horizontalOpeningWingCaracteristic = this.persistenceService.getHorizontalOpeningWingCaracteristic();
        this.horizontalOpeningDoorCaracteristic = this.persistenceService.getHorizontalOpeningDoorCaracteristic();
        List<TuttiLocation> allCountry = this.persistenceService.getAllCountry();
        String countryId = context.getConfig().getExportCountryId();
        this.country = (TuttiLocation)TuttiEntities.splitById(allCountry).get(countryId);
        Map idMapping = SampleCategoryEnum.toIdMapping();
        this.samplingOrder = Lists.newArrayList();
        this.samplingOrder.add(SampleCategoryEnum.sortedUnsorted);
        for (Integer categoryId : context.getConfig().getSamplingOrderIds()) {
            SampleCategoryEnum categoryEnum = (SampleCategoryEnum)idMapping.get(categoryId);
            if (SampleCategoryEnum.sortedUnsorted == categoryEnum) continue;
            this.samplingOrder.add(categoryEnum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportProgram(String programId, File exportFile, ProgressionModel progressionModel) {
        Preconditions.checkNotNull((Object)programId);
        Preconditions.checkNotNull((Object)exportFile);
        Program program = this.persistenceService.getProgram(programId);
        Preconditions.checkNotNull((Object)program);
        List<Cruise> allCruise = this.persistenceService.getAllCruise(programId);
        for (Cruise cruise : allCruise) {
            this.checkCruise(progressionModel, cruise);
        }
        File basedir = new File(this.context.getConfig().newTempFile("exportProgram"), "exportProgram-" + programId);
        TuttiIOUtil.forceMkdir((File)basedir, (String)"Could not create directory");
        ExportContext exportContext = this.createExportContext(basedir);
        try {
            for (Cruise cruise : allCruise) {
                cruise = this.persistenceService.getCruise(cruise.getId());
                this.exportCruise(cruise, exportContext, progressionModel);
            }
            TuttiIOUtil.close((Closeable)exportContext, (String)"Could not close export context");
            progressionModel.setMessage(I18n._((String)"tutti.service.exportCruise.buildZip", (Object[])new Object[]{exportFile}));
            TuttiIOUtil.zip((File)basedir, (File)exportFile, (String)"Could not create export zip");
            progressionModel.increments(1);
        }
        finally {
            IOUtils.closeQuietly((Closeable)exportContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportCruise(String cruiseId, File exportFile, ProgressionModel progressionModel) {
        Preconditions.checkNotNull((Object)cruiseId);
        Preconditions.checkNotNull((Object)exportFile);
        Cruise cruise = this.persistenceService.getCruise(cruiseId);
        Preconditions.checkNotNull((Object)cruise);
        this.checkCruise(progressionModel, cruise);
        File basedir = new File(this.context.getConfig().newTempFile("exportCruise"), "exportCruise-" + cruiseId);
        TuttiIOUtil.forceMkdir((File)basedir, (String)"Could not create directory");
        ExportContext exportContext = this.createExportContext(basedir);
        try {
            this.exportCruise(cruise, exportContext, progressionModel);
            TuttiIOUtil.close((Closeable)exportContext, (String)"Could not close export context");
            progressionModel.setMessage(I18n._((String)"tutti.service.exportCruise.buildZip", (Object[])new Object[]{exportFile}));
            TuttiIOUtil.zip((File)basedir, (File)exportFile, (String)"Could not create export zip");
            progressionModel.increments(1);
        }
        finally {
            IOUtils.closeQuietly((Closeable)exportContext);
        }
    }

    protected ExportContext createExportContext(File basedir) {
        return new ExportContext(basedir, this.csvSeparator, this.decoratorService, this.verticalOpeningCaracteristic, this.horizontalOpeningWingCaracteristic, this.horizontalOpeningDoorCaracteristic, this.samplingOrder);
    }

    protected void checkCruise(ProgressionModel progressionModel, Cruise cruise) {
        Preconditions.checkNotNull((Object)cruise);
        progressionModel.setMessage(I18n._((String)"tutti.service.exportCruise.checkCruise", (Object[])new Object[]{cruise.getName()}));
        Map<String, String> errors = this.tuttiWeightComputingService.checkCruise(cruise.getId());
        progressionModel.increments(1);
        if (MapUtils.isNotEmpty(errors)) {
            Decorator<Cruise> cruiseDecorator = this.decoratorService.getDecoratorByType(Cruise.class);
            Decorator<FishingOperation> fishingOperationDecorator = this.decoratorService.getDecoratorByType(FishingOperation.class);
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : errors.entrySet()) {
                String fishingOperationId = entry.getKey();
                FishingOperation fishingOperation = this.persistenceService.getFishingOperation(fishingOperationId);
                String fishingOperationStr = fishingOperationDecorator.toString((Object)fishingOperation);
                sb.append(I18n._((String)"tutti.service.export.invalid.fishingOperation", (Object[])new Object[]{fishingOperationStr, entry.getValue()}));
            }
            String cruiseStr = cruiseDecorator.toString((Object)cruise);
            throw new TuttiBusinessException(I18n._((String)"tutti.service.export.invalid.cruise", (Object[])new Object[]{cruiseStr, sb.toString()}));
        }
    }

    protected void exportCruise(Cruise cruise, ExportContext exportContext, ProgressionModel progressionModel) {
        List<FishingOperation> operations = this.persistenceService.getAllFishingOperation(cruise.getId());
        ArrayList loadedOperations = Lists.newArrayListWithCapacity((int)operations.size());
        for (FishingOperation operation : operations) {
            FishingOperation loadedOeration = this.persistenceService.getFishingOperation(operation.getId());
            loadedOperations.add(loadedOeration);
        }
        String cruiseName = cruise.getName();
        progressionModel.setMessage(I18n._((String)"tutti.service.exportCruise.exportSurvey", (Object[])new Object[]{cruiseName}));
        this.exportSurvey(exportContext, cruise);
        progressionModel.increments(1);
        progressionModel.setMessage(I18n._((String)"tutti.service.exportCruise.exportOperations", (Object[])new Object[]{cruiseName}));
        this.exportOperations(exportContext, cruise, loadedOperations);
        progressionModel.increments(1);
        progressionModel.setMessage(I18n._((String)"tutti.service.exportCruise.exportParameters", (Object[])new Object[]{cruiseName}));
        this.exportParameters(exportContext, cruise, loadedOperations);
        progressionModel.increments(1);
        progressionModel.setMessage(I18n._((String)"tutti.service.exportCruise.exportCatches", (Object[])new Object[]{cruiseName}));
        progressionModel.increments(1);
    }

    protected void exportSurvey(ExportContext exportContext, Cruise cruise) {
        try {
            ArrayList rows = Lists.newArrayList();
            exportContext.surveyModel.prepareRows(rows, cruise, this.country);
            exportContext.surveyExport.write(rows, exportContext.surveyWriter);
        }
        catch (Exception e) {
            throw new TuttiTechnicalException("Could not export survey.", (Throwable)e);
        }
    }

    protected void exportOperations(ExportContext exportContext, Cruise cruise, List<FishingOperation> operations) {
        try {
            ArrayList rows = Lists.newArrayList();
            exportContext.operationModel.prepareRows(rows, cruise, operations);
            exportContext.operationExport.write(rows, exportContext.operationWriter);
        }
        catch (Exception e) {
            throw new TuttiTechnicalException("Could not export operations.", (Throwable)e);
        }
    }

    protected void exportParameters(ExportContext exportContext, Cruise cruise, List<FishingOperation> operations) {
        try {
            for (FishingOperation operation : operations) {
                ArrayList rows = Lists.newArrayList();
                exportContext.parameterModel.prepareRows(rows, cruise, operation);
                exportContext.parameterExport.write(rows, exportContext.parameterWriter);
            }
        }
        catch (Exception e) {
            throw new TuttiTechnicalException("Could not export parameters.", (Throwable)e);
        }
    }

    protected void exportCatches(ExportContext exportContext, Cruise cruise, List<FishingOperation> operations) {
        try {
            for (FishingOperation operation : operations) {
                String operationId = operation.getId();
                CatchBatch catchBatch = this.persistenceService.getCatchBatchFromFishingOperation(operationId);
                BatchContainer<SpeciesBatch> rootSpeciesBatch = this.persistenceService.getRootSpeciesBatch(operationId);
                BatchContainer<BenthosBatch> rootBenthosBatch = this.persistenceService.getRootBenthosBatch(operationId);
                BatchContainer<MarineLitterBatch> rootMarineLitterBatch = this.persistenceService.getRootMarineLitterBatch(operationId);
                this.tuttiWeightComputingService.computeCatchBatchWeights(catchBatch, rootSpeciesBatch, rootBenthosBatch, rootMarineLitterBatch);
                ArrayList rows = Lists.newArrayList();
                exportContext.catchModel.prepareRows(this.persistenceService, rows, cruise, operation, rootSpeciesBatch, rootBenthosBatch);
                exportContext.catchExport.write(rows, exportContext.catchWriter);
            }
        }
        catch (Exception e) {
            throw new TuttiTechnicalException("Could not export catches.", (Throwable)e);
        }
    }

    protected static class ExportContext
    implements Closeable {
        File surveyFile;
        File operationFile;
        File parameterFile;
        File catchFile;
        BufferedWriter surveyWriter;
        BufferedWriter operationWriter;
        BufferedWriter parameterWriter;
        BufferedWriter catchWriter;
        SurveyExportModel surveyModel;
        OperationExportModel operationModel;
        ParameterExportModel parameterModel;
        CatchExportModel catchModel;
        TuttiCsvUtil.TuttiRepeatableExport<SurveyExportRow> surveyExport;
        TuttiCsvUtil.TuttiRepeatableExport<OperationExportRow> operationExport;
        TuttiCsvUtil.TuttiRepeatableExport<ParameterExportRow> parameterExport;
        TuttiCsvUtil.TuttiRepeatableExport<CatchExportRow> catchExport;

        ExportContext(File basedir, char csvSeparator, DecoratorService decoratorService, Caracteristic verticalOpeningCaracteristic, Caracteristic horizontalOpeningWingCaracteristic, Caracteristic horizontalOpeningDoorCaracteristic, List<SampleCategoryEnum> samplingOrder) {
            try {
                this.surveyFile = new File(basedir, "survey.csv");
                this.surveyWriter = Files.newWriter((File)this.surveyFile, (Charset)Charsets.UTF_8);
                this.operationFile = new File(basedir, "operation.csv");
                this.operationWriter = Files.newWriter((File)this.operationFile, (Charset)Charsets.UTF_8);
                this.parameterFile = new File(basedir, "parameter.csv");
                this.parameterWriter = Files.newWriter((File)this.parameterFile, (Charset)Charsets.UTF_8);
                this.catchFile = new File(basedir, "catch.csv");
                this.catchWriter = Files.newWriter((File)this.catchFile, (Charset)Charsets.UTF_8);
            }
            catch (FileNotFoundException e) {
                throw new TuttiTechnicalException("Could not create writer for export", (Throwable)e);
            }
            this.surveyModel = new SurveyExportModel(csvSeparator);
            this.operationModel = new OperationExportModel(csvSeparator, verticalOpeningCaracteristic, horizontalOpeningWingCaracteristic, horizontalOpeningDoorCaracteristic);
            this.parameterModel = new ParameterExportModel(csvSeparator, decoratorService);
            this.catchModel = new CatchExportModel(csvSeparator, samplingOrder);
            this.surveyExport = TuttiCsvUtil.newRepeatableExport(this.surveyModel);
            this.operationExport = TuttiCsvUtil.newRepeatableExport(this.operationModel);
            this.parameterExport = TuttiCsvUtil.newRepeatableExport(this.parameterModel);
            this.catchExport = TuttiCsvUtil.newRepeatableExport(this.catchModel);
        }

        @Override
        public void close() throws IOException {
            IOUtils.closeQuietly((Writer)this.surveyWriter);
            IOUtils.closeQuietly((Writer)this.operationWriter);
            IOUtils.closeQuietly((Writer)this.parameterWriter);
            IOUtils.closeQuietly((Writer)this.catchWriter);
        }
    }
}

