/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.config;

import fr.ifremer.tutti.TuttiIOUtil;
import fr.ifremer.tutti.persistence.config.TuttiPersistenceConfig;
import fr.ifremer.tutti.service.config.TuttiServiceConfigOption;
import java.io.File;
import java.net.URL;
import java.util.List;
import org.nuiton.util.Version;
import org.nuiton.util.config.ApplicationConfig;

public class TuttiServiceConfig {
    protected final ApplicationConfig applicationConfig;
    protected final TuttiPersistenceConfig persistenceConfig;

    public TuttiServiceConfig(ApplicationConfig applicationConfig) {
        this.applicationConfig = applicationConfig;
        this.persistenceConfig = new TuttiPersistenceConfig(applicationConfig);
    }

    public ApplicationConfig getApplicationConfig() {
        return this.applicationConfig;
    }

    public TuttiPersistenceConfig getPersistenceConfig() {
        return this.persistenceConfig;
    }

    public Version getVersion() {
        return this.applicationConfig.getOptionAsVersion(TuttiServiceConfigOption.VERSION.getKey());
    }

    public URL getSiteUrl() {
        return this.applicationConfig.getOptionAsURL(TuttiServiceConfigOption.SITE_URL.getKey());
    }

    public String getOrganizationName() {
        return this.applicationConfig.getOption(TuttiServiceConfigOption.ORGANIZATION_NAME.getKey());
    }

    public int getInceptionYear() {
        return this.applicationConfig.getOptionAsInt(TuttiServiceConfigOption.INCEPTION_YEAR.getKey());
    }

    public File getBasedir() {
        File result = this.applicationConfig.getOptionAsFile(TuttiServiceConfigOption.BASEDIR.getKey());
        return result;
    }

    public File getDataDirectory() {
        File result = this.applicationConfig.getOptionAsFile(TuttiServiceConfigOption.DATA_DIRECTORY.getKey());
        return result;
    }

    public File getTmpDirectory() {
        File result = this.applicationConfig.getOptionAsFile(TuttiServiceConfigOption.TMP_DIRECTORY.getKey());
        return result;
    }

    public File newTempFile(String basename) {
        return new File(this.getTmpDirectory(), basename + "_" + System.nanoTime());
    }

    public char getCsvSeparator() {
        return this.applicationConfig.getOption(TuttiServiceConfigOption.CSV_SEPARATOR.getKey()).charAt(0);
    }

    public String getExportCountryId() {
        return this.applicationConfig.getOption(TuttiServiceConfigOption.EXPORT_COUNTRY_ID.getKey());
    }

    public List<Integer> getSamplingOrderIds() {
        ApplicationConfig.OptionList result = this.applicationConfig.getOptionAsList(TuttiServiceConfigOption.SAMPLING_CATEGORY_ORDER_IDS.getKey());
        return result.getOptionAsInt();
    }

    public void prepareDirectories() {
        File dataDirectory = this.getDataDirectory();
        TuttiIOUtil.forceMkdir((File)dataDirectory, (String)("Could not create data directory " + dataDirectory));
        File tmpDirectory = this.getTmpDirectory();
        if (tmpDirectory.exists()) {
            TuttiIOUtil.deleteDirectory((File)tmpDirectory, (String)("Could not delete temp directory " + tmpDirectory));
        }
        TuttiIOUtil.forceMkdir((File)tmpDirectory, (String)("Could not create temp directory " + tmpDirectory));
    }

    public void setCsvSeparator(char c) {
        this.applicationConfig.setOption(TuttiServiceConfigOption.CSV_SEPARATOR.getKey(), c + "");
    }
}

