/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.translation.ocl.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.andromda.translation.ocl.analysis.AnalysisAdapter;
import org.andromda.translation.ocl.analysis.DepthFirstAdapter;
import org.andromda.translation.ocl.lexer.Lexer;
import org.andromda.translation.ocl.node.AActualParameterList;
import org.andromda.translation.ocl.node.ABarFeatureCallParameterOption;
import org.andromda.translation.ocl.node.AColonFeatureCallParameterOption;
import org.andromda.translation.ocl.node.ACommaExpression;
import org.andromda.translation.ocl.node.ACommaFeatureCallParameterOption;
import org.andromda.translation.ocl.node.AConcreteFeatureCallParameters;
import org.andromda.translation.ocl.node.AEqualExpression;
import org.andromda.translation.ocl.node.AFeatureCallParameters;
import org.andromda.translation.ocl.node.AIterateDeclarator;
import org.andromda.translation.ocl.node.AIterateFeatureCallParameterOption;
import org.andromda.translation.ocl.node.APathName;
import org.andromda.translation.ocl.node.AStandardDeclarator;
import org.andromda.translation.ocl.node.ATypeDeclaration;
import org.andromda.translation.ocl.node.AVariableDeclaration;
import org.andromda.translation.ocl.node.AVariableDeclarationList;
import org.andromda.translation.ocl.node.AVariableDeclarationListTail;
import org.andromda.translation.ocl.node.Node;
import org.andromda.translation.ocl.node.PExpression;
import org.andromda.translation.ocl.node.PFeatureCallParameterOption;
import org.andromda.translation.ocl.node.PVariableDeclaration;
import org.andromda.translation.ocl.node.TName;
import org.andromda.translation.ocl.parser.OclParserException;
import org.andromda.translation.ocl.parser.Parser;

public class OclParser
extends Parser {
    protected Node oclNode;
    protected SyntaxHandler handler = new SyntaxHandler();

    public OclParser(Lexer lexer) {
        super(lexer);
    }

    protected void filter() {
        this.oclNode = this.node;
        this.oclNode.apply(this.handler);
        this.node = this.oclNode;
    }

    protected TName getName(PExpression expression) {
        NameFinder finder = new NameFinder();
        expression.apply(finder);
        return finder.getName();
    }

    private class NameFinder
    extends DepthFirstAdapter {
        private TName foundName;

        private NameFinder() {
        }

        public void caseAPathName(APathName pathName) {
            this.foundName = pathName.getName();
        }

        public TName getName() {
            return this.foundName;
        }
    }

    private class VariableDeclarationListFinder
    extends DepthFirstAdapter {
        private LinkedList orderedNames = new LinkedList();
        private Map namesAndTypes = new HashMap();

        private VariableDeclarationListFinder() {
        }

        public void inAPathName(APathName name) {
            if (this.namesAndTypes.isEmpty()) {
                TName initialVariableName = name.getName();
                this.orderedNames.add(initialVariableName);
                this.namesAndTypes.put(this.orderedNames.getLast(), null);
            }
        }

        public void inACommaFeatureCallParameterOption(ACommaFeatureCallParameterOption commaName) {
            this.orderedNames.add(commaName);
            this.namesAndTypes.put(commaName, null);
        }

        public void inATypeDeclaration(ATypeDeclaration type) {
            if (this.namesAndTypes.containsKey(this.orderedNames.getLast())) {
                this.namesAndTypes.put(this.orderedNames.getLast(), type);
            }
        }

        public AVariableDeclarationList getList() {
            TName initialName = (TName)this.orderedNames.getFirst();
            ATypeDeclaration typeDeclaration = (ATypeDeclaration)this.namesAndTypes.get(initialName);
            ArrayList<AVariableDeclarationListTail> variableDeclarationListTails = new ArrayList<AVariableDeclarationListTail>();
            if (!this.orderedNames.isEmpty()) {
                int orderedNameSize = this.orderedNames.size();
                for (int ctr = 1; ctr < orderedNameSize; ++ctr) {
                    ACommaFeatureCallParameterOption name = (ACommaFeatureCallParameterOption)this.orderedNames.get(ctr);
                    ATypeDeclaration typeDecl = (ATypeDeclaration)this.namesAndTypes.get(name);
                    AVariableDeclaration variableDeclaration = new AVariableDeclaration(OclParser.this.getName(name.getExpression()), typeDecl);
                    variableDeclarationListTails.add(new AVariableDeclarationListTail(name.getComma(), variableDeclaration, null));
                }
            }
            AVariableDeclarationList list = new AVariableDeclarationList((PVariableDeclaration)new AVariableDeclaration(initialName, typeDeclaration), null, variableDeclarationListTails);
            return list;
        }
    }

    private class SyntaxHandler
    extends AnalysisAdapter {
        private SyntaxHandler() {
        }

        public void caseAConcreteFeatureCallParameters(AConcreteFeatureCallParameters featureCallParameters) {
            boolean isDeclarator = false;
            boolean isIterateDeclarator = false;
            LinkedList tail = featureCallParameters.getFeatureCallParameterOption();
            PFeatureCallParameterOption[] parameterOption = new PFeatureCallParameterOption[tail.size()];
            Iterator iter = tail.iterator();
            int ctr = 0;
            while (iter.hasNext()) {
                PFeatureCallParameterOption option;
                parameterOption[ctr] = option = (PFeatureCallParameterOption)iter.next();
                isIterateDeclarator = option instanceof AIterateFeatureCallParameterOption;
                if (!isIterateDeclarator) {
                    isDeclarator = option instanceof ABarFeatureCallParameterOption;
                }
                ++ctr;
            }
            if (isIterateDeclarator && !isDeclarator) {
                throw new OclParserException("Parser Error: Illegal feature call parameters format in \"" + featureCallParameters + "\"; " + "must contain \";\" only if it contains \"|\"");
            }
            AFeatureCallParameters parameters = isIterateDeclarator ? this.getParametersWithIterateDeclarator(featureCallParameters, featureCallParameters.getExpression(), parameterOption) : (isDeclarator ? this.getParametersWithStandardDeclarator(featureCallParameters, parameterOption) : this.getParametersWithoutDeclarator(featureCallParameters, featureCallParameters.getExpression(), parameterOption));
            OclParser.this.oclNode = parameters;
        }

        protected AFeatureCallParameters getParametersWithIterateDeclarator(AConcreteFeatureCallParameters featureCallParameters, PExpression expression, PFeatureCallParameterOption[] parameterOption) {
            AIterateDeclarator iteratorDeclarator = new AIterateDeclarator();
            AColonFeatureCallParameterOption featureCallParameterOption0 = (AColonFeatureCallParameterOption)parameterOption[0];
            AIterateFeatureCallParameterOption featureCallParameterOption1 = (AIterateFeatureCallParameterOption)parameterOption[1];
            ABarFeatureCallParameterOption featureCallParameterOption2 = (ABarFeatureCallParameterOption)parameterOption[2];
            AVariableDeclaration iterator = new AVariableDeclaration(OclParser.this.getName(expression), featureCallParameterOption0.getTypeDeclaration());
            iteratorDeclarator.setIterator(iterator);
            iteratorDeclarator.setSemicolon(featureCallParameterOption1.getSemicolon());
            AVariableDeclaration accumulator = new AVariableDeclaration(featureCallParameterOption1.getName(), featureCallParameterOption1.getTypeDeclaration());
            iteratorDeclarator.setAccumulator(accumulator);
            AEqualExpression equalExpression = new AEqualExpression(featureCallParameterOption1.getEqual(), featureCallParameterOption1.getExpression());
            iteratorDeclarator.setEqualExpression(equalExpression);
            iteratorDeclarator.setBar(featureCallParameterOption2.getBar());
            AActualParameterList params = new AActualParameterList(featureCallParameterOption2.getExpression(), new ArrayList());
            return new AFeatureCallParameters(featureCallParameters.getLParen(), iteratorDeclarator, params, featureCallParameters.getRParen());
        }

        protected AFeatureCallParameters getParametersWithStandardDeclarator(AConcreteFeatureCallParameters featureCallParameters, PFeatureCallParameterOption[] parameterOptions) {
            int parameterOptionNum = parameterOptions.length;
            for (int ctr = 0; ctr < parameterOptionNum - 2; ++ctr) {
                if (parameterOptions[ctr] instanceof ACommaFeatureCallParameterOption || parameterOptions[ctr] instanceof AColonFeatureCallParameterOption) continue;
                throw new OclParserException("OCL Parser Error: Feature call parameters with a standard declarator must have the format \"( name (: type)?, ... , name (: type)? | expression )\"");
            }
            ABarFeatureCallParameterOption barParameterType = (ABarFeatureCallParameterOption)parameterOptions[parameterOptionNum - 1];
            AStandardDeclarator standardDeclarator = new AStandardDeclarator(this.getVariableDeclarationList(featureCallParameters), barParameterType.getBar());
            AActualParameterList params = new AActualParameterList(barParameterType.getExpression(), new ArrayList());
            return new AFeatureCallParameters(featureCallParameters.getLParen(), standardDeclarator, params, featureCallParameters.getRParen());
        }

        protected AFeatureCallParameters getParametersWithoutDeclarator(AConcreteFeatureCallParameters featureCallParameters, PExpression expr, PFeatureCallParameterOption[] parameterOption) {
            ArrayList<ACommaExpression> paramList = new ArrayList<ACommaExpression>();
            for (int ctr = 0; ctr < parameterOption.length; ++ctr) {
                if (!(parameterOption[ctr] instanceof ACommaFeatureCallParameterOption)) {
                    throw new OclParserException("parser error: declarator-less feature call paramaters must have the format \"( expr, ..., expr )\"");
                }
                ACommaFeatureCallParameterOption commaOption = (ACommaFeatureCallParameterOption)parameterOption[ctr];
                ACommaExpression commaExpression = new ACommaExpression(commaOption.getComma(), commaOption.getExpression());
                paramList.add(commaExpression);
            }
            return new AFeatureCallParameters(featureCallParameters.getLParen(), null, new AActualParameterList(expr, paramList), featureCallParameters.getRParen());
        }

        protected AVariableDeclarationList getVariableDeclarationList(AConcreteFeatureCallParameters params) {
            VariableDeclarationListFinder finder = new VariableDeclarationListFinder();
            params.apply(finder);
            return finder.getList();
        }
    }
}

